/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.validator;

import com.sun.faces.util.RequestStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.ValidatorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentValidators {
    private static final String COMPONENT_VALIDATORS = "javax.faces.component.ComponentValidators";
    private LinkedList<ValidatorInfo> validatorStack = new LinkedList();

    public static ComponentValidators getValidators(FacesContext facesContext, boolean bl) {
        Map map = facesContext.getAttributes();
        ComponentValidators componentValidators = (ComponentValidators)map.get(COMPONENT_VALIDATORS);
        if (componentValidators == null && bl) {
            componentValidators = new ComponentValidators();
            map.put(COMPONENT_VALIDATORS, componentValidators);
        }
        return componentValidators;
    }

    public static void addDefaultValidatorsToComponent(FacesContext facesContext, EditableValueHolder editableValueHolder) {
        Set set = facesContext.getApplication().getDefaultValidatorInfo().keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        Set set2 = (Set)RequestStateManager.remove(facesContext, "com.sun.faces.DISABLED_VALIDATORS");
        for (String string : set) {
            if (set2 != null && set2.contains(string)) continue;
            arrayList.add(string);
        }
        ComponentValidators.addValidatorsToComponent(facesContext, arrayList, editableValueHolder, null);
    }

    public void addValidators(FacesContext facesContext, EditableValueHolder editableValueHolder) {
        if (this.validatorStack == null || this.validatorStack.isEmpty()) {
            ComponentValidators.addDefaultValidatorsToComponent(facesContext, editableValueHolder);
            return;
        }
        Application application = facesContext.getApplication();
        Map map = application.getDefaultValidatorInfo();
        Set set = map.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        for (String string : set) {
            arrayList.add(string);
        }
        Set set2 = (Set)RequestStateManager.remove(facesContext, "com.sun.faces.DISABLED_VALIDATORS");
        int n = this.validatorStack.size();
        for (int i = n - 1; i >= 0; --i) {
            ValidatorInfo validatorInfo = this.validatorStack.get(i);
            if (!validatorInfo.isEnabled() || set2 != null && set2.contains(validatorInfo.getValidatorId())) {
                if (!arrayList.contains(validatorInfo.getValidatorId())) continue;
                arrayList.remove(validatorInfo.getValidatorId());
                continue;
            }
            if (arrayList.contains(validatorInfo.getValidatorId())) continue;
            arrayList.add(validatorInfo.getValidatorId());
        }
        ComponentValidators.addValidatorsToComponent(facesContext, arrayList, editableValueHolder, this.validatorStack == null || this.validatorStack.isEmpty() ? null : this.validatorStack);
    }

    public void pushValidatorInfo(ValidatorInfo validatorInfo) {
        this.validatorStack.add(validatorInfo);
    }

    public void popValidatorInfo() {
        if (this.validatorStack.size() > 0) {
            this.validatorStack.removeLast();
        }
    }

    private static void addValidatorsToComponent(FacesContext facesContext, Collection<String> collection, EditableValueHolder editableValueHolder, LinkedList<ValidatorInfo> linkedList) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Application application = facesContext.getApplication();
        Map map = application.getDefaultValidatorInfo();
        Validator validator = editableValueHolder.getValidators();
        block0: for (Map.Entry object : map.entrySet()) {
            for (Validator validator2 : validator) {
                if (!((String)object.getValue()).equals(validator2.getClass().getName())) continue;
                collection.remove(object.getKey());
                continue block0;
            }
        }
        for (String string : collection) {
            Validator validator3 = application.createValidator(string);
            if (linkedList != null) {
                for (int i = linkedList.size() - 1; i >= 0; --i) {
                    ValidatorInfo validatorInfo = linkedList.get(i);
                    if (!string.equals(validatorInfo.getValidatorId())) continue;
                    validatorInfo.applyAttributes(validator3);
                    break;
                }
            }
            editableValueHolder.addValidator(validator3);
        }
    }

    public static class ValidatorInfo {
        private String validatorId;
        private boolean enabled;
        private ValidatorHandler owner;
        private FaceletContext ctx;

        public ValidatorInfo(FaceletContext faceletContext, ValidatorHandler validatorHandler) {
            this.owner = validatorHandler;
            this.ctx = faceletContext;
            this.validatorId = validatorHandler.getValidatorId(faceletContext);
            this.enabled = !validatorHandler.isDisabled(faceletContext);
        }

        public String getValidatorId() {
            return this.validatorId;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void applyAttributes(Validator validator) {
            this.owner.setAttributes(this.ctx, (Object)validator);
        }
    }
}

