/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.facelets.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public final class ActionListenerHandler
extends TagHandlerImpl
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private String listenerType;
    private final TagAttribute typeAttribute = this.getAttribute("type");

    public ActionListenerHandler(TagConfig tagConfig) {
        super(tagConfig);
        if (null != this.typeAttribute) {
            String string = null;
            if (!this.typeAttribute.isLiteral()) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
                string = (String)this.typeAttribute.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
            } else {
                string = this.typeAttribute.getValue();
            }
            this.checkType(string);
            this.listenerType = string;
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        if (null == uIComponent || !ComponentHandler.isNew((UIComponent)uIComponent)) {
            return;
        }
        if (uIComponent instanceof ActionSource) {
            this.applyAttachedObject(faceletContext.getFacesContext(), uIComponent);
        } else if (uIComponent.getAttributes().containsKey("javax.faces.application.Resource.ComponentResource")) {
            if (null == this.getFor()) {
                throw new TagException(this.tag, "actionListener tags nested within composite components must have a non-null \"for\" attribute");
            }
            CompositeComponentTagHandler.getAttachedObjectHandlers(uIComponent).add((AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not of type ActionSource, type is: " + uIComponent);
        }
    }

    public void applyAttachedObject(FacesContext facesContext, UIComponent uIComponent) {
        FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        ActionSource actionSource = (ActionSource)uIComponent;
        ValueExpression valueExpression = null;
        if (this.binding != null) {
            valueExpression = this.binding.getValueExpression(faceletContext, ActionListener.class);
        }
        LazyActionListener lazyActionListener = new LazyActionListener(this.listenerType, valueExpression);
        actionSource.addActionListener((ActionListener)lazyActionListener);
    }

    public String getFor() {
        String string = null;
        TagAttribute tagAttribute = this.getAttribute("for");
        if (null != tagAttribute) {
            if (tagAttribute.isLiteral()) {
                string = tagAttribute.getValue();
            } else {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
                string = (String)tagAttribute.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
            }
        }
        return string;
    }

    private void checkType(String string) {
        try {
            ReflectionUtil.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TagAttributeException(this.typeAttribute, "Couldn't qualify ActionListener", (Throwable)classNotFoundException);
        }
    }

    private static final class LazyActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -9202120013153262119L;
        private final String type;
        private final ValueExpression binding;

        public LazyActionListener(String string, ValueExpression valueExpression) {
            this.type = string;
            this.binding = valueExpression;
        }

        public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
            ActionListener actionListener = null;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return;
            }
            if (this.binding != null) {
                actionListener = (ActionListener)this.binding.getValue(facesContext.getELContext());
            }
            if (actionListener == null && this.type != null) {
                try {
                    actionListener = (ActionListener)ReflectionUtil.forName(this.type).newInstance();
                }
                catch (Exception exception) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", (Throwable)exception);
                }
                if (this.binding != null) {
                    this.binding.setValue(facesContext.getELContext(), (Object)actionListener);
                }
            }
            if (actionListener != null) {
                actionListener.processAction(actionEvent);
            }
        }
    }
}

