/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.Base64InputStream;
import com.sun.faces.io.Base64OutputStreamWriter;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.FacesLogger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ClientSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ByteArrayGuard guard;
    private boolean stateTimeoutEnabled;
    private long stateTimeout;
    private int csBuffSize;

    public ClientSideStateHelper() {
        this.init();
    }

    public void writeState(FacesContext facesContext, Object object, StringBuilder stringBuilder) throws IOException {
        if (stringBuilder != null) {
            this.doWriteState(facesContext, object, new StringBuilderWriter(stringBuilder));
        } else {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.write(this.stateFieldStart);
            this.doWriteState(facesContext, object, (Writer)responseWriter);
            responseWriter.write(this.stateFieldEnd);
            this.writeRenderKitIdField(facesContext, responseWriter);
        }
    }

    public Object getState(FacesContext facesContext, String string) throws IOException {
        String string2 = ClientSideStateHelper.getStateParamValue(facesContext);
        if (string2 == null) {
            return null;
        }
        return this.doGetState(facesContext, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doGetState(FacesContext facesContext, String string) {
        if ("stateless".equals(string)) {
            return null;
        }
        ObjectInputStream objectInputStream = null;
        InputStream inputStream = new Base64InputStream(string);
        try {
            Object object;
            if (this.guard != null) {
                byte[] byArray = string.getBytes();
                int n = inputStream.read(byArray, 0, byArray.length);
                object = new byte[n];
                inputStream.reset();
                inputStream.read((byte[])object, 0, ((byte[])object).length);
                byArray = this.guard.decrypt(facesContext, (byte[])object);
                if (byArray == null) {
                    Object var8_13 = null;
                    return var8_13;
                }
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.compressViewState) {
                inputStream = new GZIPInputStream(inputStream);
            }
            objectInputStream = this.serialProvider.createObjectInputStream(inputStream);
            long l = 0L;
            if (this.stateTimeoutEnabled) {
                try {
                    l = objectInputStream.readLong();
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Client state timeout is enabled, but unable to find the time marker in the serialized state.  Assuming state to be old and returning null.");
                    }
                    Object var8_14 = null;
                    if (objectInputStream == null) return var8_14;
                    try {
                        objectInputStream.close();
                        return var8_14;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return var8_14;
                }
            }
            object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (l != 0L && this.hasStateExpired(l)) {
                Object var9_18 = null;
                return var9_18;
            }
            Object[] objectArray = new Object[]{object, object2};
            return objectArray;
        }
        catch (OptionalDataException optionalDataException) {
            if (!LOGGER.isLoggable(Level.SEVERE)) throw new FacesException((Throwable)optionalDataException);
            LOGGER.log(Level.SEVERE, optionalDataException.getMessage(), optionalDataException);
            throw new FacesException((Throwable)optionalDataException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!LOGGER.isLoggable(Level.SEVERE)) throw new FacesException((Throwable)classNotFoundException);
            LOGGER.log(Level.SEVERE, classNotFoundException.getMessage(), classNotFoundException);
            throw new FacesException((Throwable)classNotFoundException);
        }
        catch (IOException iOException) {
            if (!LOGGER.isLoggable(Level.SEVERE)) throw new FacesException((Throwable)iOException);
            LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
            throw new FacesException((Throwable)iOException);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteState(FacesContext facesContext, Object object, Writer writer) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = null;
        outputStream = this.compressViewState ? new GZIPOutputStream((OutputStream)byteArrayOutputStream, this.csBuffSize) : byteArrayOutputStream;
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = this.serialProvider.createObjectOutputStream(new BufferedOutputStream(outputStream));
            if (this.stateTimeoutEnabled) {
                objectOutputStream.writeLong(System.currentTimeMillis());
            }
            Object[] objectArray = (Object[])object;
            objectOutputStream.writeObject(objectArray[0]);
            objectOutputStream.writeObject(objectArray[1]);
            objectOutputStream.flush();
            objectOutputStream.close();
            objectOutputStream = null;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.guard != null) {
                byArray = this.guard.encrypt(facesContext, byArray);
            }
            Base64OutputStreamWriter base64OutputStreamWriter = new Base64OutputStreamWriter(byArray.length, writer);
            base64OutputStreamWriter.write(byArray, 0, byArray.length);
            base64OutputStreamWriter.finish();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Client State: total number of characters written: {0}", base64OutputStreamWriter.getTotalCharsWritten());
            }
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean hasStateExpired(long l) {
        if (this.stateTimeoutEnabled) {
            long l2 = (System.currentTimeMillis() - l) / 60000L;
            return l2 > this.stateTimeout;
        }
        return false;
    }

    protected void init() {
        String string;
        String string2 = this.webConfig.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ClientStateSavingPassword);
        if (string2 != null) {
            this.guard = new ByteArrayGuard();
        }
        this.stateTimeoutEnabled = this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
        if (this.stateTimeoutEnabled) {
            string = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
            try {
                this.stateTimeout = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.stateTimeout = Long.parseLong(WebConfiguration.WebContextInitParameter.ClientStateTimeout.getDefaultValue());
            }
        }
        string = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize);
        String string3 = WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getDefaultValue();
        try {
            this.csBuffSize = Integer.parseInt(string);
            if (this.csBuffSize % 2 != 0) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_div_two", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), string, string3});
                }
                this.csBuffSize = Integer.parseInt(string3);
            } else {
                this.csBuffSize /= 2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using client state buffer size of " + this.csBuffSize);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_not_integer", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), string, string3});
            }
            this.csBuffSize = Integer.parseInt(string3);
        }
    }

    protected static final class StringBuilderWriter
    extends Writer {
        private StringBuilder sb;

        protected StringBuilderWriter(StringBuilder stringBuilder) {
            this.sb = stringBuilder;
        }

        public void write(int n) throws IOException {
            this.sb.append((char)n);
        }

        public void write(char[] cArray) throws IOException {
            this.sb.append(cArray);
        }

        public void write(String string) throws IOException {
            this.sb.append(string);
        }

        public void write(String string, int n, int n2) throws IOException {
            this.sb.append(string.toCharArray(), n, n2);
        }

        public Writer append(CharSequence charSequence) throws IOException {
            this.sb.append(charSequence);
            return this;
        }

        public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
            this.sb.append(charSequence, n, n2);
            return this;
        }

        public Writer append(char c) throws IOException {
            this.sb.append(c);
            return this;
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.sb.append(cArray, n, n2);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

