/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.context.StateContext;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagementStrategyImpl
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private final ViewDeclarationLanguageFactory vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveView(FacesContext facesContext) {
        if (facesContext == null) {
            return null;
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot.isTransient()) {
            return null;
        }
        Util.checkIdUniqueness(facesContext, (UIComponent)uIViewRoot, new HashSet<String>(uIViewRoot.getChildCount() << 1));
        final HashMap<String, Object> hashMap = new HashMap<String, Object>();
        final StateContext stateContext = StateContext.getStateContext(facesContext);
        facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
        EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
        final FacesContext facesContext2 = facesContext;
        try {
            uIViewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    VisitResult visitResult = VisitResult.ACCEPT;
                    if (!uIComponent.isTransient()) {
                        Object object;
                        if (stateContext.componentAddedDynamically(uIComponent)) {
                            uIComponent.getAttributes().put("com.sun.faces.DynamicComponent", new Integer(uIComponent.getParent().getChildren().indexOf(uIComponent)));
                            object = new StateHolderSaver(facesContext2, uIComponent);
                        } else {
                            object = uIComponent.saveState(visitContext.getFacesContext());
                        }
                        if (null != object) {
                            hashMap.put(uIComponent.getClientId(visitContext.getFacesContext()), object);
                        }
                    } else {
                        return visitResult;
                    }
                    return visitResult;
                }
            });
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        this.saveDynamicActions(facesContext, stateContext, hashMap);
        return new Object[]{null, hashMap};
    }

    private void saveDynamicActions(FacesContext facesContext, StateContext stateContext, Map<String, Object> map) {
        List<ComponentStruct> list = stateContext.getDynamicActions();
        if (list != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (ComponentStruct componentStruct : list) {
                arrayList.add(componentStruct.saveState(facesContext));
            }
            map.put("com.sun.faces.DynamicActions", arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext facesContext, String string, String string2) {
        UIViewRoot uIViewRoot;
        Object[] objectArray;
        ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string2);
        boolean bl = facesContext.isProcessingEvents();
        try {
            objectArray = this.vdlFactory.getViewDeclarationLanguage(string);
            uIViewRoot = objectArray.getViewMetadata(facesContext, string).createMetadataView(facesContext);
            facesContext.setViewRoot(uIViewRoot);
            facesContext.setProcessingEvents(true);
            objectArray.buildView(facesContext, uIViewRoot);
        }
        catch (IOException iOException) {
            throw new FacesException((Throwable)iOException);
        }
        objectArray = (Object[])responseStateManager.getState(facesContext, string);
        if (objectArray == null) {
            return null;
        }
        final Map map = (Map)objectArray[1];
        final StateContext stateContext = StateContext.getStateContext(facesContext);
        if (null != map) {
            try {
                stateContext.setTrackViewModifications(false);
                Application application = facesContext.getApplication();
                facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
                EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION, VisitHint.EXECUTE_LIFECYCLE);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
                uIViewRoot.visitTree(visitContext, new VisitCallback(){

                    public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                        VisitResult visitResult = VisitResult.ACCEPT;
                        String string = uIComponent.getClientId(visitContext.getFacesContext());
                        Object v = map.get(string);
                        if (v != null && !stateContext.componentAddedDynamically(uIComponent)) {
                            boolean bl = true;
                            if (v instanceof StateHolderSaver) {
                                boolean bl2 = bl = !((StateHolderSaver)v).componentAddedDynamically();
                            }
                            if (bl) {
                                try {
                                    uIComponent.restoreState(visitContext.getFacesContext(), v);
                                }
                                catch (Exception exception) {
                                    String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.partial.statesaving.ERROR_RESTORING_STATE_FOR_COMPONENT", string, exception.toString());
                                    throw new FacesException(string2, (Throwable)exception);
                                }
                            }
                        }
                        return visitResult;
                    }
                });
                this.restoreDynamicActions(facesContext, stateContext, map);
            }
            finally {
                stateContext.setTrackViewModifications(true);
                facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
            }
        } else {
            uIViewRoot = null;
        }
        facesContext.setProcessingEvents(bl);
        return uIViewRoot;
    }

    private void restoreDynamicActions(FacesContext facesContext, StateContext stateContext, Map<String, Object> map) {
        List list = (List)map.get("com.sun.faces.DynamicActions");
        List<ComponentStruct> list2 = stateContext.getDynamicActions();
        if (list != null && !list.isEmpty()) {
            for (Object e : list) {
                ComponentStruct componentStruct = new ComponentStruct();
                componentStruct.restoreState(facesContext, e);
                if ("ADD".equals(componentStruct.action)) {
                    this.restoreDynamicAdd(facesContext, map, componentStruct);
                }
                if ("REMOVE".equals(componentStruct.action)) {
                    this.restoreDynamicRemove(facesContext, componentStruct);
                }
                this.pruneAndReAddToDynamicActions(list2, componentStruct);
            }
        }
    }

    private void pruneAndReAddToDynamicActions(List<ComponentStruct> list, ComponentStruct componentStruct) {
        int n = list.indexOf(componentStruct);
        if (n == -1) {
            list.add(componentStruct);
        } else {
            int n2 = list.lastIndexOf(componentStruct);
            if (n2 == -1 || n2 == n) {
                list.add(componentStruct);
            } else {
                list.remove(n2);
                list.remove(n);
                list.add(componentStruct);
            }
        }
    }

    private void restoreDynamicAdd(FacesContext facesContext, Map<String, Object> map, ComponentStruct componentStruct) {
        UIComponent uIComponent = this.findComponent(facesContext, componentStruct.parentClientId);
        if (uIComponent != null) {
            UIComponent uIComponent2 = this.findComponent(facesContext, componentStruct.clientId);
            if (uIComponent2 != null) {
                if (componentStruct.facetName == null) {
                    uIComponent.getChildren().remove(uIComponent2);
                }
            } else {
                StateHolderSaver stateHolderSaver = (StateHolderSaver)map.get(componentStruct.clientId);
                if (stateHolderSaver != null) {
                    uIComponent2 = (UIComponent)stateHolderSaver.restore(facesContext);
                } else {
                    System.out.println("Unable to find state for component with clientId '" + componentStruct.clientId + "', not restoring it.");
                }
            }
            if (uIComponent2 != null) {
                if (componentStruct.facetName != null) {
                    uIComponent.getFacets().put(componentStruct.facetName, uIComponent2);
                } else {
                    uIComponent2.setId(componentStruct.id);
                    uIComponent.getChildren().add(uIComponent2);
                    uIComponent2.getClientId();
                }
            }
        } else {
            System.out.println("Unable to find parent component with clientId '" + componentStruct.parentClientId + "', not adding child.");
        }
    }

    private void restoreDynamicRemove(FacesContext facesContext, ComponentStruct componentStruct) {
        UIComponent uIComponent = this.findComponent(facesContext, componentStruct.clientId);
        if (uIComponent != null) {
            UIComponent uIComponent2 = uIComponent.getParent();
            uIComponent2.getChildren().remove(uIComponent);
        } else {
            System.out.println("Unable to find component with clientId '" + componentStruct.clientId + "', no need to remove it.");
        }
    }

    private UIComponent findComponent(FacesContext facesContext, final String string) {
        UIComponent uIComponent = facesContext.getViewRoot().findComponent(string);
        if (uIComponent == null) {
            final ArrayList arrayList = new ArrayList();
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext);
            facesContext.getViewRoot().visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    VisitResult visitResult = VisitResult.ACCEPT;
                    if (uIComponent.getClientId(visitContext.getFacesContext()).equals(string)) {
                        arrayList.add(uIComponent);
                        visitResult = VisitResult.COMPLETE;
                    }
                    return visitResult;
                }
            });
            if (!arrayList.isEmpty()) {
                uIComponent = (UIComponent)arrayList.get(0);
            }
        }
        return uIComponent;
    }
}

