/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String COMPONENT = "component";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String COMPONENT_CLASS = "component-class";

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        this.processAnnotations(FacesComponent.class);
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing component elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, COMPONENT);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.addComponents(nodeList, string);
        }
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void addComponents(NodeList nodeList, String string) throws XPathExpressionException {
        Application application = this.getApplication();
        Verifier verifier = Verifier.getCurrentInstance();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            String string2 = null;
            String string3 = null;
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                if (COMPONENT_TYPE.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (!COMPONENT_CLASS.equals(node2.getLocalName())) continue;
                string3 = this.getNodeText(node2);
            }
            if (string2 == null || string3 == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addComponent({0},{1})", string2, string3));
            }
            if (verifier != null) {
                verifier.validateObject(Verifier.ObjectType.COMPONENT, string3, UIComponent.class);
            }
            application.addComponent(string2, string3);
        }
    }
}

