/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.config.processor.SharedUtils;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String NAVIGATION_RULE = "navigation-rule";
    private static final String FROM_VIEW_ID = "from-view-id";
    private static final String NAVIGATION_CASE = "navigation-case";
    private static final String FROM_ACTION = "from-action";
    private static final String FROM_OUTCOME = "from-outcome";
    private static final String IF = "if";
    private static final String TO_VIEW_ID = "to-view-id";
    private static final String REDIRECT = "redirect";
    private static final String VIEW_PARAM = "view-param";
    private static final String VIEW_PARAM_NAME = "name";
    private static final String VIEW_PARAM_VALUE = "value";
    private static final String INCLUDE_VIEW_PARAMS_ATTRIBUTE = "include-view-params";
    private static final String FROM_VIEW_ID_DEFAULT = "*";

    @Override
    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        NavigationHandler navigationHandler = this.getApplication().getNavigationHandler();
        for (DocumentInfo documentInfo : documentInfoArray) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing navigation-rule elements for document: ''{0}''", documentInfo.getSourceURI()));
            }
            Document document = documentInfo.getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, NAVIGATION_RULE);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.addNavigationRules(nodeList, navigationHandler, servletContext);
        }
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void addNavigationRules(NodeList nodeList, NavigationHandler navigationHandler, ServletContext servletContext) throws XPathExpressionException {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NodeList nodeList2 = node.getChildNodes();
            String string = FROM_VIEW_ID_DEFAULT;
            ArrayList<Node> arrayList = null;
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1) continue;
                if (FROM_VIEW_ID.equals(node2.getLocalName())) {
                    String string2 = this.getNodeText(node2);
                    String string3 = string = string2 == null ? FROM_VIEW_ID_DEFAULT : string2;
                    if (string.equals(FROM_VIEW_ID_DEFAULT) || string.charAt(0) == '/') continue;
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "jsf.config.navigation.from_view_id_leading_slash", new String[]{string});
                    }
                    string = '/' + string;
                    continue;
                }
                if (!NAVIGATION_CASE.equals(node2.getLocalName())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Node>(n2);
                }
                arrayList.add(node2);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing navigation rule with 'from-view-id' of ''{0}''", string));
            }
            this.addNavigationCasesForRule(string, arrayList, navigationHandler, servletContext);
        }
    }

    private void addNavigationCasesForRule(String string, List<Node> list, NavigationHandler navigationHandler, ServletContext servletContext) {
        if (list != null && !list.isEmpty()) {
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(servletContext);
            for (Node node : list) {
                Object object;
                if (node.getNodeType() != 1) continue;
                NodeList nodeList = node.getChildNodes();
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                Map<String, List<String>> map = null;
                boolean bl = false;
                boolean bl2 = false;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    String string6;
                    object = nodeList.item(i);
                    if (object.getNodeType() != 1) continue;
                    if (FROM_OUTCOME.equals(object.getLocalName())) {
                        string2 = this.getNodeText((Node)object);
                        continue;
                    }
                    if (FROM_ACTION.equals(object.getLocalName())) {
                        string3 = this.getNodeText((Node)object);
                        continue;
                    }
                    if (IF.equals(object.getLocalName())) {
                        string6 = this.getNodeText((Node)object);
                        if (SharedUtils.isExpression(string6) && !SharedUtils.isMixedExpression(string6)) {
                            string4 = string6;
                            continue;
                        }
                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, "jsf.config.navigation.if_invalid_expression", new String[]{string6, string});
                        continue;
                    }
                    if (TO_VIEW_ID.equals(object.getLocalName())) {
                        string6 = this.getNodeText((Node)object);
                        if (string6.charAt(0) != '/' && string6.charAt(0) != '#') {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "jsf.config.navigation.to_view_id_leading_slash", new String[]{string6, string});
                            }
                            string5 = '/' + string6;
                            continue;
                        }
                        string5 = string6;
                        continue;
                    }
                    if (!REDIRECT.equals(object.getLocalName())) continue;
                    map = this.processParameters(object.getChildNodes());
                    bl2 = this.isIncludeViewParams((Node)object);
                    bl = true;
                }
                NavigationCase navigationCase = new NavigationCase(string, string3, string2, string4, string5, map, bl, bl2);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding NavigationCase: {0}", navigationCase.toString()));
                }
                if (navigationHandler instanceof ConfigurableNavigationHandler) {
                    ConfigurableNavigationHandler configurableNavigationHandler = (ConfigurableNavigationHandler)navigationHandler;
                    object = (Set)configurableNavigationHandler.getNavigationCases().get(string);
                    if (object == null) {
                        object = new LinkedHashSet<NavigationCase>();
                        configurableNavigationHandler.getNavigationCases().put(string, object);
                    }
                    object.add(navigationCase);
                }
                applicationAssociate.addNavigationCase(navigationCase);
            }
        }
    }

    private Map<String, List<String>> processParameters(NodeList nodeList) {
        LinkedHashMap<String, ArrayList<String>> linkedHashMap = null;
        if (nodeList.getLength() > 0) {
            linkedHashMap = new LinkedHashMap<String, ArrayList<String>>(4, 1.0f);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !VIEW_PARAM.equals(node.getLocalName())) continue;
                String string = null;
                String string2 = null;
                NodeList nodeList2 = node.getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() != 1) continue;
                    if (VIEW_PARAM_NAME.equals(node2.getLocalName())) {
                        string = this.getNodeText(node2);
                    }
                    if (!VIEW_PARAM_VALUE.equals(node2.getLocalName())) continue;
                    string2 = this.getNodeText(node2);
                }
                if (string == null) continue;
                ArrayList<String> arrayList = (ArrayList<String>)linkedHashMap.get(string);
                if (arrayList == null && string2 != null) {
                    arrayList = new ArrayList<String>(2);
                    linkedHashMap.put(string, arrayList);
                }
                if (arrayList == null) continue;
                arrayList.add(string2);
            }
        }
        return linkedHashMap;
    }

    private boolean isIncludeViewParams(Node node) {
        return Boolean.valueOf(this.getNodeText(node.getAttributes().getNamedItem(INCLUDE_VIEW_PARAMS_ATTRIBUTE)));
    }
}

