/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.impl.DefaultFaceletContext;
import com.sun.faces.facelets.impl.DefaultFaceletFactory;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;

final class DefaultFacelet
extends Facelet {
    private static final Logger log = FacesLogger.FACELETS_FACELET.getLogger();
    private static final String APPLIED_KEY = "com.sun.faces.facelets.APPLIED";
    private static final String JAVAX_FACES_ERROR_XHTML = "javax.faces.error.xhtml";
    private final String alias;
    private final ExpressionFactory elFactory;
    private final DefaultFaceletFactory factory;
    private final long createTime;
    private final long refreshPeriod;
    private final Map<String, URL> relativePaths;
    private final FaceletHandler root;
    private final URL src;
    private IdMapper mapper;

    public DefaultFacelet(DefaultFaceletFactory defaultFaceletFactory, ExpressionFactory expressionFactory, URL uRL, String string, FaceletHandler faceletHandler) {
        this.factory = defaultFaceletFactory;
        this.elFactory = expressionFactory;
        this.src = uRL;
        this.root = faceletHandler;
        this.alias = string;
        this.mapper = defaultFaceletFactory.idMappers.get(string);
        this.createTime = System.currentTimeMillis();
        this.refreshPeriod = this.factory.getRefreshPeriod();
        this.relativePaths = new WeakHashMap<String, URL>();
    }

    public void apply(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        IdMapper idMapper = IdMapper.getMapper(facesContext);
        boolean bl = false;
        if (idMapper == null) {
            IdMapper.setMapper(facesContext, this.mapper);
            bl = true;
        }
        DefaultFaceletContext defaultFaceletContext = new DefaultFaceletContext(facesContext, this);
        this.refresh(uIComponent);
        ComponentSupport.markForDeletion(uIComponent);
        this.root.apply((FaceletContext)defaultFaceletContext, uIComponent);
        ComponentSupport.finalizeForDeletion(uIComponent);
        this.markApplied(uIComponent);
        if (bl) {
            IdMapper.setMapper(facesContext, null);
        }
    }

    private void refresh(UIComponent uIComponent) {
        if (this.refreshPeriod > 0L) {
            Object object;
            Object object2;
            Object object3;
            Collection<Object> collection;
            int n = uIComponent.getChildCount();
            if (n > 0) {
                collection = uIComponent.getChildren();
                while (--n >= 0) {
                    object3 = (UIComponent)collection.get(n);
                    if (object3.isTransient() || (object2 = (ApplyToken)object3.getAttributes().get(APPLIED_KEY)) == null || object2.time >= this.createTime || !object2.alias.equals(this.alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        object = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this.alias + "] was modified @ " + ((DateFormat)object).format(new Date(this.createTime)) + ", flushing component applied @ " + ((DateFormat)object).format(new Date(object2.time)));
                    }
                    collection.remove(n);
                }
            }
            if (uIComponent.getFacets().size() > 0) {
                collection = uIComponent.getFacets().values();
                object = collection.iterator();
                while (object.hasNext()) {
                    object2 = (UIComponent)object.next();
                    if (object2.isTransient() || (object3 = (ApplyToken)object2.getAttributes().get(APPLIED_KEY)) == null || object3.time >= this.createTime || !object3.alias.equals(this.alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        DateFormat dateFormat = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this.alias + "] was modified @ " + dateFormat.format(new Date(this.createTime)) + ", flushing component applied @ " + dateFormat.format(new Date(object3.time)));
                    }
                    object.remove();
                }
            }
        }
    }

    private void markApplied(UIComponent uIComponent) {
        if (this.refreshPeriod > 0L) {
            Iterator iterator = uIComponent.getFacetsAndChildren();
            ApplyToken applyToken = new ApplyToken(this.alias, System.currentTimeMillis() + this.refreshPeriod);
            while (iterator.hasNext()) {
                Map map;
                UIComponent uIComponent2 = (UIComponent)iterator.next();
                if (uIComponent2.isTransient() || (map = uIComponent2.getAttributes()).containsKey(APPLIED_KEY)) continue;
                map.put(APPLIED_KEY, applyToken);
            }
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.elFactory;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    private URL getRelativePath(String string) throws IOException {
        URL uRL = this.relativePaths.get(string);
        if (uRL == null) {
            uRL = this.factory.resolveURL(this.src, string);
            this.relativePaths.put(string, uRL);
        }
        return uRL;
    }

    public URL getSource() {
        return this.src;
    }

    private void include(DefaultFaceletContext defaultFaceletContext, UIComponent uIComponent) throws IOException {
        this.refresh(uIComponent);
        this.root.apply((FaceletContext)new DefaultFaceletContext(defaultFaceletContext, this), uIComponent);
        this.markApplied(uIComponent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void include(DefaultFaceletContext defaultFaceletContext, UIComponent uIComponent, String string) throws IOException {
        URL uRL;
        if (string.equals(JAVAX_FACES_ERROR_XHTML)) {
            if (!this.isDevelopment(defaultFaceletContext)) return;
            uRL = this.getErrorFacelet(DefaultFacelet.class.getClassLoader());
            if (uRL == null) {
                uRL = this.getErrorFacelet(Util.getCurrentLoader(this));
            }
        } else {
            uRL = this.getRelativePath(string);
        }
        this.include(defaultFaceletContext, uIComponent, uRL);
    }

    public void include(DefaultFaceletContext defaultFaceletContext, UIComponent uIComponent, URL uRL) throws IOException {
        DefaultFacelet defaultFacelet = (DefaultFacelet)this.factory.getFacelet(uRL);
        defaultFacelet.include(defaultFaceletContext, uIComponent);
    }

    public String toString() {
        return this.alias;
    }

    private boolean isDevelopment(FaceletContext faceletContext) {
        return faceletContext.getFacesContext().isProjectStage(ProjectStage.Development);
    }

    private URL getErrorFacelet(ClassLoader classLoader) {
        return classLoader.getResource("META-INF/error-include.xhtml");
    }

    private static class ApplyToken
    implements Externalizable {
        public String alias;
        public long time;

        public ApplyToken() {
        }

        public ApplyToken(String string, long l) {
            this.alias = string;
            this.time = l;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.alias = objectInput.readUTF();
            this.time = objectInput.readLong();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.alias);
            objectOutput.writeLong(this.time);
        }
    }
}

