/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.compiler.CompilationMessageHolder;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagLibrary;
import com.sun.faces.util.Util;
import java.lang.reflect.Method;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public final class CompositeTagLibrary
implements TagLibrary {
    private TagLibrary[] libraries;
    private CompilationMessageHolder messageHolder;

    public CompositeTagLibrary(TagLibrary[] tagLibraryArray, CompilationMessageHolder compilationMessageHolder) {
        Util.notNull("libraries", tagLibraryArray);
        this.libraries = tagLibraryArray;
        this.messageHolder = compilationMessageHolder;
    }

    public CompositeTagLibrary(TagLibrary[] tagLibraryArray) {
        this(tagLibraryArray, null);
    }

    public boolean containsNamespace(String string, Tag tag) {
        boolean bl = true;
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsNamespace(string, null)) continue;
            return true;
        }
        CompositeComponentTagLibrary compositeComponentTagLibrary = new CompositeComponentTagLibrary(string);
        if (compositeComponentTagLibrary.tagLibraryForNSExists(string)) {
            TagLibrary[] tagLibraryArray = new TagLibrary[this.libraries.length + 1];
            System.arraycopy(this.libraries, 0, tagLibraryArray, 0, this.libraries.length);
            tagLibraryArray[this.libraries.length] = new CompositeComponentTagLibrary(string);
            for (int i = 0; i < this.libraries.length; ++i) {
                this.libraries[i] = null;
            }
            this.libraries = tagLibraryArray;
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.isProjectStage(ProjectStage.Development) && null != tag && !string.equals("http://www.w3.org/1999/xhtml")) {
            assert (null != this.messageHolder);
            String string2 = this.getPrefixFromTag(tag);
            if (null != string2) {
                List<FacesMessage> list = this.messageHolder.getNamespacePrefixMessages(facesContext, string2);
                list.add(new FacesMessage(FacesMessage.SEVERITY_WARN, "Warning: This page calls for XML namespace " + string + " declared with prefix " + string2 + " but no taglibrary exists for that namespace.", ""));
            }
        }
        return false;
    }

    private String getPrefixFromTag(Tag tag) {
        int n;
        String string = tag.getQName();
        if (null != string && -1 != (n = string.indexOf(":"))) {
            string = string.substring(0, n);
        }
        return string;
    }

    public boolean containsTagHandler(String string, String string2) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsTagHandler(string, string2)) continue;
            return true;
        }
        return false;
    }

    public TagHandler createTagHandler(String string, String string2, TagConfig tagConfig) throws FacesException {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsTagHandler(string, string2)) continue;
            return this.libraries[i].createTagHandler(string, string2, tagConfig);
        }
        return null;
    }

    public boolean containsFunction(String string, String string2) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsFunction(string, string2)) continue;
            return true;
        }
        return false;
    }

    public Method createFunction(String string, String string2) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsFunction(string, string2)) continue;
            return this.libraries[i].createFunction(string, string2);
        }
        return null;
    }
}

