/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.RIConstants;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import java.beans.FeatureDescriptor;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static boolean unitTestModeEnabled = false;
    private static final String coreTLVEnabled = "com.sun.faces.coreTLVEnabled";
    private static final String htmlTLVEnabled = "com.sun.faces.htmlTLVEnabled";
    private static final String patternCacheKey = "com.sun.faces.patternCache";
    private static ThreadLocal<Map<String, Object>> nonFacesContextApplicationMap;

    private Util() {
        throw new IllegalStateException();
    }

    private static void lazilyInitializeNonFacesContextApplicationMap() {
        if (null == nonFacesContextApplicationMap) {
            nonFacesContextApplicationMap = new ThreadLocal<Map<String, Object>>(){

                @Override
                protected Map<String, Object> initialValue() {
                    return null;
                }
            };
        }
    }

    private static Map<String, Object> getNonFacesContextApplicationMap() {
        Util.lazilyInitializeNonFacesContextApplicationMap();
        return nonFacesContextApplicationMap.get();
    }

    private static Map<String, Object> getApplicationMap() {
        ExternalContext externalContext;
        HashMap<String, Object> hashMap = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext && null != (externalContext = facesContext.getExternalContext())) {
            hashMap = externalContext.getApplicationMap();
        }
        if (null == hashMap && null == (hashMap = Util.getNonFacesContextApplicationMap())) {
            hashMap = new HashMap<String, Object>();
            Util.setNonFacesContextApplicationMap(hashMap);
        }
        return hashMap;
    }

    private static Map<String, Pattern> getPatternCache() {
        Map<String, Object> map = Util.getApplicationMap();
        LRUMap lRUMap = (LRUMap)map.get(patternCacheKey);
        if (null == lRUMap) {
            lRUMap = new LRUMap(15);
            map.put(patternCacheKey, lRUMap);
        }
        return lRUMap;
    }

    private static Map<String, Pattern> getPatternCache(ServletContext servletContext) {
        LRUMap lRUMap = (LRUMap)servletContext.getAttribute(patternCacheKey);
        if (null == lRUMap) {
            lRUMap = new LRUMap(15);
            servletContext.setAttribute(patternCacheKey, lRUMap);
        }
        return lRUMap;
    }

    public static boolean isPortletRequest(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().get("javax.portlet.faces.phase") != null;
    }

    public static Object getListenerInstance(ValueExpression valueExpression, ValueExpression valueExpression2) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object object = null;
        if (facesContext == null) {
            return null;
        }
        if (valueExpression2 != null) {
            object = valueExpression2.getValue(facesContext.getELContext());
        }
        if (object == null && valueExpression != null) {
            try {
                object = ReflectionUtils.newInstance((String)valueExpression.getValue(facesContext.getELContext()));
            }
            catch (Exception exception) {
                throw new AbortProcessingException(exception.getMessage(), (Throwable)exception);
            }
            if (valueExpression2 != null) {
                valueExpression2.setValue(facesContext.getELContext(), object);
            }
        }
        return object;
    }

    public static void setUnitTestModeEnabled(boolean bl) {
        unitTestModeEnabled = bl;
    }

    public static boolean isUnitTestModeEnabled() {
        return unitTestModeEnabled;
    }

    public static void setCoreTLVActive(boolean bl) {
        Map<String, Object> map = Util.getApplicationMap();
        map.put(coreTLVEnabled, bl);
    }

    public static boolean isCoreTLVActive() {
        Boolean bl = true;
        Map<String, Object> map = Util.getApplicationMap();
        bl = (Boolean)map.get(coreTLVEnabled);
        return null == bl ? true : bl;
    }

    public static void setHtmlTLVActive(boolean bl) {
        Map<String, Object> map = Util.getApplicationMap();
        map.put(htmlTLVEnabled, bl);
    }

    public static boolean isHtmlTLVActive() {
        Boolean bl = true;
        Map<String, Object> map = Util.getApplicationMap();
        bl = (Boolean)map.get(htmlTLVEnabled);
        return null == bl ? true : bl;
    }

    public static Class loadClass(String string, Object object) throws ClassNotFoundException {
        ClassLoader classLoader = Util.getCurrentLoader(object);
        if (string.charAt(0) == '[') {
            return Class.forName(string, true, classLoader);
        }
        return classLoader.loadClass(string);
    }

    public static ClassLoader getCurrentLoader(Object object) {
        ClassLoader classLoader = Util.getContextClassLoader();
        if (classLoader == null) {
            classLoader = object.getClass().getClassLoader();
        }
        return classLoader;
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static void notNull(String string, Object object) {
        if (object == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", string));
        }
    }

    public static Locale getLocaleFromContextOrSystem(FacesContext facesContext) {
        UIViewRoot uIViewRoot;
        Locale locale;
        Locale locale2 = locale = Locale.getDefault();
        if (null != facesContext && null != (uIViewRoot = facesContext.getViewRoot()) && null == (locale2 = uIViewRoot.getLocale())) {
            locale2 = locale;
        }
        return locale2;
    }

    public static Converter getConverterForClass(Class clazz, FacesContext facesContext) {
        if (clazz == null) {
            return null;
        }
        try {
            Application application = facesContext.getApplication();
            return application.createConverter(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Converter getConverterForIdentifer(String string, FacesContext facesContext) {
        if (string == null) {
            return null;
        }
        try {
            Application application = facesContext.getApplication();
            return application.createConverter(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static StateManager getStateManager(FacesContext facesContext) throws FacesException {
        return facesContext.getApplication().getStateManager();
    }

    public static Class getTypeFromString(String string) throws ClassNotFoundException {
        Class clazz;
        if (string.equals("byte")) {
            clazz = Byte.TYPE;
        } else if (string.equals("short")) {
            clazz = Short.TYPE;
        } else if (string.equals("int")) {
            clazz = Integer.TYPE;
        } else if (string.equals("long")) {
            clazz = Long.TYPE;
        } else if (string.equals("float")) {
            clazz = Float.TYPE;
        } else if (string.equals("double")) {
            clazz = Double.TYPE;
        } else if (string.equals("boolean")) {
            clazz = Boolean.TYPE;
        } else if (string.equals("char")) {
            clazz = Character.TYPE;
        } else if (string.equals("void")) {
            clazz = Void.TYPE;
        } else {
            if (string.indexOf(46) == -1) {
                string = "java.lang." + string;
            }
            clazz = Util.loadClass(string, Void.TYPE);
        }
        return clazz;
    }

    public static ViewHandler getViewHandler(FacesContext facesContext) throws FacesException {
        Application application = facesContext.getApplication();
        assert (application != null);
        ViewHandler viewHandler = application.getViewHandler();
        assert (viewHandler != null);
        return viewHandler;
    }

    public static boolean componentIsDisabled(UIComponent uIComponent) {
        return Boolean.valueOf(String.valueOf(uIComponent.getAttributes().get("disabled")));
    }

    public static boolean componentIsDisabledOrReadonly(UIComponent uIComponent) {
        return Boolean.valueOf(String.valueOf(uIComponent.getAttributes().get("disabled"))) != false || Boolean.valueOf(String.valueOf(uIComponent.getAttributes().get("readonly"))) != false;
    }

    public static Locale getLocaleFromString(String string) throws IllegalArgumentException {
        if (null == string || string.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + string);
        }
        Locale locale = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        char[] cArray = new char[]{'-', '_'};
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        if (n >= 2 && (n2 = Util.indexOfSet(string, cArray, 0)) == -1) {
            if (2 != string.length()) {
                throw new IllegalArgumentException("Illegal locale String: " + string);
            }
            string2 = string.toLowerCase();
        }
        if (n2 != -1) {
            string2 = string.substring(0, n2);
            if (n >= 5 && (n3 = Util.indexOfSet(string, cArray, n2 + 1)) == -1) {
                if (n != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + string);
                }
                string3 = string.substring(n2 + 1);
            }
            if (n3 != -1) {
                string3 = string.substring(n2 + 1, n3);
                if (n >= 8) {
                    string4 = string.substring(n3 + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + string);
                }
            }
        }
        if (string4 != null && string3 != null && string2 != null) {
            locale = new Locale(string2, string3, string4);
        } else if (string2 != null && string3 != null) {
            locale = new Locale(string2, string3);
        } else if (string2 != null) {
            locale = new Locale(string2, "");
        }
        return locale;
    }

    public static int indexOfSet(String string, char[] cArray, int n) {
        int n2 = -1;
        int n3 = string.length();
        for (int i = n; i < n3; ++i) {
            int n4 = cArray.length;
            for (int j = 0; j < n4; ++j) {
                if (string.charAt(i) != cArray[j]) continue;
                n2 = i;
                break;
            }
            if (-1 != n2) break;
        }
        return n2;
    }

    public static String getStackTraceString(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            stringBuffer.append(stackTraceElement.toString()).append('\n');
        }
        return stringBuffer.toString();
    }

    public static String getContentTypeFromResponse(Object object) {
        String string = null;
        if (null != object) {
            try {
                Object object2;
                Method method = ReflectionUtils.lookupMethod(object.getClass(), "getContentType", RIConstants.EMPTY_CLASS_ARGS);
                if (null != method && null != (object2 = method.invoke(object, RIConstants.EMPTY_METH_ARGS))) {
                    string = object2.toString();
                }
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
        }
        return string;
    }

    public static FeatureDescriptor getFeatureDescriptor(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, Object object, Boolean bl4) {
        FeatureDescriptor featureDescriptor = new FeatureDescriptor();
        featureDescriptor.setName(string);
        featureDescriptor.setDisplayName(string2);
        featureDescriptor.setShortDescription(string3);
        featureDescriptor.setExpert(bl);
        featureDescriptor.setHidden(bl2);
        featureDescriptor.setPreferred(bl3);
        featureDescriptor.setValue("type", object);
        featureDescriptor.setValue("resolvableAtDesignTime", bl4);
        return featureDescriptor;
    }

    public static synchronized String[] split(String string, String string2) {
        Map<String, Pattern> map = Util.getPatternCache();
        Pattern pattern = map.get(string2);
        if (pattern == null) {
            pattern = Pattern.compile(string2);
            map.put(string2, pattern);
        }
        return pattern.split(string, 0);
    }

    public static synchronized String[] split(ServletContext servletContext, String string, String string2) {
        Map<String, Pattern> map = Util.getPatternCache(servletContext);
        Pattern pattern = map.get(string2);
        if (pattern == null) {
            pattern = Pattern.compile(string2);
            map.put(string2, pattern);
        }
        return pattern.split(string, 0);
    }

    public static String getFacesMapping(FacesContext facesContext) {
        String string;
        String string2;
        if (facesContext == null) {
            String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(string3);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String string4 = (String)RequestStateManager.get(facesContext, "com.sun.faces.INVOCATION_PATH");
        if (string4 == null && (string4 = Util.getMappingForRequest(string2 = externalContext.getRequestServletPath(), string = externalContext.getRequestPathInfo())) == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.faces_servlet_mapping_cannot_be_determined_error", new Object[]{string2});
        }
        if (string4 != null) {
            RequestStateManager.set(facesContext, "com.sun.faces.INVOCATION_PATH", string4);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL pattern of the FacesServlet executing the current request " + string4);
        }
        return string4;
    }

    private static String getMappingForRequest(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "servletPath " + string);
            LOGGER.log(Level.FINE, "pathInfo " + string2);
        }
        if (string.length() == 0) {
            return "/*";
        }
        if (string2 != null) {
            return string;
        }
        if (string.indexOf(46) < 0) {
            return string;
        }
        return string.substring(string.lastIndexOf(46));
    }

    public static boolean isPrefixMapped(String string) {
        return string.charAt(0) == '/';
    }

    public static boolean isSpecialAttributeName(String string) {
        boolean bl = string.equals("action") || string.equals("actionListener") || string.equals("validator") || string.equals("valueChangeListener");
        return bl;
    }

    public static boolean isViewPopulated(FacesContext facesContext, UIViewRoot uIViewRoot) {
        return facesContext.getAttributes().containsKey(uIViewRoot);
    }

    public static void setViewPopulated(FacesContext facesContext, UIViewRoot uIViewRoot) {
        facesContext.getAttributes().put(uIViewRoot, Boolean.TRUE);
    }

    public static void checkIdUniqueness(FacesContext facesContext, UIComponent uIComponent, Set<String> set) {
        Iterator iterator = uIComponent.getFacetsAndChildren();
        while (iterator.hasNext()) {
            Object object;
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            String string = uIComponent2.getClientId(facesContext);
            if (set.add(string)) {
                Util.checkIdUniqueness(facesContext, uIComponent2, set);
                continue;
            }
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", string);
                object = new FastStringWriter(128);
                DebugUtil.simplePrintTree((UIComponent)facesContext.getViewRoot(), string, (Writer)object);
                LOGGER.severe(((FastStringWriter)object).toString());
            }
            object = MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", string);
            throw new IllegalStateException((String)object);
        }
    }

    public static void setNonFacesContextApplicationMap(Map<String, Object> map) {
        Util.lazilyInitializeNonFacesContextApplicationMap();
        if (null == map) {
            nonFacesContextApplicationMap.remove();
        } else {
            nonFacesContextApplicationMap.set(map);
        }
    }
}

