/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ZipDirectoryEntryScanner;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;

public class ClasspathResourceHelper
extends ResourceHelper {
    private static final String BASE_RESOURCE_PATH = "META-INF/resources";
    private boolean cacheTimestamp;
    private volatile ZipDirectoryEntryScanner libraryScanner;
    private boolean enableMissingResourceLibraryDetection;

    public ClasspathResourceHelper() {
        WebConfiguration webconfig = WebConfiguration.getInstance();
        this.cacheTimestamp = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
        this.enableMissingResourceLibraryDetection = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableMissingResourceLibraryDetection);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathResourceHelper other = (ClasspathResourceHelper)obj;
        if (this.cacheTimestamp != other.cacheTimestamp) {
            return false;
        }
        return this.enableMissingResourceLibraryDetection == other.enableMissingResourceLibraryDetection;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.cacheTimestamp ? 1 : 0);
        hash = 67 * hash + (this.enableMissingResourceLibraryDetection ? 1 : 0);
        return hash;
    }

    public String getBaseResourcePath() {
        return BASE_RESOURCE_PATH;
    }

    protected InputStream getNonCompressedInputStream(ResourceInfo resource, FacesContext ctx) throws IOException {
        String path;
        ClassLoader loader = Util.getCurrentLoader(this.getClass());
        InputStream in = loader.getResourceAsStream(path = resource.getPath());
        if (in == null) {
            in = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        return in;
    }

    public URL getURL(ResourceInfo resource, FacesContext ctx) {
        ClassLoader loader = Util.getCurrentLoader(this.getClass());
        URL url = loader.getResource(resource.getPath());
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(resource.getPath());
        }
        return url;
    }

    public LibraryInfo findLibrary(String libraryName, String localePrefix, FacesContext ctx) {
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = localePrefix == null ? this.getBaseResourcePath() + '/' + libraryName + '/' : this.getBaseResourcePath() + '/' + localePrefix + '/' + libraryName + '/';
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            return null;
        }
        return new LibraryInfo(libraryName, null, localePrefix, this);
    }

    public LibraryInfo findLibraryWithZipDirectoryEntryScan(String libraryName, String localePrefix, FacesContext ctx, boolean forceScan) {
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = localePrefix == null ? this.getBaseResourcePath() + '/' + libraryName + '/' : this.getBaseResourcePath() + '/' + localePrefix + '/' + libraryName + '/';
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            if (null != localePrefix && libraryName.equals("javax.faces")) {
                return null;
            }
            if (this.enableMissingResourceLibraryDetection || forceScan) {
                if (null == this.libraryScanner) {
                    this.libraryScanner = new ZipDirectoryEntryScanner();
                }
                if (!this.libraryScanner.libraryExists(libraryName, localePrefix)) {
                    return null;
                }
            }
        }
        return new LibraryInfo(libraryName, null, localePrefix, this);
    }

    public ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        ClientResourceInfo value;
        resourceName = this.trimLeadingSlash(resourceName);
        ClassLoader loader = Util.getCurrentLoader(this);
        String basePath = library != null ? library.getPath(localePrefix) + '/' + resourceName : (localePrefix == null ? this.getBaseResourcePath() + '/' + resourceName : this.getBaseResourcePath() + '/' + localePrefix + '/' + resourceName);
        URL basePathURL = loader.getResource(basePath);
        if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
            basePath = library != null ? library.getPath(null) + '/' + resourceName : this.getBaseResourcePath() + '/' + resourceName;
            basePathURL = loader.getResource(basePath);
            if (basePathURL == null && (basePathURL = this.getClass().getClassLoader().getResource(basePath)) == null) {
                return null;
            }
            localePrefix = null;
        }
        if ((value = library != null ? new ClientResourceInfo(library, resourceName, null, compressable, this.resourceSupportsEL(resourceName, library.getName(), ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(resourceName, null, localePrefix, this, compressable, this.resourceSupportsEL(resourceName, null, ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp)).isCompressable()) {
            value = this.handleCompression(value);
        }
        return value;
    }
}

