/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.Util;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FacesLogger {
    APPLICATION("application"),
    APPLICATION_VIEW("application.view"),
    RESOURCE("resource"),
    CONFIG("config"),
    CONTEXT("context"),
    FACELETS_COMPILER("facelets.compiler"),
    FACELETS_COMPONENT("facelets.tag.component"),
    FACELETS_META("facelets.tag.meta"),
    FACELETS_COMPOSITION("facelets.tag.ui.composition"),
    FACELETS_DECORATE("facelets.tag.ui.decorate"),
    FACELETS_INCLUDE("facelets.tag.ui.include"),
    FACELETS_FACELET("faclets.facelet"),
    FACELETS_FACTORY("facelets.factory"),
    FLOW("flow"),
    LIFECYCLE("lifecycle"),
    MANAGEDBEAN("managedbean"),
    RENDERKIT("renderkit"),
    TAGLIB("taglib"),
    TIMING("timing"),
    UTIL("util"),
    FLASH("flash");

    private static final String LOGGER_RESOURCES = "com.sun.faces.LogStrings";
    public static final String FACES_LOGGER_NAME_PREFIX = "javax.enterprise.resource.webcontainer.jsf.";
    private String loggerName;

    private FacesLogger(String loggerName) {
        this.loggerName = FACES_LOGGER_NAME_PREFIX + loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getResourcesName() {
        return LOGGER_RESOURCES;
    }

    public Logger getLogger() {
        return Logger.getLogger(this.loggerName, LOGGER_RESOURCES);
    }

    public String interpolateMessage(FacesContext context, String messageId, Object[] params) {
        String result = null;
        ResourceBundle rb = null;
        UIViewRoot root = context.getViewRoot();
        ClassLoader loader = Util.getCurrentLoader((Object)this);
        Locale curLocale = null == root ? Locale.getDefault() : root.getLocale();
        try {
            rb = ResourceBundle.getBundle(this.getResourcesName(), curLocale, loader);
            String message = rb.getString(messageId);
            result = params != null ? MessageFormat.format(message, params) : message;
        }
        catch (MissingResourceException mre) {
            result = messageId;
        }
        return result;
    }
}

