/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.SharedUtils;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewAction;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.context.PartialViewContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowNode;
import javax.faces.flow.ViewNode;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private volatile Map<String, NavigationInfo> navigationMaps;
    private boolean development;
    private static final Pattern REDIRECT_EQUALS_TRUE = Pattern.compile("(.*)(faces-redirect=true)(.*)");
    private static final Pattern INCLUDE_VIEW_PARAMS_EQUALS_TRUE = Pattern.compile("(.*)(includeViewParams=true)(.*)");
    private static final String ROOT_NAVIGATION_MAP_ID = NavigationHandlerImpl.class.getName() + ".NAVIGATION_MAP";
    private static final String DISCERNING_FLOW_ROUTING_KEY = NavigationHandlerImpl.class.getPackage().getName();

    public NavigationHandlerImpl() {
        ApplicationAssociate associate;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created NavigationHandler instance ");
        }
        if ((associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext())) != null) {
            this.development = associate.isDevModeEnabled();
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        Util.notNull("context", context);
        NavigationCase result = null;
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome);
        if (null != caseStruct) {
            result = caseStruct.navCase;
        }
        return result;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        NavigationMap result = this.getNavigationMap(FacesContext.getCurrentInstance());
        return result;
    }

    public void inspectFlow(FacesContext context, Flow flow) {
        this.initializeNavigationFromFlow(context, flow);
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        Util.notNull("context", context);
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome);
        if (caseStruct != null) {
            ExternalContext extContext = context.getExternalContext();
            ViewHandler viewHandler = Util.getViewHandler(context);
            assert (null != viewHandler);
            Flash flash = extContext.getFlash();
            boolean isUIViewActionBroadcastAndViewdsDiffer = false;
            if (UIViewAction.isProcessingBroadcast((FacesContext)context)) {
                flash.setKeepMessages(true);
                String viewIdBefore = context.getViewRoot().getViewId();
                viewIdBefore = null == viewIdBefore ? "" : viewIdBefore;
                String viewIdAfter = caseStruct.navCase.getToViewId(context);
                viewIdAfter = null == viewIdAfter ? "" : viewIdAfter;
                boolean bl = isUIViewActionBroadcastAndViewdsDiffer = !viewIdBefore.equals(viewIdAfter);
            }
            if (caseStruct.navCase.isRedirect() || isUIViewActionBroadcastAndViewdsDiffer) {
                String redirectUrl = viewHandler.getRedirectURL(context, caseStruct.viewId, SharedUtils.evaluateExpressions(context, caseStruct.navCase.getParameters()), caseStruct.navCase.isIncludeViewParams());
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Redirecting to path " + redirectUrl + " for outcome " + outcome + "and viewId " + caseStruct.viewId);
                    }
                    this.clearViewMapIfNecessary(context.getViewRoot(), caseStruct.viewId);
                    this.updateRenderTargets(context, caseStruct.viewId);
                    flash.setRedirect(true);
                    extContext.redirect(redirectUrl);
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "jsf.redirect_failed_error", redirectUrl);
                    }
                    throw new FacesException(ioe.getMessage(), (Throwable)ioe);
                }
                context.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot newRoot = viewHandler.createView(context, caseStruct.viewId);
                this.loadFlowDefinition(context, viewHandler, caseStruct.viewId);
                this.updateRenderTargets(context, caseStruct.viewId);
                Flow newFlow = context.getApplication().getFlowHandler().transition(context, (UIComponent)context.getViewRoot(), (UIComponent)newRoot);
                if (null != newFlow) {
                    String startNodeId = newFlow.getStartNodeId();
                    assert (null != startNodeId);
                    assert (0 < startNodeId.length());
                    if (!startNodeId.equals(Util.getFlowIdFromComponent(context, (UIComponent)newRoot))) {
                        context.setViewRoot(newRoot);
                        this.handleNavigation(context, fromAction, startNodeId);
                    } else {
                        context.setViewRoot(newRoot);
                    }
                } else {
                    context.setViewRoot(newRoot);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    private void loadFlowDefinition(FacesContext context, ViewHandler viewHandler, String viewId) {
        String flowDefId;
        ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, viewId);
        if (null != vdl && null != (flowDefId = this.deriveValidFlowDefIdFromViewId(context, vdl, viewId))) {
            ViewMetadata metadata = null;
            metadata = vdl.getViewMetadata(context, flowDefId);
            if (null != metadata) {
                metadata.createMetadataView(context);
            }
        }
    }

    private String deriveValidFlowDefIdFromViewId(FacesContext context, ViewDeclarationLanguage vdl, String viewId) {
        int i = viewId.indexOf(".");
        String flowDefId = null;
        if (-1 != i && !vdl.viewExists(context, flowDefId = viewId.substring(0, i) + "-flow.xml") && !vdl.viewExists(context, flowDefId = flowDefId.startsWith("/") ? "WEB-INF" + flowDefId : "WEB-INF/" + flowDefId)) {
            flowDefId = null;
        }
        return flowDefId;
    }

    private NavigationMap getNavigationMap(FacesContext context) {
        NavigationMap result = null;
        if (null == this.navigationMaps) {
            this.navigationMaps = new ConcurrentHashMap<String, NavigationInfo>();
            result = new NavigationMap();
            NavigationInfo info = new NavigationInfo();
            info.ruleSet = result;
            this.navigationMaps.put(ROOT_NAVIGATION_MAP_ID, info);
        } else {
            NavigationInfo info = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID);
            result = info.ruleSet;
        }
        return result;
    }

    private NavigationInfo getNavigationInfo(FacesContext context, String flowId) {
        NavigationInfo result = null;
        assert (null != this.navigationMaps);
        result = this.navigationMaps.get(flowId);
        return result;
    }

    private void initializeNavigationFromAssociate() {
        ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
        if (associate != null) {
            Map<String, Set<NavigationCase>> m = associate.getNavigationCaseListMappings();
            NavigationMap rootMap = this.getNavigationMap(FacesContext.getCurrentInstance());
            if (m != null) {
                rootMap.putAll((Map<? extends String, ? extends Set<NavigationCase>>)m);
            }
        }
    }

    private void initializeNavigationFromFlow(FacesContext context, Flow toInspect) {
        if (context instanceof InitFacesContext) {
            this.initializeNavigationFromFlowNonThreadSafe(context, toInspect);
        } else {
            this.initializeNavigationFromFlowThreadSafe(context, toInspect);
        }
    }

    private void initializeNavigationFromFlowNonThreadSafe(FacesContext context, Flow toInspect) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNavigationFromFlowThreadSafe(FacesContext context, Flow toInspect) {
        assert (null != this.navigationMaps);
        NavigationHandlerImpl navigationHandlerImpl = this;
        synchronized (navigationHandlerImpl) {
            Object navMap = null;
            Map switches = toInspect.getSwitches(context);
            String flowId = toInspect.getId();
            if (!this.navigationMaps.containsKey(flowId) && !switches.isEmpty()) {
                NavigationInfo info = new NavigationInfo();
                info.switches = new ConcurrentHashMap();
                for (Map.Entry cur : switches.entrySet()) {
                    info.switches.put(cur.getKey(), Collections.synchronizedList(new ArrayList((Collection)cur.getValue())));
                }
                this.navigationMaps.put(flowId, info);
            }
        }
    }

    private void clearViewMapIfNecessary(UIViewRoot root, String newId) {
        Map viewMap;
        if (root != null && !root.getViewId().equals(newId) && (viewMap = root.getViewMap(false)) != null) {
            viewMap.clear();
        }
    }

    private void updateRenderTargets(FacesContext ctx, String newId) {
        PartialViewContext pctx;
        if (!(ctx.getViewRoot() != null && ctx.getViewRoot().getViewId().equals(newId) || (pctx = ctx.getPartialViewContext()).isRenderAll())) {
            pctx.setRenderAll(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct getViewId(FacesContext ctx, String fromAction, String outcome) {
        UIViewRoot root;
        if (this.navigationMaps == null) {
            NavigationHandlerImpl navigationHandlerImpl = this;
            synchronized (navigationHandlerImpl) {
                this.initializeNavigationFromAssociate();
            }
        }
        String viewId = (root = ctx.getViewRoot()) != null ? root.getViewId() : null;
        CaseStruct caseStruct = null;
        if (viewId != null && (caseStruct = this.findExactMatch(ctx, viewId, fromAction, outcome)) == null) {
            caseStruct = this.findWildCardMatch(ctx, viewId, fromAction, outcome);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(ctx, fromAction, outcome);
        }
        if (caseStruct == null && outcome != null && viewId != null) {
            if (caseStruct == null && 0 == outcome.length()) {
                outcome = null;
            } else {
                caseStruct = this.findImplicitMatch(ctx, viewId, fromAction, outcome);
            }
        }
        if (null == caseStruct && null != fromAction && null != outcome) {
            caseStruct = this.findSwitchMatch(ctx, fromAction, outcome);
        }
        if (caseStruct == null && outcome != null && this.development) {
            Object[] params;
            String key;
            if (fromAction == null) {
                key = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME";
                params = new Object[]{viewId, outcome};
            } else {
                key = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME_ACTION";
                params = new Object[]{viewId, fromAction, outcome};
            }
            FacesMessage m = MessageUtils.getExceptionMessage(key, params);
            m.setSeverity(FacesMessage.SEVERITY_WARN);
            ctx.addMessage(null, m);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(FacesContext ctx, String viewId, String fromAction, String outcome) {
        NavigationMap navMap = this.getNavigationMap(ctx);
        Set caseSet = (Set)navMap.get(viewId);
        if (caseSet == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(ctx, caseSet, fromAction, outcome);
    }

    private CaseStruct findWildCardMatch(FacesContext ctx, String viewId, String fromAction, String outcome) {
        CaseStruct result = null;
        NavigationMap navMap = this.getNavigationMap(ctx);
        for (String fromViewId : navMap.wildcardMatchList) {
            if (!viewId.startsWith(fromViewId)) continue;
            String wcFromViewId = new StringBuilder(32).append(fromViewId).append('*').toString();
            Set ccaseSet = (Set)navMap.get(wcFromViewId);
            if (ccaseSet == null) {
                return null;
            }
            result = this.determineViewFromActionOutcome(ctx, ccaseSet, fromAction, outcome);
            if (result == null) continue;
            break;
        }
        return result;
    }

    private CaseStruct findDefaultMatch(FacesContext ctx, String fromAction, String outcome) {
        NavigationMap navMap = this.getNavigationMap(ctx);
        Set caseSet = (Set)navMap.get("*");
        if (caseSet == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(ctx, caseSet, fromAction, outcome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct findImplicitMatch(FacesContext context, String viewId, String fromAction, String outcome) {
        int idx;
        String viewIdToTest = outcome;
        String currentViewId = viewId;
        LinkedHashMap<String, ArrayList<String>> parameters = null;
        boolean isRedirect = false;
        boolean isIncludeViewParams = false;
        int questionMark = viewIdToTest.indexOf(63);
        if (-1 != questionMark) {
            String queryString;
            int viewIdLen = viewIdToTest.length();
            if (viewIdLen <= questionMark + 1) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "jsf.navigation_invalid_query_string", viewIdToTest);
                }
                if (this.development) {
                    String key = "com.sun.faces.NAVIGATION_INVALID_QUERY_STRING";
                    Object[] params = new Object[]{viewIdToTest};
                    FacesMessage m = MessageUtils.getExceptionMessage(key, params);
                    m.setSeverity(FacesMessage.SEVERITY_WARN);
                    context.addMessage(null, m);
                }
                queryString = null;
                viewIdToTest = viewIdToTest.substring(0, questionMark);
            } else {
                queryString = viewIdToTest.substring(questionMark + 1);
                viewIdToTest = viewIdToTest.substring(0, questionMark);
                Matcher m = REDIRECT_EQUALS_TRUE.matcher(queryString);
                if (m.find()) {
                    isRedirect = true;
                    queryString = queryString.replace(m.group(2), "");
                }
                if ((m = INCLUDE_VIEW_PARAMS_EQUALS_TRUE.matcher(queryString)).find()) {
                    isIncludeViewParams = true;
                    queryString = queryString.replace(m.group(2), "");
                }
            }
            if (queryString != null && queryString.length() > 0) {
                String[] queryElements = Util.split(queryString, "&amp;|&");
                int len = queryElements.length;
                for (int i = 0; i < len; ++i) {
                    ArrayList<String> values;
                    String[] elements = Util.split(queryElements[i], "=");
                    if (elements.length != 2) continue;
                    if (parameters == null) {
                        parameters = new LinkedHashMap<String, ArrayList<String>>(len / 2, 1.0f);
                        values = new ArrayList<String>(2);
                        values.add(elements[1]);
                        parameters.put(elements[0], values);
                        continue;
                    }
                    values = (ArrayList<String>)parameters.get(elements[0]);
                    if (values == null) {
                        values = new ArrayList(2);
                        parameters.put(elements[0], values);
                    }
                    values.add(elements[1]);
                }
            }
        }
        String currentExtension = (idx = currentViewId.lastIndexOf(46)) != -1 ? currentViewId.substring(idx) : ".xhtml";
        if (viewIdToTest.lastIndexOf(46) == -1) {
            viewIdToTest = viewIdToTest + currentExtension;
        }
        if (!viewIdToTest.startsWith("/")) {
            int lastSlash = currentViewId.lastIndexOf("/");
            if (lastSlash != -1) {
                currentViewId = currentViewId.substring(0, lastSlash + 1);
                viewIdToTest = currentViewId + viewIdToTest;
            } else {
                viewIdToTest = "/" + viewIdToTest;
            }
        }
        ViewHandler viewHandler = Util.getViewHandler(context);
        viewIdToTest = viewHandler.deriveViewId(context, viewIdToTest);
        CaseStruct caseStruct = null;
        if (null == viewIdToTest && !this.isDiscerningFlowRouting(context)) {
            FlowHandler flowHandler = context.getApplication().getFlowHandler();
            Flow flow = flowHandler.getFlow(context, null, outcome);
            if (null != flow) {
                FlowNode node = flow.getNode(flow.getStartNodeId());
                if (null != node && node instanceof ViewNode) {
                    viewIdToTest = ((ViewNode)node).getVdlDocumentId();
                }
            } else {
                flow = flowHandler.getCurrentFlow(context);
                if (null != flow) {
                    NavigationCase navCase = (NavigationCase)flow.getReturns(context).get(outcome);
                    if (null != navCase) {
                        String fromOutcome = navCase.getFromOutcome();
                        if (SharedUtils.isExpression(fromOutcome)) {
                            Application app = context.getApplication();
                            fromOutcome = (String)app.evaluateExpressionGet(context, fromOutcome, String.class);
                        }
                        CaseStruct result = null;
                        try {
                            this.setDiscerningFlowRouting(context, true);
                            result = this.getViewId(context, fromAction, fromOutcome);
                        }
                        finally {
                            this.setDiscerningFlowRouting(context, false);
                        }
                        return result;
                    }
                } else {
                    viewIdToTest = "/" + outcome + "/" + outcome + currentExtension;
                    viewIdToTest = viewHandler.deriveViewId(context, viewIdToTest);
                }
            }
        }
        if (null != viewIdToTest && null == caseStruct) {
            caseStruct = new CaseStruct();
            caseStruct.viewId = viewIdToTest;
            caseStruct.navCase = new NavigationCase(viewId, fromAction, outcome, null, viewIdToTest, (Map)parameters, isRedirect, isIncludeViewParams);
            return caseStruct;
        }
        return null;
    }

    private CaseStruct findSwitchMatch(FacesContext context, String fromAction, String outcome) {
        List cases;
        CaseStruct result = null;
        NavigationInfo info = this.getNavigationInfo(context, fromAction);
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null != info && null != info.switches && !info.switches.isEmpty() && null != (cases = (List)info.switches.get(outcome))) {
            for (NavigationCase cur : cases) {
                FlowNode node;
                if (!cur.getCondition(context).booleanValue()) continue;
                outcome = cur.getFromOutcome();
                Flow flow = flowHandler.getFlow(context, null, fromAction);
                if (null != flow && null != (node = flow.getNode(outcome)) && node instanceof ViewNode) {
                    result = new CaseStruct();
                    result.viewId = ((ViewNode)node).getVdlDocumentId();
                    result.navCase = new NavigationCase(fromAction, fromAction, outcome, null, result.viewId, null, false, false);
                }
                if (null == result) continue;
                break;
            }
        }
        return result;
    }

    private boolean isDiscerningFlowRouting(FacesContext context) {
        boolean result = false;
        Map attrs = context.getAttributes();
        if (attrs.containsKey(DISCERNING_FLOW_ROUTING_KEY)) {
            result = (Boolean)attrs.get(DISCERNING_FLOW_ROUTING_KEY);
        }
        return result;
    }

    private void setDiscerningFlowRouting(FacesContext context, boolean newValue) {
        Map attrs = context.getAttributes();
        attrs.put(DISCERNING_FLOW_ROUTING_KEY, newValue);
    }

    private CaseStruct determineViewFromActionOutcome(FacesContext ctx, Set<NavigationCase> caseSet, String fromAction, String outcome) {
        CaseStruct result = new CaseStruct();
        boolean match = false;
        for (NavigationCase cnc : caseSet) {
            String cncFromAction = cnc.getFromAction();
            String cncFromOutcome = cnc.getFromOutcome();
            boolean cncHasCondition = cnc.hasCondition();
            String cncToViewId = cnc.getToViewId(ctx);
            if (cncFromAction != null && cncFromOutcome != null) {
                if (cncFromAction.equals(fromAction) && cncFromOutcome.equals(outcome)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction == null && cncFromOutcome != null) {
                if (cncFromOutcome.equals(outcome)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction != null && cncFromOutcome == null) {
                if (cncFromAction.equals(fromAction) && (outcome != null || cncHasCondition)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction == null && cncFromOutcome == null && (outcome != null || cncHasCondition)) {
                result.viewId = cncToViewId;
                result.navCase = cnc;
                match = true;
            }
            if (!match) continue;
            if (cncHasCondition && Boolean.FALSE.equals(cnc.getCondition(ctx))) {
                match = false;
                continue;
            }
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NavigationMap
    extends AbstractMap<String, Set<NavigationCase>> {
        private HashMap<String, Set<NavigationCase>> navigationMap = new HashMap();
        private TreeSet<String> wildcardMatchList = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String fromViewId1, String fromViewId2) {
                return -fromViewId1.compareTo(fromViewId2);
            }
        });

        private NavigationMap() {
        }

        @Override
        public int size() {
            return this.navigationMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.navigationMap.isEmpty();
        }

        @Override
        public Set<NavigationCase> put(String key, Set<NavigationCase> value) {
            if (key == null) {
                throw new IllegalArgumentException(key);
            }
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.updateWildcards(key);
            Set<NavigationCase> existing = this.navigationMap.get(key);
            if (existing == null) {
                this.navigationMap.put(key, value);
                return null;
            }
            existing.addAll(value);
            return existing;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Set<NavigationCase>> m) {
            if (m == null) {
                return;
            }
            for (Map.Entry<? extends String, ? extends Set<NavigationCase>> entry : m.entrySet()) {
                String key = entry.getKey();
                this.updateWildcards(key);
                Set<NavigationCase> existing = this.navigationMap.get(key);
                if (existing == null) {
                    this.navigationMap.put(key, entry.getValue());
                    continue;
                }
                existing.addAll((Collection<NavigationCase>)entry.getValue());
            }
        }

        @Override
        public Set<String> keySet() {
            return new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public String next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Collection<Set<NavigationCase>> values() {
            return new AbstractCollection<Set<NavigationCase>>(){

                @Override
                public Iterator<Set<NavigationCase>> iterator() {
                    return new Iterator<Set<NavigationCase>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Set<NavigationCase> next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Set<Map.Entry<String, Set<NavigationCase>>> entrySet() {
            return new AbstractSet<Map.Entry<String, Set<NavigationCase>>>(){

                @Override
                public Iterator<Map.Entry<String, Set<NavigationCase>>> iterator() {
                    return new Iterator<Map.Entry<String, Set<NavigationCase>>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.navigationMap.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Set<NavigationCase>> next() {
                            return this.i.next();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        private void updateWildcards(String fromViewId) {
            if (!this.navigationMap.containsKey(fromViewId) && fromViewId.endsWith("*")) {
                this.wildcardMatchList.add(fromViewId.substring(0, fromViewId.lastIndexOf(42)));
            }
        }
    }

    private static final class NavigationInfo {
        private NavigationMap ruleSet;
        private Map<String, List<NavigationCase>> switches;

        private NavigationInfo() {
        }
    }

    private static class CaseStruct {
        String viewId;
        NavigationCase navCase;

        private CaseStruct() {
        }
    }
}

