/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.flow;

import com.sun.faces.RIConstants;
import com.sun.faces.facelets.flow.FacesFlowReturnTagHandler;
import com.sun.faces.facelets.flow.FlowNavigationCase;
import com.sun.faces.facelets.flow.SwitchNodeTagHandler;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.ViewNode;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesFlowDefinitionTagHandler
extends TagHandlerImpl {
    private static final String FLOW_DATA_MAP_ATTR_NAME = FacesFlowDefinitionTagHandler.class.getPackage().getName() + ".FLOW_DATA";

    static Map<FlowDataKeys, Object> getFlowData(FaceletContext ctx) {
        Map attrs = ctx.getFacesContext().getAttributes();
        Map result = Collections.emptyMap();
        if (!attrs.containsKey(FLOW_DATA_MAP_ATTR_NAME)) {
            result = new EnumMap(FlowDataKeys.class);
            attrs.put(FLOW_DATA_MAP_ATTR_NAME, result);
        } else {
            result = (Map)attrs.get(FLOW_DATA_MAP_ATTR_NAME);
        }
        return result;
    }

    private String getFlowId(FaceletContext ctx) {
        String id = null;
        TagAttribute flowIdAttr = this.getAttribute("id");
        if (null != flowIdAttr) {
            id = flowIdAttr.getValue(ctx);
        } else {
            int slash;
            id = this.tag.getLocation().getPath();
            int i = id.indexOf("META-INF/flows");
            if (-1 != i) {
                id = id.substring(i + RIConstants.FLOW_IN_JAR_PREFIX_LENGTH);
            }
            if (id.charAt(0) == '/') {
                id = id.substring(1);
            }
            if (id.startsWith("WEB-INF/")) {
                id = id.substring(8);
            }
            if (-1 != (slash = id.lastIndexOf("/"))) {
                id = id.substring(0, slash);
            }
        }
        return id;
    }

    private void clearFlowData(FaceletContext ctx) {
        FacesFlowDefinitionTagHandler.getFlowData(ctx).clear();
    }

    public FacesFlowDefinitionTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        this.clearFlowData(ctx);
        this.nextHandler.apply(ctx, parent);
        FacesContext context = ctx.getFacesContext();
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        Map<FlowDataKeys, Object> flowData = FacesFlowDefinitionTagHandler.getFlowData(ctx);
        String flowId = this.getFlowId(ctx);
        Flow newFlow = flowHandler.getFlow(context, null, flowId);
        boolean addFlow = false;
        if (null == newFlow) {
            newFlow = new Flow();
            newFlow.setId(flowId);
            addFlow = true;
        } else if (null != newFlow.getNode(this.getMyNodeId())) {
            return;
        }
        if (flowData.isEmpty()) {
            List<ViewNode> viewsInFlow = null;
            if (null == newFlow.getStartNodeId()) {
                newFlow.setStartNodeId(this.getMyNodeId());
            }
            if (null == newFlow.getViews()) {
                viewsInFlow = this.synthesizeViews();
                newFlow.setViews(viewsInFlow);
            } else if (null == newFlow.getNode(this.getMyNodeId())) {
                ViewNode viewNode = new ViewNode();
                viewNode.setId(this.getMyNodeId());
                viewNode.setVdlDocumentId(this.tag.getLocation().getPath());
                newFlow.getViews().add(viewNode);
            }
        } else {
            String switchId;
            Map switches;
            FlowNavigationCase switchElement;
            List<ViewNode> viewsFromTag;
            if (null == newFlow.getStartNodeId()) {
                String startNodeId = (String)flowData.get((Object)FlowDataKeys.StartNodeId);
                if (null != startNodeId) {
                    newFlow.setStartNodeId(startNodeId);
                } else {
                    newFlow.setStartNodeId(this.getMyNodeId());
                }
            }
            if (null == (viewsFromTag = (List<ViewNode>)flowData.get((Object)FlowDataKeys.Views))) {
                viewsFromTag = this.synthesizeViews();
            }
            if (null == newFlow.getViews()) {
                newFlow.setViews(viewsFromTag);
            } else {
                newFlow.getViews().addAll(viewsFromTag);
            }
            List<FlowNavigationCase> facesFlowReturns = FacesFlowReturnTagHandler.getNavigationCases(ctx);
            if (null != facesFlowReturns) {
                Map returns = newFlow.getReturns(context);
                for (FlowNavigationCase cur : facesFlowReturns) {
                    String returnId = cur.getEnclosingId();
                    if (returns.containsKey(returnId)) continue;
                    returns.put(returnId, cur);
                }
            }
            if (null != (switchElement = SwitchNodeTagHandler.getNavigationCase(ctx)) && null != (switches = newFlow.getSwitches(context)) && null != (switchId = switchElement.getEnclosingId()) && !switches.containsKey(switchId)) {
                ArrayList<FlowNavigationCase> cases = new ArrayList<FlowNavigationCase>();
                cases.add(switchElement);
                switches.put(switchId, cases);
            }
            String meStr = (String)flowData.get((Object)FlowDataKeys.Initializer);
            MethodExpression me = null;
            ExpressionFactory ef = context.getApplication().getExpressionFactory();
            Class[] argTypes = new Class[]{};
            if (null != meStr) {
                me = ef.createMethodExpression(context.getELContext(), meStr, null, argTypes);
                newFlow.setInitializer(me);
            }
            meStr = (String)flowData.get((Object)FlowDataKeys.Finalizer);
            me = null;
            if (null != meStr) {
                me = ef.createMethodExpression(context.getELContext(), meStr, null, argTypes);
                newFlow.setFinalizer(me);
            }
        }
        if (addFlow) {
            flowHandler.addFlow(context, null, newFlow);
        }
    }

    private List<ViewNode> synthesizeViews() {
        List<ViewNode> viewsInFlow = null;
        ViewNode viewNode = new ViewNode();
        viewNode.setId(this.getMyNodeId());
        String path = this.tag.getLocation().getPath();
        if (path.endsWith("-flow.xml")) {
            int i = path.indexOf("-flow.xml");
            path = path.substring(0, i) + ".xhtml";
        }
        viewNode.setVdlDocumentId(path);
        viewsInFlow = Collections.synchronizedList(new ArrayList());
        viewsInFlow.add(viewNode);
        return viewsInFlow;
    }

    private String getMyNodeId() {
        String myViewId = Util.removeAllButLastSlashPathSegment(this.tag.getLocation().getPath());
        if (myViewId.endsWith("-flow.xml")) {
            myViewId = myViewId.substring(0, myViewId.length() - RIConstants.FLOW_DEFINITION_ID_SUFFIX_LENGTH);
        } else {
            int dot = myViewId.indexOf(".");
            myViewId = myViewId.substring(0, dot);
        }
        return myViewId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FlowDataKeys {
        FlowReturnNavigationCase,
        NavigationCases,
        Views,
        VDLDocument,
        Initializer,
        Finalizer,
        StartNodeId,
        WithinFacesFlowReturn,
        WithinSwitch,
        SwitchNavigationCase;

    }
}

