/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.ui;

import com.sun.faces.facelets.util.DevTools;
import com.sun.faces.facelets.util.FastWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIDebug
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "facelets.ui.Debug";
    public static final String COMPONENT_FAMILY = "facelets";
    private static long nextId = System.currentTimeMillis();
    private static final String KEY = "facelets.ui.DebugOutput";
    private static final String PER_VIEW_DEBUG = "com.sun.faces..PerViewDebug";
    public static final String DEFAULT_HOTKEY = "D";
    private String hotkey = "D";
    private boolean recordStateSize = false;
    private static final Logger LOGGER = Logger.getLogger("javax.faces.component", "javax.faces.LogStrings");

    public UIDebug() {
        this.setTransient(true);
        this.setRendered(true);
        this.setRendererType(null);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public List getChildren() {
        return new ArrayList(){

            public boolean add(Object o) {
                throw new IllegalStateException("<ui:debug> does not support children");
            }

            public void add(int index, Object o) {
                throw new IllegalStateException("<ui:debug> does not support children");
            }
        };
    }

    public void encodeBegin(FacesContext faces) throws IOException {
        this.pushComponentToEL(faces, (UIComponent)this);
        String actionId = faces.getApplication().getViewHandler().getActionURL(faces, faces.getViewRoot().getViewId());
        StringBuffer sb = new StringBuffer(512);
        sb.append("//<![CDATA[\n");
        sb.append("function faceletsDebug(URL) { day = new Date(); id = day.getTime(); eval(\"page\" + id + \" = window.open(URL, '\" + id + \"', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1,width=800,height=600,left = 240,top = 212');\"); };");
        sb.append("var faceletsOrigKeyup = document.onkeyup; document.onkeyup = function(e) { if (window.event) e = window.event; if (String.fromCharCode(e.keyCode) == '" + this.getHotkey() + "' & e.shiftKey & e.ctrlKey) faceletsDebug('");
        sb.append(actionId);
        sb.append(actionId.indexOf(63) == -1 ? (char)'?' : '&');
        sb.append(KEY);
        sb.append('=');
        sb.append(UIDebug.writeDebugOutput(faces, this));
        sb.append("'); else if (faceletsOrigKeyup) faceletsOrigKeyup(e); };\n");
        sb.append("//]]>\n");
        ResponseWriter writer = faces.getResponseWriter();
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("language", (Object)"javascript", "language");
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        writer.writeText((Object)sb.toString(), (UIComponent)this, null);
        writer.endElement("script");
    }

    private static String writeDebugOutput(FacesContext faces, UIDebug component) throws IOException {
        FastWriter fw = new FastWriter();
        DevTools.debugHtml(fw, faces);
        Map session = faces.getExternalContext().getSessionMap();
        Map debugs = (Map)session.get(KEY);
        if (debugs == null) {
            debugs = new LinkedHashMap(){

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 5;
                }
            };
            session.put(KEY, debugs);
        }
        String id = "" + nextId++;
        debugs.put(id, fw.toString());
        if (component.isRecordStateSize()) {
            faces.getAttributes().put(PER_VIEW_DEBUG, id);
        }
        return id;
    }

    public static void computeViewStateSize(FacesContext context, Object[] state) throws IOException {
    }

    public static void computeViewStateSize(FacesContext context, Map<String, Serializable> state) throws IOException {
        Map contextMap = context.getAttributes();
        Map sessionMap = context.getExternalContext().getSessionMap();
        Map debugs = (Map)sessionMap.get(KEY);
        HashMap<String, Long> sizes = new HashMap<String, Long>();
        String id = contextMap.get(PER_VIEW_DEBUG).toString() + "_state";
        debugs.put(id, sizes);
        CountingOutputStream cos = new CountingOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(cos);
        long total = 0L;
        for (Map.Entry<String, Serializable> cur : state.entrySet()) {
            cos.reset();
            objectOutputStream.writeObject(cur.getValue());
            long count = cos.getByteCount();
            total += count;
            sizes.put(cur.getKey(), count);
        }
        sizes.put("", total);
    }

    private static String fetchDebugOutput(FacesContext faces, String id) {
        Map session = faces.getExternalContext().getSessionMap();
        Map debugs = (Map)session.get(KEY);
        String result = null;
        if (debugs != null) {
            result = (String)debugs.get(id);
            if (null == result) {
                return "Reload the view to inspect the debug information";
            }
            String viewStateKey = id + "_state";
            if (debugs.containsKey(viewStateKey)) {
                try {
                    final Map sizes = (Map)debugs.get(viewStateKey);
                    result = DevTools.interpolateViewState(result, new ViewStateRenderer(){

                        public String renderViewState() {
                            StringBuilder builder = new StringBuilder();
                            builder.append("<table>");
                            builder.append("<tr><th>Client id</th><th>Size in bytes</th></tr>");
                            for (Map.Entry cur : sizes.entrySet()) {
                                if ("".equals(cur.getKey())) continue;
                                builder.append("<tr><td>").append((String)cur.getKey()).append("</td><td>").append(cur.getValue()).append("</td></tr>");
                            }
                            builder.append("<tr><th>Total</th><th>").append(sizes.get("")).append("</th></tr>");
                            builder.append("</table>");
                            return builder.toString();
                        }
                    });
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Unable to write view state", ex);
                }
            } else {
                try {
                    result = DevTools.interpolateViewState(result, new ViewStateRenderer(){

                        public String renderViewState() {
                            return "No view state available.  Add recordStateSize=\"true\" to &lt;ui:debug&gt; to see view state size.";
                        }
                    });
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Unable to write view state", ex);
                }
            }
        }
        return result;
    }

    public static boolean debugRequest(FacesContext faces) {
        String id = (String)faces.getExternalContext().getRequestParameterMap().get(KEY);
        if (id != null) {
            Object resp = faces.getExternalContext().getResponse();
            if (!faces.getResponseComplete() && resp instanceof HttpServletResponse) {
                try {
                    HttpServletResponse httpResp = (HttpServletResponse)resp;
                    String page = UIDebug.fetchDebugOutput(faces, id);
                    if (page != null) {
                        httpResp.setContentType("text/html");
                        httpResp.getWriter().write(page);
                    } else {
                        httpResp.setContentType("text/plain");
                        httpResp.getWriter().write("No Debug Output Available");
                    }
                    httpResp.flushBuffer();
                    faces.responseComplete();
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(String hotkey) {
        this.hotkey = hotkey != null ? hotkey.toUpperCase() : "";
    }

    public static boolean isRecordStateSize(FacesContext context) {
        return context.getAttributes().containsKey(PER_VIEW_DEBUG);
    }

    public boolean isRecordStateSize() {
        return this.recordStateSize;
    }

    public void setRecordStateSize(boolean recordStateSize) {
        this.recordStateSize = recordStateSize;
    }

    public static interface ViewStateRenderer {
        public String renderViewState();
    }

    private static class CountingOutputStream
    extends OutputStream {
        long bytes;

        private CountingOutputStream() {
        }

        public Long getByteCount() {
            return this.bytes;
        }

        public void reset() {
            this.bytes = 0L;
        }

        public void write(int b) throws IOException {
            ++this.bytes;
        }
    }
}

