/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;

public class WebappResourceHelper
extends ResourceHelper {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private String BASE_RESOURCE_PATH;
    private boolean cacheTimestamp;

    public WebappResourceHelper() {
        WebConfiguration webconfig = WebConfiguration.getInstance();
        this.cacheTimestamp = webconfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
        this.BASE_RESOURCE_PATH = webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppResourcesDirectory);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebappResourceHelper other = (WebappResourceHelper)obj;
        if (this.BASE_RESOURCE_PATH == null ? other.BASE_RESOURCE_PATH != null : !this.BASE_RESOURCE_PATH.equals(other.BASE_RESOURCE_PATH)) {
            return false;
        }
        return this.cacheTimestamp == other.cacheTimestamp;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.BASE_RESOURCE_PATH != null ? this.BASE_RESOURCE_PATH.hashCode() : 0);
        hash = 37 * hash + (this.cacheTimestamp ? 1 : 0);
        return hash;
    }

    public String getBaseResourcePath() {
        return this.BASE_RESOURCE_PATH;
    }

    protected InputStream getNonCompressedInputStream(ResourceInfo resource, FacesContext ctx) throws IOException {
        return ctx.getExternalContext().getResourceAsStream(resource.getPath());
    }

    public URL getURL(ResourceInfo resource, FacesContext ctx) {
        try {
            return ctx.getExternalContext().getResource(resource.getPath());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public LibraryInfo findLibrary(String libraryName, String localePrefix, FacesContext ctx) {
        String path = localePrefix == null ? this.getBaseResourcePath() + '/' + libraryName : this.getBaseResourcePath() + '/' + localePrefix + '/' + libraryName;
        Set resourcePaths = ctx.getExternalContext().getResourcePaths(path);
        if (resourcePaths != null && !resourcePaths.isEmpty()) {
            VersionInfo version = this.getVersion(resourcePaths, false);
            return new LibraryInfo(libraryName, version, localePrefix, this);
        }
        return null;
    }

    public ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        ClientResourceInfo value;
        resourceName = this.trimLeadingSlash(resourceName);
        String basePath = library != null ? library.getPath(localePrefix) + '/' + resourceName : (localePrefix == null ? this.getBaseResourcePath() + '/' + resourceName : this.getBaseResourcePath() + '/' + localePrefix + '/' + resourceName);
        try {
            if (ctx.getExternalContext().getResource(basePath) == null) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            throw new FacesException((Throwable)e);
        }
        Set resourcePaths = ctx.getExternalContext().getResourcePaths(basePath);
        if (resourcePaths == null || resourcePaths.size() == 0) {
            value = library != null ? new ClientResourceInfo(library, resourceName, null, compressable, this.resourceSupportsEL(resourceName, library.getName(), ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(resourceName, null, localePrefix, this, compressable, this.resourceSupportsEL(resourceName, null, ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        } else {
            VersionInfo version = this.getVersion(resourcePaths, true);
            if (version == null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_determine_resource_version.", resourceName);
            }
            value = library != null ? new ClientResourceInfo(library, resourceName, version, compressable, this.resourceSupportsEL(resourceName, library.getName(), ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(resourceName, version, localePrefix, this, compressable, this.resourceSupportsEL(resourceName, null, ctx), ctx.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        }
        if (value.isCompressable()) {
            value = this.handleCompression(value);
        }
        return value;
    }
}

