/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class FacesFlowDefinitionConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACES_FLOW_DEFINITION = "faces-flow-definition";
    private static final String VIEW = "view";
    private static final String PAGE = "PAGE";
    private boolean validateFactories = true;

    public FacesFlowDefinitionConfigProcessor() {
    }

    public FacesFlowDefinitionConfigProcessor(boolean validateFactories) {
        this.validateFactories = validateFactories;
    }

    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        AtomicInteger facesFlowDefinitionCount = new AtomicInteger(0);
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList flows = document.getDocumentElement().getElementsByTagNameNS(namespace, FACES_FLOW_DEFINITION);
            if (flows == null || flows.getLength() <= 0) continue;
            this.processFacesFlowDefinitions(flows, facesFlowDefinitionCount);
        }
        if (0 < facesFlowDefinitionCount.get()) {
            WebConfiguration config = WebConfiguration.getInstance(sc);
            config.setHasFlows(true);
            String optionValue = config.getOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode);
            boolean clientWindowNeedsEnabling = false;
            if ("none".equals(optionValue)) {
                clientWindowNeedsEnabling = true;
                String featureName = WebConfiguration.WebContextInitParameter.ClientWindowMode.getQualifiedName();
                LOGGER.log(Level.WARNING, "{0} was set to none, but Faces Flows requires {0} is enabled.  Setting to ''url''.", new Object[]{featureName});
            } else if (null == optionValue) {
                clientWindowNeedsEnabling = true;
            }
            if (clientWindowNeedsEnabling) {
                config.setOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode, "url");
            }
        }
    }

    private void processFacesFlowDefinitions(NodeList factories, AtomicInteger flowCount) {
        int size = factories.getLength();
        for (int i = 0; i < size; ++i) {
            flowCount.incrementAndGet();
        }
    }
}

