/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.util.Cache;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Facelet;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletFactory;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFaceletFactory
extends FaceletFactory {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();
    private Compiler compiler;
    private Map<String, URL> relativeLocations;
    private ResourceResolver resolver;
    private URL baseUrl;
    private long refreshPeriod;
    private FaceletCache<DefaultFacelet> cache;
    Cache<String, IdMapper> idMappers;

    public DefaultFaceletFactory() {
        this.compiler = null;
        this.resolver = null;
        this.refreshPeriod = -1L;
        this.cache = null;
        this.baseUrl = null;
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        this(compiler, resolver, refreshPeriod, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod, FaceletCache cache) {
        this.init(compiler, resolver, refreshPeriod, cache);
    }

    public final void init(Compiler compiler, ResourceResolver resolver, long refreshPeriod, FaceletCache cache) {
        Util.notNull("compiler", compiler);
        Util.notNull("resolver", resolver);
        this.compiler = compiler;
        this.relativeLocations = new ConcurrentHashMap<String, URL>();
        this.resolver = resolver;
        this.baseUrl = resolver.resolveUrl("/");
        this.idMappers = new Cache<String, IdMapper>(new IdMapperFactory());
        this.refreshPeriod = refreshPeriod = refreshPeriod >= 0L ? refreshPeriod * 1000L : -1L;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Using ResourceResolver: {0}", resolver);
            log.log(Level.FINE, "Using Refresh Period: {0}", refreshPeriod);
        }
        this.cache = cache;
        FaceletCache.MemberFactory<DefaultFacelet> faceletFactory = new FaceletCache.MemberFactory<DefaultFacelet>(){

            public DefaultFacelet newInstance(URL key) throws IOException {
                return DefaultFaceletFactory.this.createFacelet(key);
            }
        };
        FaceletCache.MemberFactory<DefaultFacelet> metadataFaceletFactory = new FaceletCache.MemberFactory<DefaultFacelet>(){

            public DefaultFacelet newInstance(URL key) throws IOException {
                return DefaultFaceletFactory.this.createMetadataFacelet(key);
            }
        };
        try {
            Method m = FaceletCache.class.getDeclaredMethod("setMemberFactories", FaceletCache.MemberFactory.class, FaceletCache.MemberFactory.class);
            m.setAccessible(true);
            m.invoke(this.cache, faceletFactory, metadataFaceletFactory);
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, null, ex);
            }
            throw new FacesException((Throwable)ex);
        }
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public Facelet getFacelet(String uri) throws IOException {
        return this.getFacelet(this.resolveURL(uri));
    }

    public Facelet getMetadataFacelet(String uri) throws IOException {
        return this.getMetadataFacelet(this.resolveURL(uri));
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = this.resolver.resolveUrl(path);
            if (url == null) {
                throw new FacesFileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    public Facelet getFacelet(URL url) throws IOException {
        return (Facelet)this.cache.getFacelet(url);
    }

    public Facelet getMetadataFacelet(URL url) throws IOException {
        return (Facelet)this.cache.getViewMetadataFacelet(url);
    }

    public boolean needsToBeRefreshed(URL url) {
        return !this.cache.isFaceletCached(url);
    }

    private URL resolveURL(String uri) throws IOException {
        URL url = this.relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(this.baseUrl, uri);
            if (url != null) {
                this.relativeLocations.put(uri, url);
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIComponent createComponent(String taglibURI, String tagName, Map<String, Object> attributes) {
        UIComponent result;
        block24: {
            result = null;
            FacesContext context = FacesContext.getCurrentInstance();
            Application app = context.getApplication();
            ExternalContext extContext = context.getExternalContext();
            File tmpDir = (File)extContext.getApplicationMap().get("javax.servlet.context.tempdir");
            File tempFile = null;
            OutputStreamWriter osw = null;
            try {
                tempFile = File.createTempFile("mojarra", ".tmp", tmpDir);
                osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8");
                osw.append("<?xml version='1.0' encoding='");
                osw.append("UTF-8");
                osw.append("' ?>");
                osw.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
                osw.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"\n");
                osw.append("      xmlns:j=\"").append(taglibURI).append("\">");
                osw.append("  <j:").append(tagName).append(" ");
                if (!attributes.isEmpty()) {
                    for (Map.Entry<String, Object> attr : attributes.entrySet()) {
                        osw.append(attr.getKey()).append("=\"").append(attr.getValue().toString()).append("\"").append(" ");
                    }
                }
                String tempId = context.getViewRoot().createUniqueId(context, tagName);
                osw.append(" id=\"").append(tempId).append("\" />");
                osw.append("</html>");
                try {
                    osw.flush();
                    osw.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                URL fabricatedFaceletPage = tempFile.toURI().toURL();
                DefaultFacelet f = this.createFacelet(fabricatedFaceletPage);
                UIComponent tmp = app.createComponent("javax.faces.NamingContainer");
                tmp.setId(context.getViewRoot().createUniqueId());
                f.apply(context, tmp);
                result = tmp.findComponent(tempId);
                tmp.getChildren().clear();
                osw = null;
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException ioe) {
            }
            finally {
                if (null != osw) {
                    try {
                        osw.close();
                    }
                    catch (IOException ex) {}
                }
                if (null != tempFile) {
                    tempFile.delete();
                }
            }
            try {
                byte[] faceletPage = "facelet".getBytes("UTF-8");
                ByteArrayInputStream bais = new ByteArrayInputStream(faceletPage);
            }
            catch (UnsupportedEncodingException uee) {
                if (!log.isLoggable(Level.SEVERE)) break block24;
                log.log(Level.SEVERE, "Unsupported encoding when creating component for " + tagName + " in " + taglibURI, uee);
            }
        }
        result.setId(null);
        return result;
    }

    private DefaultFacelet createFacelet(URL url) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = '/' + url.getFile().replaceFirst(escapedBaseURL, "");
        try {
            FaceletHandler h = this.compiler.compile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet createMetadataFacelet(URL url) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Metadata Facelet for: " + url);
        }
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = '/' + url.getFile().replaceFirst(escapedBaseURL, "");
        try {
            FaceletHandler h = this.compiler.metadataCompile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdMapperFactory
    implements Cache.Factory<String, IdMapper> {
        private IdMapperFactory() {
        }

        @Override
        public IdMapper newInstance(String arg) throws InterruptedException {
            return new IdMapper();
        }
    }
}

