/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.ui;

import com.sun.faces.facelets.FaceletContextImplBase;
import com.sun.faces.facelets.TemplateClient;
import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.ui.DefineHandler;
import com.sun.faces.facelets.tag.ui.ParamHandler;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;

public final class CompositionHandler
extends TagHandlerImpl
implements TemplateClient {
    private static final Logger log = FacesLogger.FACELETS_COMPOSITION.getLogger();
    public static final String Name = "composition";
    protected final TagAttribute template = this.getAttribute("template");
    protected final Map handlers;
    protected final ParamHandler[] params;

    public CompositionHandler(TagConfig config) {
        super(config);
        if (this.template != null) {
            this.handlers = new HashMap();
            Iterator itr = this.findNextByType(DefineHandler.class);
            DefineHandler d = null;
            while (itr.hasNext()) {
                d = (DefineHandler)((Object)itr.next());
                this.handlers.put(d.getName(), d);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine(this.tag + " found Define[" + d.getName() + "]");
            }
            ArrayList paramC = new ArrayList();
            itr = this.findNextByType(ParamHandler.class);
            while (itr.hasNext()) {
                paramC.add(itr.next());
            }
            if (paramC.size() > 0) {
                this.params = new ParamHandler[paramC.size()];
                for (int i = 0; i < this.params.length; ++i) {
                    this.params[i] = (ParamHandler)((Object)paramC.get(i));
                }
            } else {
                this.params = null;
            }
        } else {
            this.params = null;
            this.handlers = null;
        }
    }

    public void apply(FaceletContext ctxObj, UIComponent parent) throws IOException {
        FaceletContextImplBase ctx = (FaceletContextImplBase)ctxObj;
        if (this.template != null) {
            VariableMapper orig = ctx.getVariableMapper();
            if (this.params != null) {
                VariableMapperWrapper vm = new VariableMapperWrapper(orig);
                ctx.setVariableMapper(vm);
                for (int i = 0; i < this.params.length; ++i) {
                    this.params[i].apply(ctx, parent);
                }
            }
            ctx.extendClient(this);
            Object pathObj = null;
            try {
                pathObj = this.template.getObject((FaceletContext)ctx, Object.class);
                if (pathObj instanceof String) {
                    String path = pathObj.toString();
                    if (path.trim().length() == 0) {
                        throw new TagAttributeException(this.tag, this.template, "Invalid path : " + path);
                    }
                    ctx.includeFacelet(parent, path);
                }
                try {
                    ctx.includeFacelet(parent, (URL)pathObj);
                }
                catch (ClassCastException cce) {
                    throw new TagAttributeException(this.tag, this.template, "Invalid path : " + pathObj, (Throwable)cce);
                }
            }
            catch (IOException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, e.toString(), e);
                }
                throw new TagAttributeException(this.tag, this.template, "Invalid path : " + pathObj);
            }
            finally {
                ctx.popClient(this);
                ctx.setVariableMapper(orig);
            }
        } else {
            this.nextHandler.apply((FaceletContext)ctx, parent);
        }
    }

    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException {
        if (name != null) {
            if (this.handlers == null) {
                return false;
            }
            DefineHandler handler = (DefineHandler)((Object)this.handlers.get(name));
            if (handler != null) {
                handler.applyDefinition(ctx, parent);
                return true;
            }
            return false;
        }
        this.nextHandler.apply(ctx, parent);
        return true;
    }
}

