/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow.builder;

import com.sun.faces.flow.FlowImpl;
import com.sun.faces.flow.ParameterImpl;
import com.sun.faces.flow.ViewNodeImpl;
import com.sun.faces.flow.builder.FlowCallBuilderImpl;
import com.sun.faces.flow.builder.MethodCallBuilderImpl;
import com.sun.faces.flow.builder.ReturnBuilderImpl;
import com.sun.faces.flow.builder.SwitchBuilderImpl;
import java.util.List;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.ViewNode;
import javax.faces.flow.builder.FlowBuilder;
import javax.faces.flow.builder.FlowCallBuilder;
import javax.faces.flow.builder.MethodCallBuilder;
import javax.faces.flow.builder.ReturnBuilder;
import javax.faces.flow.builder.SwitchBuilder;

public class FlowBuilderImpl
extends FlowBuilder {
    private FlowImpl flow = new FlowImpl();
    private ExpressionFactory expressionFactory;
    private ELContext elContext;

    public FlowBuilderImpl(FacesContext context) {
        this.expressionFactory = context.getApplication().getExpressionFactory();
        this.elContext = context.getELContext();
    }

    public FlowBuilder viewNode(String viewNodeId, String vdlDocumentId) {
        List<ViewNode> viewNodes = this.flow.getViews();
        ViewNodeImpl viewNode = new ViewNodeImpl(viewNodeId, vdlDocumentId);
        viewNodes.add(viewNode);
        return this;
    }

    public SwitchBuilder switchNode(String switchNodeId) {
        return new SwitchBuilderImpl(this, switchNodeId);
    }

    public ReturnBuilder returnNode(String returnNodeId) {
        return new ReturnBuilderImpl(this, returnNodeId);
    }

    public MethodCallBuilder methodCallNode(String methodCallNodeId) {
        return new MethodCallBuilderImpl(this, methodCallNodeId);
    }

    public FlowCallBuilder flowCallNode(String flowCallNodeId) {
        return new FlowCallBuilderImpl(this, flowCallNodeId);
    }

    public FlowBuilder id(String flowId) {
        this.flow.setId(flowId);
        this.flow.setStartNodeId(flowId);
        this.viewNode(flowId, "/" + flowId + "/" + flowId + ".xhtml");
        return this;
    }

    public FlowBuilder markAsStartNode(String startNodeId) {
        this.flow.setStartNodeId(startNodeId);
        return this;
    }

    public FlowBuilder initializer(MethodExpression methodExpression) {
        this.flow.setInitializer(methodExpression);
        return this;
    }

    public FlowBuilder finalizer(MethodExpression methodExpression) {
        this.flow.setFinalizer(methodExpression);
        return this;
    }

    public FlowBuilder inboundParameter(String name, ValueExpression value) {
        ParameterImpl param = new ParameterImpl(name, value);
        this.flow.getInboundParameters().put(name, param);
        return this;
    }

    public FlowBuilder inboundParameter(String name, String value) {
        ValueExpression ve = this.expressionFactory.createValueExpression(this.elContext, value, Object.class);
        this.inboundParameter(name, ve);
        return this;
    }

    public Flow getFlow() {
        return this.flow;
    }

    ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    ELContext getELContext() {
        return this.elContext;
    }
}

