/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.FaceletResourceInfo;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImpl
extends Resource
implements Externalizable {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private transient ResourceInfo resourceInfo;
    private transient Map<String, String> responseHeaders;
    private long initialTime;
    private long maxAge;

    public ResourceImpl() {
    }

    public ResourceImpl(ResourceInfo resourceInfo, String contentType, long initialTime, long maxAge) {
        this.resourceInfo = resourceInfo;
        super.setResourceName(resourceInfo.getName());
        super.setLibraryName(resourceInfo.getLibraryInfo() != null ? resourceInfo.getLibraryInfo().getName() : null);
        super.setContentType(contentType);
        this.initialTime = initialTime;
        this.maxAge = maxAge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceImpl resource = (ResourceImpl)o;
        return this.resourceInfo.equals(resource.resourceInfo);
    }

    public int hashCode() {
        return this.resourceInfo.hashCode();
    }

    public InputStream getInputStream() throws IOException {
        this.initResourceInfo();
        return this.resourceInfo.getHelper().getInputStream(this.resourceInfo, FacesContext.getCurrentInstance());
    }

    public URL getURL() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return this.resourceInfo.getHelper().getURL(this.resourceInfo, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResponseHeaders() {
        if (this.isResourceRequest()) {
            FacesContext ctx;
            if (this.responseHeaders == null) {
                this.responseHeaders = new HashMap<String, String>(6, 1.0f);
            }
            long expiresTime = (ctx = FacesContext.getCurrentInstance()).isProjectStage(ProjectStage.Development) ? new Date().getTime() : new Date().getTime() + this.maxAge;
            SimpleDateFormat format = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
            format.setTimeZone(GMT);
            this.responseHeaders.put("Expires", format.format(new Date(expiresTime)));
            URL url = this.getURL();
            InputStream in = null;
            try {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                in = conn.getInputStream();
                long lastModified = conn.getLastModified();
                long contentLength = conn.getContentLength();
                if (lastModified == 0L) {
                    lastModified = this.initialTime;
                }
                this.responseHeaders.put("Last-Modified", format.format(new Date(lastModified)));
                if (lastModified != 0L && contentLength != -1L) {
                    this.responseHeaders.put("ETag", "W/\"" + contentLength + '-' + lastModified + '\"');
                }
            }
            catch (IOException ignored) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return this.responseHeaders;
        }
        return Collections.emptyMap();
    }

    public String getRequestPath() {
        String contract;
        String localePrefix;
        FacesContext context = FacesContext.getCurrentInstance();
        String facesServletMapping = Util.getFacesMapping(context);
        String uri = Util.isPrefixMapped(facesServletMapping) ? facesServletMapping + "/javax.faces.resource" + '/' + this.getResourceName() : "/javax.faces.resource/" + this.getResourceName() + facesServletMapping;
        boolean queryStarted = false;
        if (null != this.getLibraryName()) {
            queryStarted = true;
            uri = uri + "?ln=" + this.getLibraryName();
        }
        String version = "";
        this.initResourceInfo();
        if (this.resourceInfo.getLibraryInfo() != null && this.resourceInfo.getLibraryInfo().getVersion() != null) {
            version = version + this.resourceInfo.getLibraryInfo().getVersion().toString();
        }
        if (this.resourceInfo.getVersion() != null) {
            version = version + this.resourceInfo.getVersion().toString();
        }
        if (version.length() > 0) {
            uri = uri + (queryStarted ? "&v=" : "?v=") + version;
            queryStarted = true;
        }
        if ((localePrefix = this.resourceInfo.getLocalePrefix()) != null) {
            uri = uri + (queryStarted ? "&loc=" : "?loc=") + localePrefix;
            queryStarted = true;
        }
        if ((contract = this.resourceInfo.getContract()) != null) {
            uri = uri + (queryStarted ? "&con=" : "?con=") + contract;
            queryStarted = true;
        }
        if ("jsf.js".equals(this.getResourceName()) && "javax.faces".equals(this.getLibraryName())) {
            ProjectStage stage = context.getApplication().getProjectStage();
            switch (stage) {
                case Development: {
                    uri = uri + (queryStarted ? "&stage=Development" : "?stage=Development");
                    break;
                }
                case SystemTest: {
                    uri = uri + (queryStarted ? "&stage=SystemTest" : "?stage=SystemTest");
                    break;
                }
                case UnitTest: {
                    uri = uri + (queryStarted ? "&stage=UnitTest" : "?stage=UnitTest");
                    break;
                }
                default: {
                    assert (stage.equals((Object)ProjectStage.Production));
                    break;
                }
            }
        }
        uri = context.getApplication().getViewHandler().getResourceURL(context, uri);
        return uri;
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        if (this.resourceInfo instanceof FaceletResourceInfo) {
            return true;
        }
        Map requestHeaders = context.getExternalContext().getRequestHeaderMap();
        if (requestHeaders.containsKey(IF_MODIFIED_SINCE)) {
            this.initResourceInfo();
            long lastModifiedOfResource = ((ClientResourceInfo)this.resourceInfo).getLastModified(context);
            long lastModifiedHeader = this.getIfModifiedHeader(context.getExternalContext());
            return lastModifiedOfResource > lastModifiedHeader;
        }
        return true;
    }

    private long getIfModifiedHeader(ExternalContext extcontext) {
        Object request = extcontext.getRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getDateHeader(IF_MODIFIED_SINCE);
        }
        SimpleDateFormat format = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
        try {
            Date ifModifiedSinceDate = format.parse((String)extcontext.getRequestHeaderMap().get(IF_MODIFIED_SINCE));
            return ifModifiedSinceDate.getTime();
        }
        catch (ParseException ex) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.invalid_if_modified_since_header", new Object[]{extcontext.getRequestHeaderMap().get(IF_MODIFIED_SINCE)});
                if (ex != null) {
                    LOGGER.log(Level.WARNING, "", ex);
                }
            }
            return -1L;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getResourceName());
        out.writeObject(this.getLibraryName());
        out.writeObject(this.getContentType());
        out.writeLong(this.initialTime);
        out.writeLong(this.maxAge);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setResourceName((String)in.readObject());
        this.setLibraryName((String)in.readObject());
        this.setContentType((String)in.readObject());
        this.initialTime = in.readLong();
        this.maxAge = in.readLong();
    }

    private void initResourceInfo() {
        if (this.resourceInfo != null) {
            return;
        }
        ResourceManager manager = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext()).getResourceManager();
        this.resourceInfo = manager.findResource(this.getLibraryName(), this.getResourceName(), this.getContentType(), FacesContext.getCurrentInstance());
    }

    private boolean isResourceRequest() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return ctx.getApplication().getResourceHandler().isResourceRequest(ctx);
    }
}

