/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import com.sun.faces.util.Util;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.el.Expression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DevTools {
    private static final String TS = "&lt;";
    private static final String ERROR_TEMPLATE = "META-INF/facelet-dev-error.xml";
    private static String[] ERROR_PARTS;
    private static final String DEBUG_TEMPLATE = "META-INF/facelet-dev-debug.xml";
    private static String[] DEBUG_PARTS;
    private static final String[] IGNORE;

    private DevTools() {
        throw new IllegalStateException();
    }

    public static void debugHtml(Writer writer, FacesContext faces, Throwable e) throws IOException {
        DevTools.init();
        Date now = new Date();
        for (String ERROR_PART : ERROR_PARTS) {
            if ("message".equals(ERROR_PART)) {
                DevTools.writeMessage(writer, e);
                continue;
            }
            if ("trace".equals(ERROR_PART)) {
                DevTools.writeException(writer, e);
                continue;
            }
            if ("now".equals(ERROR_PART)) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(ERROR_PART)) {
                DevTools.writeComponent(writer, (UIComponent)faces.getViewRoot());
                continue;
            }
            if ("vars".equals(ERROR_PART)) {
                DevTools.writeVariables(writer, faces);
                continue;
            }
            writer.write(ERROR_PART);
        }
    }

    public static void writeMessage(Writer writer, Throwable e) throws IOException {
        if (e != null) {
            String msg = e.getMessage();
            if (msg != null) {
                writer.write(msg.replaceAll("<", TS));
            } else {
                writer.write(e.getClass().getName());
            }
        }
    }

    public static void writeException(Writer writer, Throwable e) throws IOException {
        if (e != null) {
            StringWriter str = new StringWriter(256);
            PrintWriter pstr = new PrintWriter(str);
            e.printStackTrace(pstr);
            pstr.close();
            writer.write(str.toString().replaceAll("<", TS));
        }
    }

    public static void debugHtml(Writer writer, FacesContext faces) throws IOException {
        DevTools.init();
        Date now = new Date();
        for (String DEBUG_PART : DEBUG_PARTS) {
            if ("message".equals(DEBUG_PART)) {
                writer.write(faces.getViewRoot().getViewId());
                continue;
            }
            if ("now".equals(DEBUG_PART)) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(DEBUG_PART)) {
                DevTools.writeComponent(writer, (UIComponent)faces.getViewRoot());
                continue;
            }
            if ("vars".equals(DEBUG_PART)) {
                DevTools.writeVariables(writer, faces);
                continue;
            }
            writer.write(DEBUG_PART);
        }
    }

    public static void writeVariables(Writer writer, FacesContext faces) throws IOException {
        ExternalContext ctx = faces.getExternalContext();
        DevTools.writeVariables(writer, ctx.getRequestParameterMap(), "Request Parameters");
        if (faces.getViewRoot() != null) {
            Map viewMap = faces.getViewRoot().getViewMap(false);
            if (viewMap != null) {
                DevTools.writeVariables(writer, viewMap, "View Attributes");
            } else {
                DevTools.writeVariables(writer, Collections.emptyMap(), "View Attributes");
            }
        } else {
            DevTools.writeVariables(writer, Collections.emptyMap(), "View Attributes");
        }
        DevTools.writeVariables(writer, ctx.getRequestMap(), "Request Attributes");
        Flash flash = ctx.getFlash();
        try {
            flash = ctx.getFlash();
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        if (flash != null) {
            DevTools.writeVariables(writer, flash, "Flash Attributes");
        } else {
            DevTools.writeVariables(writer, Collections.emptyMap(), "Flash Attributes");
        }
        if (ctx.getSession(false) != null) {
            DevTools.writeVariables(writer, ctx.getSessionMap(), "Session Attributes");
        } else {
            DevTools.writeVariables(writer, Collections.emptyMap(), "Session Attributes");
        }
        DevTools.writeVariables(writer, ctx.getApplicationMap(), "Application Attributes");
    }

    public static void writeComponent(Writer writer, UIComponent c) throws IOException {
        writer.write("<dl style=\"color: #006;\"><dt style=\"border: 1px solid #DDD; padding: 4px; border-left: 2px solid #666; font-family: 'Courier New', Courier, mono; font-size: small;");
        if (c != null && DevTools.isText(c)) {
            writer.write("color: #999;");
        }
        writer.write("\">");
        if (c == null) {
            return;
        }
        boolean hasChildren = c.getChildCount() > 0 || c.getFacets().size() > 0;
        DevTools.writeStart(writer, c, hasChildren);
        writer.write("</dt>");
        if (hasChildren) {
            if (c.getFacets().size() > 0) {
                for (Map.Entry entry : c.getFacets().entrySet()) {
                    writer.write("<dd style=\"margin-top: 2px; margin-bottom: 2px;\">");
                    writer.write("<span style=\"font-family: 'Trebuchet MS', Verdana, Arial, Sans-Serif; font-size: small;\">");
                    writer.write((String)entry.getKey());
                    writer.write("</span>");
                    DevTools.writeComponent(writer, (UIComponent)entry.getValue());
                    writer.write("</dd>");
                }
            }
            if (c.getChildCount() > 0) {
                for (UIComponent child : c.getChildren()) {
                    writer.write("<dd style=\"margin-top: 2px; margin-bottom: 2px;\">");
                    DevTools.writeComponent(writer, child);
                    writer.write("</dd>");
                }
            }
            writer.write("<dt style=\"border: 1px solid #DDD; padding: 4px; border-left: 2px solid #666; font-family: 'Courier New', Courier, mono; font-size: small;\">");
            DevTools.writeEnd(writer, c);
            writer.write("</dt>");
        }
        writer.write("</dl>");
    }

    private static void init() throws IOException {
        if (ERROR_PARTS == null) {
            ERROR_PARTS = DevTools.splitTemplate(ERROR_TEMPLATE);
        }
        if (DEBUG_PARTS == null) {
            DEBUG_PARTS = DevTools.splitTemplate(DEBUG_TEMPLATE);
        }
    }

    private static String[] splitTemplate(String rsc) throws IOException {
        int read;
        ClassLoader loader = Util.getCurrentLoader(DevTools.class);
        InputStream is = loader.getResourceAsStream(rsc);
        if (is == null && (is = (loader = DevTools.class.getClassLoader()).getResourceAsStream(rsc)) == null) {
            throw new FileNotFoundException(rsc);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        while ((read = is.read(buff)) != -1) {
            baos.write(buff, 0, read);
        }
        String str = baos.toString("UTF-8");
        return str.split("@@");
    }

    private static void writeVariables(Writer writer, Map<String, ?> vars, String caption) throws IOException {
        writer.write("<table style=\"border: 1px solid #CCC; border-collapse: collapse; border-spacing: 0px; width: 100%; text-align: left;\"><caption style=\"text-align: left; padding: 10px 0; font-size: large;\">");
        writer.write(caption);
        writer.write("</caption><thead stype=\"padding: 2px; color: #030; background-color: #F9F9F9;\"><tr style=\"padding: 2px; color: #030; background-color: #F9F9F9;\"><th style=\"padding: 2px; color: #030; background-color: #F9F9F9;width: 10%; \">Name</th><th style=\"padding: 2px; color: #030; background-color: #F9F9F9;width: 90%; \">Value</th></tr></thead><tbody style=\"padding: 10px 6px;\">");
        boolean written = false;
        if (!vars.isEmpty()) {
            TreeMap map = new TreeMap(vars);
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (key.indexOf(46) != -1) continue;
                writer.write("<tr style=\"padding: 10px 6px;\"><td style=\"padding: 10px 6px;\">");
                writer.write(key.replaceAll("<", TS));
                writer.write("</td><td>");
                writer.write(entry.getValue() == null ? "null" : entry.getValue().toString().replaceAll("<", TS));
                writer.write("</td></tr>");
                written = true;
            }
        }
        if (!written) {
            writer.write("<tr style=\"padding: 10px 6px;\"><td colspan=\"2\" style=\"padding: 10px 6px;\"><em>None</em></td></tr>");
        }
        writer.write("</tbody></table>");
    }

    private static void writeEnd(Writer writer, UIComponent c) throws IOException {
        if (!DevTools.isText(c)) {
            writer.write(TS);
            writer.write(47);
            writer.write(DevTools.getName(c));
            writer.write(62);
        }
    }

    private static void writeAttributes(Writer writer, UIComponent c) {
        try {
            PropertyDescriptor[] pd;
            BeanInfo info = Introspector.getBeanInfo(c.getClass());
            for (PropertyDescriptor aPd : pd = info.getPropertyDescriptors()) {
                if (aPd.getWriteMethod() == null || Arrays.binarySearch(IGNORE, aPd.getName()) >= 0) continue;
                Method m = aPd.getReadMethod();
                try {
                    Object v = m.invoke((Object)c, new Object[0]);
                    if (v == null || v instanceof Collection || v instanceof Map || v instanceof Iterator) continue;
                    writer.write(" ");
                    writer.write(aPd.getName());
                    writer.write("=\"");
                    String str = v instanceof Expression ? ((Expression)v).getExpressionString() : (v instanceof ValueBinding ? ((ValueBinding)v).getExpressionString() : (v instanceof MethodBinding ? ((MethodBinding)v).getExpressionString() : v.toString()));
                    writer.write(str.replaceAll("<", TS));
                    writer.write("\"");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ValueBinding binding = c.getValueBinding("binding");
            if (binding != null) {
                writer.write(" binding=\"");
                writer.write(binding.getExpressionString().replaceAll("<", TS));
                writer.write("\"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeStart(Writer writer, UIComponent c, boolean children) throws IOException {
        if (DevTools.isText(c)) {
            String str = c.toString().trim();
            writer.write(str.replaceAll("<", TS));
        } else {
            writer.write(TS);
            writer.write(DevTools.getName(c));
            DevTools.writeAttributes(writer, c);
            if (children) {
                writer.write(62);
            } else {
                writer.write("/>");
            }
        }
    }

    private static String getName(UIComponent c) {
        String nm = c.getClass().getName();
        return nm.substring(nm.lastIndexOf(46) + 1);
    }

    private static boolean isText(UIComponent c) {
        return c.getClass().getName().startsWith("com.sun.faces.facelets.compiler");
    }

    static {
        IGNORE = new String[]{"parent", "rendererType"};
    }
}

