/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ProtectedViewException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreViewPhase
extends Phase {
    private static final String WEBAPP_ERROR_PAGE_MARKER = "javax.servlet.error.message";
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private WebConfiguration webConfig;
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";

    @Override
    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    @Override
    public void doPhase(FacesContext context, Lifecycle lifecycle, ListIterator<PhaseListener> listeners) {
        Util.getViewHandler(context).initView(context);
        super.doPhase(context, lifecycle, listeners);
        this.notifyAfter(context, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a pre created view in FacesContext");
            }
            facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
            this.deliverPostRestoreStateEvent(facesContext);
            if (!facesContext.isPostback()) {
                facesContext.renderResponse();
            }
            return;
        }
        FacesException thrownException = null;
        try {
            boolean isPostBack;
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            String viewId = (String)requestMap.get("javax.servlet.include.path_info");
            if (viewId == null) {
                viewId = facesContext.getExternalContext().getRequestPathInfo();
            }
            if (viewId == null) {
                viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
            }
            if (viewId == null) {
                viewId = facesContext.getExternalContext().getRequestServletPath();
            }
            if (viewId == null) {
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
            }
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            boolean bl = isPostBack = facesContext.isPostback() && !RestoreViewPhase.isErrorPage(facesContext);
            if (isPostBack) {
                facesContext.setProcessingEvents(false);
                viewRoot = viewHandler.restoreView(facesContext, viewId);
                if (viewRoot == null) {
                    if (this.is11CompatEnabled(facesContext)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Postback: recreating a view for " + viewId);
                        }
                        viewRoot = viewHandler.createView(facesContext, viewId);
                        facesContext.renderResponse();
                    } else {
                        Object[] params = new Object[]{viewId};
                        throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", params), viewId);
                    }
                }
                facesContext.setViewRoot(viewRoot);
                facesContext.setProcessingEvents(true);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Postback: restored view for " + viewId);
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("New request: creating a view for " + viewId);
                }
                String derivedViewId = viewHandler.deriveLogicalViewId(facesContext, viewId);
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, derivedViewId);
                this.maybeTakeProtectedViewAction(facesContext, viewHandler, vdl, viewId);
                if (vdl != null) {
                    UIComponent metaDataFacet;
                    Collection params;
                    ViewMetadata metadata = vdl.getViewMetadata(facesContext, viewId);
                    if (metadata != null && (params = ViewMetadata.getViewParameters((UIViewRoot)(viewRoot = metadata.createMetadataView(facesContext)))).isEmpty() && (null == (metaDataFacet = (UIComponent)viewRoot.getFacets().get("javax_faces_metadata")) || 0 == metaDataFacet.getChildCount())) {
                        facesContext.renderResponse();
                    }
                } else {
                    facesContext.renderResponse();
                }
                if (null == viewRoot) {
                    viewRoot = Util.getViewHandler(facesContext).createView(facesContext, viewId);
                }
                facesContext.setViewRoot(viewRoot);
                assert (null != viewRoot);
            }
        }
        catch (FacesException fe) {
            thrownException = fe;
        }
        finally {
            if (null != thrownException) {
                throw thrownException;
            }
            this.deliverPostRestoreStateEvent(facesContext);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RestoreViewPhase");
        }
    }

    private void maybeTakeProtectedViewAction(FacesContext context, ViewHandler viewHandler, ViewDeclarationLanguage vdl, String viewId) {
        Set urlPatterns = viewHandler.getProtectedViewsUnmodifiable();
        boolean currentViewIsProtected = false;
        for (String cur : urlPatterns) {
            if (cur.equals(viewId)) {
                currentViewIsProtected = true;
            }
            if (!currentViewIsProtected) continue;
            break;
        }
        if (currentViewIsProtected) {
            ExternalContext extContext = context.getExternalContext();
            Map headers = extContext.getRequestHeaderMap();
            if (headers.containsKey("Referer")) {
                String referer = (String)headers.get("Referer");
                boolean refererIsInProtectedSet = false;
                for (String cur : urlPatterns) {
                    if (cur.equals(referer)) {
                        refererIsInProtectedSet = true;
                    }
                    if (!refererIsInProtectedSet) continue;
                    break;
                }
                if (!refererIsInProtectedSet) {
                    URI uri = null;
                    boolean hostsMatch = false;
                    boolean portsMatch = false;
                    boolean contextPathsMatch = false;
                    boolean refererOriginatesInThisWebapp = false;
                    try {
                        uri = new URI(referer);
                        hostsMatch = uri.getHost().equals(extContext.getRequestServerName());
                        portsMatch = uri.getPort() == extContext.getRequestServerPort();
                        contextPathsMatch = uri.getPath().contains(extContext.getApplicationContextPath());
                    }
                    catch (URISyntaxException use) {
                        throw new ProtectedViewException((Throwable)use);
                    }
                    boolean bl = refererOriginatesInThisWebapp = hostsMatch && portsMatch && contextPathsMatch;
                    if (!refererOriginatesInThisWebapp) {
                        String message = FacesLogger.LIFECYCLE.interpolateMessage(context, "jsf.lifecycle.invalid.referer", new String[]{referer, viewId});
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, message);
                        }
                        throw new ProtectedViewException(message);
                    }
                }
            } else {
                String rkId = viewHandler.calculateRenderKitId(context);
                ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, rkId);
                String incomingSecretKeyValue = (String)extContext.getRequestParameterMap().get("javax.faces.Token");
                String correctSecretKeyValue = rsm.getCryptographicallyStrongTokenFromSession(context);
                if (null == incomingSecretKeyValue || !correctSecretKeyValue.equals(incomingSecretKeyValue)) {
                    throw new ProtectedViewException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverPostRestoreStateEvent(FacesContext facesContext) throws FacesException {
        UIViewRoot root = facesContext.getViewRoot();
        final PostRestoreStateEvent postRestoreStateEvent = new PostRestoreStateEvent((UIComponent)root);
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
            facesContext.getApplication().publishEvent(facesContext, PostRestoreStateEvent.class, (Object)root);
            EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, hints);
            root.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    postRestoreStateEvent.setComponent(target);
                    target.processEvent((ComponentSystemEvent)postRestoreStateEvent);
                    return VisitResult.ACCEPT;
                }
            });
        }
        catch (AbortProcessingException e) {
            facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)new ExceptionQueuedEventContext(facesContext, (Throwable)e, null, PhaseId.RESTORE_VIEW));
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
    }

    private void notifyAfter(FacesContext context, Lifecycle lifecycle) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (null == viewRoot) {
            return;
        }
        MethodExpression afterPhase = viewRoot.getAfterPhaseListener();
        if (null != afterPhase) {
            try {
                PhaseEvent event = new PhaseEvent(context, PhaseId.RESTORE_VIEW, lifecycle);
                afterPhase.invoke(context.getELContext(), new Object[]{event});
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{afterPhase.getExpressionString(), "afterPhase"});
                }
                return;
            }
        }
    }

    private static boolean isErrorPage(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(WEBAPP_ERROR_PAGE_MARKER) != null;
    }

    private WebConfiguration getWebConfig(FacesContext context) {
        if (this.webConfig == null) {
            this.webConfig = WebConfiguration.getInstance(context.getExternalContext());
        }
        return this.webConfig;
    }

    private boolean is11CompatEnabled(FacesContext context) {
        return this.getWebConfig(context).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableRestoreView11Compatibility);
    }
}

