/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopedCDIContext
implements Context,
Serializable {
    private static final long serialVersionUID = -6245899073989073951L;
    private static final String VIEW_SCOPE_BEAN_MAP_KEY = ViewScopedCDIContext.class.getName() + "_BEANS";
    private static final String VIEW_SCOPE_CREATIONAL_MAP_KEY = ViewScopedCDIContext.class.getName() + "_CREATIONAL";
    private static final String PER_SESSION_BEAN_MAP_LIST = ViewScopedCDIContext.class.getPackage().getName() + ".PER_SESSION_BEAN_MAP_LIST";
    private static final String PER_SESSION_CREATIONAL_LIST = ViewScopedCDIContext.class.getPackage().getName() + ".PER_SESSION_CREATIONAL_LIST";

    private static Map<Contextual<?>, Object> getViewScopedBeanMapForCurrentView() {
        return ViewScopedCDIContext.getViewScopedBeanMapForCurrentView(true);
    }

    private static Map<Contextual<?>, Object> getViewScopedBeanMapForCurrentView(boolean create) {
        ConcurrentHashMap result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null == context) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (null != viewRoot) {
            Map viewMap = viewRoot.getViewMap(create);
            if (null != viewMap) {
                ExternalContext extContext = context.getExternalContext();
                Map sessionMap = extContext.getSessionMap();
                result = (ConcurrentHashMap)sessionMap.get(VIEW_SCOPE_BEAN_MAP_KEY);
                if (null == result && create) {
                    result = new ConcurrentHashMap();
                    sessionMap.put(VIEW_SCOPE_BEAN_MAP_KEY, result);
                    ViewScopedCDIContext.ensureBeanMapCleanupOnSessionDestroyed(sessionMap, VIEW_SCOPE_BEAN_MAP_KEY);
                }
            } else {
                ExternalContext extContext = context.getExternalContext();
                Map sessionMap = extContext.getSessionMap();
                result = (Map)sessionMap.get(VIEW_SCOPE_BEAN_MAP_KEY);
            }
        }
        return result;
    }

    private static Map<Contextual<?>, CreationalContext<?>> getViewScopedCreationalMapForCurrentView() {
        return ViewScopedCDIContext.getViewScopedCreationalMapForCurrentView(true);
    }

    private static Map<Contextual<?>, CreationalContext<?>> getViewScopedCreationalMapForCurrentView(boolean create) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (null == context) {
            return null;
        }
        ExternalContext extContext = context.getExternalContext();
        Map sessionMap = extContext.getSessionMap();
        ConcurrentHashMap result = (ConcurrentHashMap)sessionMap.get(VIEW_SCOPE_CREATIONAL_MAP_KEY);
        if (null == result && create) {
            result = new ConcurrentHashMap();
            sessionMap.put(VIEW_SCOPE_CREATIONAL_MAP_KEY, result);
            ViewScopedCDIContext.ensureCreationalCleanupOnSessionDestroyed(sessionMap, VIEW_SCOPE_CREATIONAL_MAP_KEY);
        }
        return result;
    }

    private static void ensureBeanMapCleanupOnSessionDestroyed(Map<String, Object> sessionMap, String flowBeansForClientWindow) {
        ArrayList<String> beanMapList = (ArrayList<String>)sessionMap.get(PER_SESSION_BEAN_MAP_LIST);
        if (null == beanMapList) {
            beanMapList = new ArrayList<String>();
            sessionMap.put(PER_SESSION_BEAN_MAP_LIST, beanMapList);
        }
        beanMapList.add(flowBeansForClientWindow);
    }

    private static void ensureCreationalCleanupOnSessionDestroyed(Map<String, Object> sessionMap, String creationalForClientWindow) {
        ArrayList<String> beanMapList = (ArrayList<String>)sessionMap.get(PER_SESSION_CREATIONAL_LIST);
        if (null == beanMapList) {
            beanMapList = new ArrayList<String>();
            sessionMap.put(PER_SESSION_CREATIONAL_LIST, beanMapList);
        }
        beanMapList.add(creationalForClientWindow);
    }

    private final void assertNotReleased() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
    }

    public static void sessionDestroyed(HttpSessionEvent hse) {
        List creationalList;
        HttpSession session = hse.getSession();
        ViewScopedCDIContext.clearViewScopedBeans();
        List beanMapList = (List)session.getAttribute(PER_SESSION_BEAN_MAP_LIST);
        if (null != beanMapList) {
            for (String cur : beanMapList) {
                Map beanMap = (Map)session.getAttribute(cur);
                beanMap.clear();
                session.removeAttribute(cur);
            }
            session.removeAttribute(PER_SESSION_BEAN_MAP_LIST);
            beanMapList.clear();
        }
        if (null != (creationalList = (List)session.getAttribute(PER_SESSION_CREATIONAL_LIST))) {
            for (String cur : creationalList) {
                Map beanMap = (Map)session.getAttribute(cur);
                beanMap.clear();
                session.removeAttribute(cur);
            }
            session.removeAttribute(PER_SESSION_CREATIONAL_LIST);
            creationalList.clear();
        }
    }

    public static void clearViewScopedBeans() {
        Map<Contextual<?>, Object> viewScopedBeanMap = ViewScopedCDIContext.getViewScopedBeanMapForCurrentView(false);
        if (null == viewScopedBeanMap) {
            return;
        }
        Map<Contextual<?>, CreationalContext<?>> creationalMap = ViewScopedCDIContext.getViewScopedCreationalMapForCurrentView(false);
        if (null == creationalMap) {
            return;
        }
        ArrayList viewScopedBeansToRemove = new ArrayList();
        for (Map.Entry<Contextual<?>, Object> entry : viewScopedBeanMap.entrySet()) {
            Contextual<?> owner = entry.getKey();
            Object bean = entry.getValue();
            CreationalContext<?> creational = creationalMap.get(owner);
            owner.destroy(bean, creational);
            viewScopedBeansToRemove.add(owner);
        }
        for (Contextual contextual : viewScopedBeansToRemove) {
            viewScopedBeanMap.remove(contextual);
            creationalMap.remove(contextual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creational) {
        this.assertNotReleased();
        Object result = this.get(contextual);
        if (null == result) {
            Map<Contextual<?>, Object> viewScopedBeanMap = ViewScopedCDIContext.getViewScopedBeanMapForCurrentView();
            Map<Contextual<?>, CreationalContext<?>> creationalMap = ViewScopedCDIContext.getViewScopedCreationalMapForCurrentView();
            Map<Contextual<?>, Object> map = viewScopedBeanMap;
            synchronized (map) {
                result = viewScopedBeanMap.get(contextual);
                if (null == result && null != (result = contextual.create(creational))) {
                    viewScopedBeanMap.put(contextual, result);
                    creationalMap.put(contextual, creational);
                }
            }
        }
        return result;
    }

    public <T> T get(Contextual<T> contextual) {
        this.assertNotReleased();
        return (T)ViewScopedCDIContext.getViewScopedBeanMapForCurrentView().get(contextual);
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        UIViewRoot viewRoot;
        boolean result = false;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != context && null != (viewRoot = context.getViewRoot())) {
            result = true;
        }
        return result;
    }

    void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
    }
}

