/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.el.MethodExpression;
import javax.faces.application.NavigationCase;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowNode;
import javax.faces.flow.MethodCallNode;
import javax.faces.flow.Parameter;
import javax.faces.flow.SwitchNode;
import javax.faces.flow.ViewNode;
import javax.faces.lifecycle.ClientWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowImpl
extends Flow {
    private String id;
    private String startNodeId;
    private List<ViewNode> views;
    private List<MethodCallNode> methodCalls;
    private ConcurrentHashMap<String, Parameter> inboundParameters = new ConcurrentHashMap();
    private ConcurrentHashMap<String, NavigationCase> returns = new ConcurrentHashMap();
    private ConcurrentHashMap<String, SwitchNode> switches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FlowCallNode> facesFlowCalls = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FlowCallNode> facesFlowCallsByTargetFlowId = new ConcurrentHashMap();
    private MethodExpression initializer;
    private MethodExpression finalizer;
    private boolean hasBeenInitialized = false;

    public FlowImpl() {
        this.views = new CopyOnWriteArrayList<ViewNode>();
        this.methodCalls = new CopyOnWriteArrayList<MethodCallNode>();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Flow other = (Flow)obj;
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        if (this.startNodeId == null ? other.getStartNodeId() != null : !this.startNodeId.equals(other.getStartNodeId())) {
            return false;
        }
        if (!(this.views == other.getViews() || this.views != null && ((Object)this.views).equals(other.getViews()))) {
            return false;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != context) {
            if (!(this.returns == other.getReturns() || this.returns != null && this.returns.equals(other.getReturns()))) {
                return false;
            }
            if (!(this.initializer == other.getInitializer() || this.initializer != null && this.initializer.equals((Object)other.getInitializer()))) {
                return false;
            }
            if (!(this.finalizer == other.getFinalizer() || this.finalizer != null && this.finalizer.equals((Object)other.getFinalizer()))) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 59 * hash + (this.startNodeId != null ? this.startNodeId.hashCode() : 0);
        hash = 59 * hash + (this.views != null ? ((Object)this.views).hashCode() : 0);
        hash = 59 * hash + (this.returns != null ? this.returns.hashCode() : 0);
        hash = 59 * hash + (this.initializer != null ? this.initializer.hashCode() : 0);
        hash = 59 * hash + (this.finalizer != null ? this.finalizer.hashCode() : 0);
        return hash;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStartNodeId() {
        return this.startNodeId;
    }

    public void setStartNodeId(String defaultNodeId) {
        this.startNodeId = defaultNodeId;
    }

    public MethodExpression getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(MethodExpression finalizer) {
        this.finalizer = finalizer;
    }

    public MethodExpression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(MethodExpression initializer) {
        this.initializer = initializer;
    }

    public Map<String, Parameter> getInboundParameters() {
        return this.inboundParameters;
    }

    public List<ViewNode> getViews() {
        return this.views;
    }

    public List<NavigationCase> getNavigationCases() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, NavigationCase> getReturns() {
        return this.returns;
    }

    public Map<String, SwitchNode> getSwitches() {
        return this.switches;
    }

    public Map<String, FlowCallNode> getFlowCalls() {
        return this.facesFlowCalls;
    }

    public FlowCallNode getFlowCall(Flow targetFlow) {
        String targetFlowId = targetFlow.getId();
        FlowCallNode result = this.facesFlowCallsByTargetFlowId.get(targetFlowId);
        return result;
    }

    public List<MethodCallNode> getMethodCalls() {
        return this.methodCalls;
    }

    public FlowNode getNode(String nodeId) {
        List<ViewNode> myViews = this.getViews();
        FlowNode result = null;
        if (null != myViews) {
            for (ViewNode cur : myViews) {
                if (!nodeId.equals(cur.getId())) continue;
                result = cur;
                break;
            }
        }
        if (null == result) {
            Map<String, SwitchNode> mySwitches = this.getSwitches();
            result = (FlowNode)mySwitches.get(nodeId);
        }
        if (null == result) {
            List<MethodCallNode> myMethods = this.getMethodCalls();
            for (MethodCallNode cur : myMethods) {
                if (!nodeId.equals(cur.getId())) continue;
                result = cur;
                break;
            }
        }
        if (null == result) {
            Map<String, FlowCallNode> myCalls = this.getFlowCalls();
            result = (FlowNode)myCalls.get(nodeId);
        }
        return result;
    }

    public String getClientWindowFlowId(ClientWindow curWindow) {
        String result = null;
        result = curWindow.getId() + "_" + this.getId();
        return result;
    }

    public void init(FacesContext context) {
        if (this.hasBeenInitialized) {
            return;
        }
        this.hasBeenInitialized = true;
        FlowCallNode curNode = null;
        String curTargetFlowId = null;
        for (Map.Entry<String, FlowCallNode> cur : this.facesFlowCalls.entrySet()) {
            curNode = cur.getValue();
            curTargetFlowId = curNode.getCalledFlowId(context);
            this.facesFlowCallsByTargetFlowId.put(curTargetFlowId, curNode);
        }
    }
}

