/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.flow.FlowCDIContext;
import com.sun.faces.util.Util;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowHandlerImpl
extends FlowHandler {
    private boolean flowFeatureIsEnabled;
    private Map<String, Map<String, Flow>> flows;
    private Map<String, List<Flow>> flowsByFlowId;

    public FlowHandlerImpl() {
        WebConfiguration config = WebConfiguration.getInstance();
        this.flowFeatureIsEnabled = config.isHasFlows();
        this.flows = new ConcurrentHashMap<String, Map<String, Flow>>();
        this.flowsByFlowId = new ConcurrentHashMap<String, List<Flow>>();
    }

    public Map<Object, Object> getCurrentFlowScope() {
        return FlowCDIContext.getCurrentFlowScope();
    }

    public Flow getFlow(FacesContext context, String definingDocumentId, String id) {
        Util.notNull("context", context);
        Util.notNull("definingDocumentId", definingDocumentId);
        Util.notNull("id", id);
        Flow result = null;
        Map<String, Flow> mapsForDefiningDocument = this.flows.get(definingDocumentId);
        if (null != mapsForDefiningDocument) {
            result = mapsForDefiningDocument.get(id);
        }
        return result;
    }

    public void addFlow(FacesContext context, Flow toAdd) {
        Flow oldFlow;
        Util.notNull("context", context);
        Util.notNull("toAdd", toAdd);
        String id = toAdd.getId();
        if (null == id || 0 == id.length()) {
            throw new IllegalArgumentException("The id of the flow may not be null or zero-length.");
        }
        String definingDocumentId = toAdd.getDefiningDocumentId();
        if (null == definingDocumentId) {
            throw new IllegalArgumentException("The definingDocumentId of the flow may not be null.");
        }
        Map<String, Flow> mapsForDefiningDocument = this.flows.get(definingDocumentId);
        if (null == mapsForDefiningDocument) {
            mapsForDefiningDocument = new ConcurrentHashMap<String, Flow>();
            this.flows.put(toAdd.getDefiningDocumentId(), mapsForDefiningDocument);
        }
        if (null != (oldFlow = mapsForDefiningDocument.put(id, toAdd))) {
            String message = MessageFormat.format("Flow with id \"{0}\" and definingDocumentId \"{1}\" already exists.", id, definingDocumentId);
            throw new IllegalStateException(message);
        }
        List<Flow> flowsWithId = this.flowsByFlowId.get(id);
        if (null == flowsWithId) {
            flowsWithId = new CopyOnWriteArrayList<Flow>();
            this.flowsByFlowId.put(id, flowsWithId);
        }
        flowsWithId.add(toAdd);
        NavigationHandler navigationHandler = context.getApplication().getNavigationHandler();
        if (navigationHandler instanceof ConfigurableNavigationHandler) {
            ((ConfigurableNavigationHandler)navigationHandler).inspectFlow(context, toAdd);
        }
    }

    public boolean isActive(FacesContext context, String definingDocumentId, String id) {
        Util.notNull("context", context);
        Util.notNull("definingDocumentId", definingDocumentId);
        Util.notNull("id", id);
        boolean result = false;
        Deque<Flow> flowStack = this.getFlowStack(context);
        for (Flow cur : flowStack) {
            if (!id.equals(cur.getId()) || !definingDocumentId.equals(cur.getDefiningDocumentId())) continue;
            result = true;
            break;
        }
        return result;
    }

    public Flow getCurrentFlow(FacesContext context) {
        Util.notNull("context", context);
        if (!this.flowFeatureIsEnabled) {
            return null;
        }
        return this.getFlowStack(context).peek();
    }

    public void transition(FacesContext context, Flow sourceFlow, Flow targetFlow, FlowCallNode outboundCallNode) {
        Util.notNull("context", context);
        if (!this.flowFeatureIsEnabled) {
            return;
        }
        if (!this.flowsEqual(sourceFlow, targetFlow)) {
            HashMap<String, Object> evaluatedParams = null;
            if (null != outboundCallNode) {
                Map outboundParameters = outboundCallNode.getOutboundParameters();
                Map inboundParameters = targetFlow.getInboundParameters();
                if (null != outboundParameters && !outboundParameters.isEmpty() && null != inboundParameters && !inboundParameters.isEmpty()) {
                    ELContext elContext = context.getELContext();
                    for (Map.Entry curOutbound : outboundParameters.entrySet()) {
                        String curName = (String)curOutbound.getKey();
                        if (!inboundParameters.containsKey(curName)) continue;
                        if (null == evaluatedParams) {
                            evaluatedParams = new HashMap<String, Object>();
                        }
                        evaluatedParams.put(curName, ((Parameter)curOutbound.getValue()).getValue().getValue(elContext));
                    }
                }
            }
            this.performPops(context, sourceFlow, targetFlow);
            if (null != targetFlow) {
                this.pushFlow(context, targetFlow);
            }
            if (null != evaluatedParams) {
                Map inboundParameters = targetFlow.getInboundParameters();
                ELContext elContext = context.getELContext();
                for (Map.Entry curOutbound : evaluatedParams.entrySet()) {
                    String curName = (String)curOutbound.getKey();
                    assert (inboundParameters.containsKey(curName));
                    ValueExpression toSet = ((Parameter)inboundParameters.get(curName)).getValue();
                    toSet.setValue(elContext, curOutbound.getValue());
                }
            }
        }
    }

    private void performPops(FacesContext context, Flow sourceFlow, Flow targetFlow) {
        if (null == sourceFlow) {
            assert (null == this.peekFlow(context));
            return;
        }
        if (null == targetFlow) {
            this.popFlow(context);
            return;
        }
        if (null == sourceFlow.getFlowCall(targetFlow)) {
            this.popFlow(context);
        }
    }

    private boolean flowsEqual(Flow flow1, Flow flow2) {
        boolean result = false;
        result = flow1 == flow2 ? true : (null == flow1 || null == flow2 ? false : flow1.equals(flow2));
        return result;
    }

    private void pushFlow(FacesContext context, Flow toPush) {
        Deque<Flow> flowStack = this.getFlowStack(context);
        flowStack.push(toPush);
        FlowCDIContext.flowEntered();
        MethodExpression me = toPush.getInitializer();
        if (null != me) {
            me.invoke(context.getELContext(), null);
        }
    }

    private Flow peekFlow(FacesContext context) {
        Deque<Flow> flowStack = this.getFlowStack(context);
        return flowStack.peek();
    }

    private Flow popFlow(FacesContext context) {
        Deque<Flow> flowStack = this.getFlowStack(context);
        Flow currentFlow = this.peekFlow(context);
        if (null != currentFlow) {
            this.callFinalizer(context, currentFlow);
        }
        return flowStack.pollFirst();
    }

    private void callFinalizer(FacesContext context, Flow currentFlow) {
        MethodExpression me = currentFlow.getFinalizer();
        if (null != me) {
            me.invoke(context.getELContext(), null);
        }
        FlowCDIContext.flowExited();
    }

    private Deque<Flow> getFlowStack(FacesContext context) {
        ArrayDeque result = null;
        ExternalContext extContext = context.getExternalContext();
        String sessionKey = extContext.getClientWindow().getId() + "_flowStack";
        Map sessionMap = extContext.getSessionMap();
        result = (ArrayDeque)sessionMap.get(sessionKey);
        if (null == result) {
            result = new ArrayDeque();
            sessionMap.put(sessionKey, result);
        }
        return result;
    }
}

