/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.FaceletLibraryInfo;
import com.sun.faces.application.resource.FaceletResourceInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.Resource;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletWebappResourceHelper
extends ResourceHelper {
    private final String webAppContractsDirectory;
    private static final String META_INF_CONTRACTS_DIR = WebConfiguration.META_INF_CONTRACTS_DIR;

    public FaceletWebappResourceHelper() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.webAppContractsDirectory = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory);
    }

    public boolean equals(Object obj) {
        return obj instanceof FaceletWebappResourceHelper;
    }

    public int hashCode() {
        return 3;
    }

    @Override
    public LibraryInfo findLibrary(String libraryName, String localePrefix, FacesContext ctx) {
        FaceletLibraryInfo result = null;
        try {
            URL url;
            String path = libraryName;
            if ('/' != path.charAt(0)) {
                path = "/" + path;
            }
            if (null != (url = Resource.getResourceUrl(ctx, path)) && -1 == url.getPath().indexOf("/META-INF/")) {
                result = new FaceletLibraryInfo(libraryName, null, localePrefix, this, url);
            }
        }
        catch (MalformedURLException ex) {
            throw new FacesException((Throwable)ex);
        }
        return result;
    }

    @Override
    public ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, FacesContext ctx) {
        FaceletResourceInfo result = null;
        try {
            String path = resourceName;
            if (null != library) {
                path = library.getPath() + "/" + resourceName;
            } else if ('/' != path.charAt(0)) {
                path = "/" + path;
            }
            List contracts = ctx.getResourceLibraryContracts();
            ContractInfo[] outContract = new ContractInfo[]{null};
            boolean doNotCache = false;
            URL url = null;
            if (null != contracts) {
                url = this.findResourceInfoConsideringContracts(ctx, resourceName, outContract, contracts);
            }
            if (null == url) {
                url = Resource.getResourceUrl(ctx, path);
            }
            if (null == url) {
                ClassLoader cl = Util.getCurrentLoader(this);
                Enumeration<URL> matches = cl.getResources("META-INF/flows" + resourceName);
                try {
                    url = matches.nextElement();
                }
                catch (NoSuchElementException nsee) {
                    url = null;
                }
                if (null != url && matches.hasMoreElements()) {
                    boolean keepGoing = true;
                    FacesContext context = FacesContext.getCurrentInstance();
                    Application application = context.getApplication();
                    FlowHandler fh = application.getFlowHandler();
                    Flow currentFlow = fh.getCurrentFlow(context);
                    do {
                        if (null != currentFlow && 0 < currentFlow.getDefiningDocumentId().length()) {
                            String definingDocumentId = currentFlow.getDefiningDocumentId();
                            ExternalContext extContext = context.getExternalContext();
                            ApplicationAssociate associate = ApplicationAssociate.getInstance(extContext);
                            if (associate.urlIsRelatedToDefiningDocumentInJar(url, definingDocumentId)) {
                                keepGoing = false;
                                doNotCache = true;
                                continue;
                            }
                            if (matches.hasMoreElements()) {
                                url = matches.nextElement();
                                continue;
                            }
                            keepGoing = false;
                            continue;
                        }
                        keepGoing = false;
                    } while (keepGoing);
                }
            }
            if (null != url) {
                result = new FaceletResourceInfo(outContract[0], resourceName, null, this, url);
                if (doNotCache) {
                    result.setDoNotCache(doNotCache);
                }
            }
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
        return result;
    }

    private URL findResourceInfoConsideringContracts(FacesContext ctx, String baseResourceName, ContractInfo[] outContract, List<String> contracts) throws MalformedURLException {
        URL url = null;
        for (String curContract : contracts) {
            String resourceName = baseResourceName.startsWith("/") ? this.webAppContractsDirectory + "/" + curContract + baseResourceName : this.webAppContractsDirectory + "/" + curContract + "/" + baseResourceName;
            url = Resource.getResourceUrl(ctx, resourceName);
            if (null != url) {
                outContract[0] = new ContractInfo(curContract);
                break;
            }
            resourceName = baseResourceName.startsWith("/") ? META_INF_CONTRACTS_DIR + "/" + curContract + baseResourceName : META_INF_CONTRACTS_DIR + "/" + curContract + "/" + baseResourceName;
            url = Util.getCurrentLoader(this).getResource(resourceName);
            if (null == url) continue;
            outContract[0] = new ContractInfo(curContract);
            break;
        }
        return url;
    }

    @Override
    public String getBaseResourcePath() {
        return "";
    }

    @Override
    public String getBaseContractsPath() {
        return this.webAppContractsDirectory;
    }

    @Override
    protected InputStream getNonCompressedInputStream(ResourceInfo info, FacesContext ctx) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URL getURL(ResourceInfo resource, FacesContext ctx) {
        return ((FaceletResourceInfo)resource).getUrl();
    }
}

