/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClasspathResourceHelper;
import com.sun.faces.application.resource.FaceletWebappResourceHelper;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceCache;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.application.resource.WebappResourceHelper;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final Pattern CONFIG_MIMETYPE_PATTERN = Pattern.compile("[a-z-]*/[a-z0-9.\\*-]*");
    private ResourceHelper faceletResourceHelper = new FaceletWebappResourceHelper();
    private ResourceHelper webappHelper = new WebappResourceHelper();
    private ClasspathResourceHelper classpathHelper = new ClasspathResourceHelper();
    private ResourceCache cache;
    private List<Pattern> compressableTypes;
    private ReentrantLock lock = new ReentrantLock();

    public ResourceManager(ResourceCache cache) {
        this.cache = cache;
        HashMap<String, Object> throwAwayMap = new HashMap<String, Object>();
        this.initCompressableTypes(throwAwayMap);
    }

    public ResourceManager(Map<String, Object> appMap, ResourceCache cache) {
        this.cache = cache;
        this.initCompressableTypes(appMap);
    }

    public ResourceInfo findResource(String libraryName, String resourceName, String contentType, FacesContext ctx) {
        return this.findResource(libraryName, resourceName, contentType, false, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResourceInfo findResource(String libraryName, String resourceName, String contentType, boolean isViewResource, FacesContext ctx) {
        List<String> contracts;
        String localePrefix = this.getLocalePrefix(ctx);
        ResourceInfo info = this.getFromCache(resourceName, libraryName, localePrefix, contracts = this.getResourceLibraryContracts(ctx));
        if (info != null) return info;
        boolean compressable = this.isCompressable(contentType, ctx);
        if (compressable) {
            this.lock.lock();
            try {
                info = this.getFromCache(resourceName, libraryName, localePrefix, contracts);
                if (info != null || (info = this.doLookup(libraryName, resourceName, localePrefix, compressable, isViewResource, contracts, ctx)) == null) return info;
                this.addToCache(info, contracts);
                return info;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            info = this.doLookup(libraryName, resourceName, localePrefix, compressable, isViewResource, contracts, ctx);
            if (null == info && null != contracts) {
                for (String cur : contracts) {
                    if (!cur.equals(libraryName)) continue;
                    libraryName = null;
                    break;
                }
                info = this.doLookup(libraryName, resourceName, localePrefix, compressable, isViewResource, contracts, ctx);
            }
            if (info == null || info.isDoNotCache()) return info;
            this.addToCache(info, contracts);
        }
        return info;
    }

    private ResourceInfo doLookup(String libraryName, String resourceName, String localePrefix, boolean compressable, boolean isViewResource, List<String> contracts, FacesContext ctx) {
        LibraryInfo library = null;
        for (String contract : contracts) {
            ResourceInfo info = this.getResourceInfo(libraryName, resourceName, localePrefix, contract, compressable, isViewResource, ctx, library);
            if (info == null) continue;
            return info;
        }
        return this.getResourceInfo(libraryName, resourceName, localePrefix, null, compressable, isViewResource, ctx, library);
    }

    private ResourceInfo getResourceInfo(String libraryName, String resourceName, String localePrefix, String contract, boolean compressable, boolean isViewResource, FacesContext ctx, LibraryInfo library) {
        String resName;
        if (libraryName != null && !ResourceManager.nameContainsForbiddenSequence(libraryName)) {
            library = this.findLibrary(libraryName, localePrefix, contract, ctx);
            if (library == null && localePrefix != null) {
                library = this.findLibrary(libraryName, null, contract, ctx);
            }
            if (library == null) {
                library = this.findLibraryOnClasspathWithZipDirectoryEntryScan(libraryName, localePrefix, contract, ctx, false);
                if (library == null && localePrefix != null) {
                    library = this.findLibraryOnClasspathWithZipDirectoryEntryScan(libraryName, null, contract, ctx, false);
                }
                if (null == library) {
                    return null;
                }
            }
        } else if (ResourceManager.nameContainsForbiddenSequence(libraryName)) {
            return null;
        }
        if (ResourceManager.nameContainsForbiddenSequence(resName = this.trimLeadingSlash(resourceName))) {
            return null;
        }
        ResourceInfo info = this.findResource(library, resourceName, localePrefix, compressable, isViewResource, ctx);
        if (info == null && localePrefix != null) {
            info = this.findResource(library, resourceName, null, compressable, isViewResource, ctx);
        }
        if (info == null && library != null && library.getHelper() instanceof WebappResourceHelper) {
            LibraryInfo altLibrary = this.classpathHelper.findLibrary(libraryName, localePrefix, contract, ctx);
            if (altLibrary != null) {
                VersionInfo originalVersion = library.getVersion();
                VersionInfo altVersion = altLibrary.getVersion();
                if (originalVersion == null && altVersion == null) {
                    library = altLibrary;
                } else if (originalVersion == null && altVersion != null) {
                    library = null;
                } else if (originalVersion != null && altVersion == null) {
                    library = null;
                } else if (originalVersion.compareTo(altVersion) == 0) {
                    library = altLibrary;
                }
            }
            if (library != null && (info = this.findResource(library, resourceName, localePrefix, compressable, isViewResource, ctx)) == null && localePrefix != null) {
                info = this.findResource(library, resourceName, null, compressable, isViewResource, ctx);
            }
        }
        return info;
    }

    private String trimLeadingSlash(String s) {
        if (s.charAt(0) == '/') {
            return s.substring(1);
        }
        return s;
    }

    private static boolean nameContainsForbiddenSequence(String name) {
        boolean result = false;
        if (name != null) {
            result = (name = name.toLowerCase()).startsWith("./..") || name.startsWith("..") || name.contains("../") || name.contains("..\\") || name.startsWith("/") || name.startsWith("\\") || name.contains("..%2f") || name.contains("..%5c") || name.startsWith("%2f") || name.startsWith("%5c") || name.contains("..\\u002f") || name.contains("..\\u005c") || name.startsWith("\\u002f") || name.startsWith("\\u005c");
        }
        return result;
    }

    private ResourceInfo getFromCache(String name, String library, String localePrefix, List<String> contracts) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(name, library, localePrefix, contracts);
    }

    private void addToCache(ResourceInfo info, List<String> contracts) {
        if (this.cache == null) {
            return;
        }
        this.cache.add(info, contracts);
    }

    LibraryInfo findLibrary(String libraryName, String localePrefix, String contract, FacesContext ctx) {
        LibraryInfo library = this.webappHelper.findLibrary(libraryName, localePrefix, contract, ctx);
        if (library == null) {
            library = this.classpathHelper.findLibrary(libraryName, localePrefix, contract, ctx);
        }
        if (library == null) {
            library = this.faceletResourceHelper.findLibrary(libraryName, localePrefix, contract, ctx);
        }
        return library;
    }

    LibraryInfo findLibraryOnClasspathWithZipDirectoryEntryScan(String libraryName, String localePrefix, String contract, FacesContext ctx, boolean forceScan) {
        return this.classpathHelper.findLibraryWithZipDirectoryEntryScan(libraryName, localePrefix, contract, ctx, forceScan);
    }

    private ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, boolean skipToFaceletResourceHelper, FacesContext ctx) {
        if (library != null) {
            return library.getHelper().findResource(library, resourceName, localePrefix, compressable, ctx);
        }
        ResourceInfo resource = null;
        if (!skipToFaceletResourceHelper) {
            resource = this.webappHelper.findResource(null, resourceName, localePrefix, compressable, ctx);
        }
        if (resource == null && !skipToFaceletResourceHelper) {
            resource = this.classpathHelper.findResource(null, resourceName, localePrefix, compressable, ctx);
        }
        if (resource == null) {
            resource = this.faceletResourceHelper.findResource(library, resourceName, localePrefix, compressable, ctx);
        }
        return resource;
    }

    ResourceInfo findResource(String resourceId) {
        String libraryName = null;
        String resourceName = null;
        int end = 0;
        int start = 0;
        end = resourceId.lastIndexOf("/");
        if (-1 != end) {
            resourceName = resourceId.substring(end + 1);
            start = resourceId.lastIndexOf("/", end - 1);
            libraryName = -1 != start ? resourceId.substring(start + 1, end) : resourceId.substring(0, end);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        LibraryInfo info = this.findLibrary(libraryName, null, null, context);
        ResourceInfo resourceInfo = this.findResource(info, resourceName, libraryName, true, false, context);
        return resourceInfo;
    }

    private String getLocalePrefix(FacesContext context) {
        String localePrefix;
        block3: {
            localePrefix = null;
            String appBundleName = context.getApplication().getMessageBundle();
            if (null != appBundleName) {
                Locale locale = null;
                locale = context.getViewRoot() != null ? context.getViewRoot().getLocale() : context.getApplication().getViewHandler().calculateLocale(context);
                try {
                    ResourceBundle appBundle = ResourceBundle.getBundle(appBundleName, locale, Util.getCurrentLoader(ResourceManager.class));
                    localePrefix = appBundle.getString("javax.faces.resource.localePrefix");
                }
                catch (MissingResourceException mre) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block3;
                    LOGGER.log(Level.FINEST, "Ignoring missing resource", mre);
                }
            }
        }
        return localePrefix;
    }

    private List<String> getResourceLibraryContracts(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null) {
            String param;
            if (context.getApplication().getResourceHandler().isResourceRequest(context) && (param = (String)context.getExternalContext().getRequestParameterMap().get("con")) != null && param.trim().length() > 0) {
                return Arrays.asList(param);
            }
            return Collections.emptyList();
        }
        return context.getResourceLibraryContracts();
    }

    private boolean isCompressable(String contentType, FacesContext ctx) {
        if (contentType == null || ctx.isProjectStage(ProjectStage.Development)) {
            return false;
        }
        if (this.compressableTypes != null && !this.compressableTypes.isEmpty()) {
            for (Pattern p : this.compressableTypes) {
                boolean matches = p.matcher(contentType).matches();
                if (!matches) continue;
                return true;
            }
        }
        return false;
    }

    private void initCompressableTypes(Map<String, Object> appMap) {
        String[] values;
        WebConfiguration config = WebConfiguration.getInstance();
        String value = config.getOptionValue(WebConfiguration.WebContextInitParameter.CompressableMimeTypes);
        if (value != null && value.length() > 0 && (values = Util.split(appMap, value, ",")) != null) {
            for (String s : values) {
                String pattern = s.trim();
                if (!this.isPatternValid(pattern)) continue;
                if (pattern.endsWith("/*")) {
                    pattern = pattern.substring(0, pattern.indexOf("/*"));
                    pattern = pattern + "/[a-z0-9.-]*";
                }
                if (this.compressableTypes == null) {
                    this.compressableTypes = new ArrayList<Pattern>(values.length);
                }
                try {
                    this.compressableTypes.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException pse) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.resource.mime.type.configration.invalid", new Object[]{pattern, pse.getPattern()});
                }
            }
        }
    }

    private boolean isPatternValid(String input) {
        return CONFIG_MIMETYPE_PATTERN.matcher(input).matches();
    }
}

