/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES;
    private Map<ValidatorInfo, String> validators;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> clazz, Annotation annotation) {
        if (this.validators == null) {
            this.validators = new HashMap<ValidatorInfo, String>();
        }
        FacesValidator facesValidator = (FacesValidator)annotation;
        String string = ((FacesValidator)annotation).value();
        if (null == string || 0 == string.length()) {
            string = clazz.getSimpleName();
            string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        ValidatorInfo validatorInfo = new ValidatorInfo(string, facesValidator.isDefault());
        this.validators.put(validatorInfo, clazz.getName());
    }

    @Override
    public void push(FacesContext facesContext) {
        if (this.validators != null) {
            Application application = facesContext.getApplication();
            for (Map.Entry<ValidatorInfo, String> entry : this.validators.entrySet()) {
                application.addValidator(entry.getKey().validatorId, entry.getValue());
                if (!entry.getKey().isDefault) continue;
                application.addDefaultValidatorId(entry.getKey().validatorId);
            }
        }
    }

    static {
        ArrayList<Class<FacesValidator>> arrayList = new ArrayList<Class<FacesValidator>>(1);
        arrayList.add(FacesValidator.class);
        HANDLES = Collections.unmodifiableCollection(arrayList);
    }

    private static class ValidatorInfo {
        final String validatorId;
        final boolean isDefault;

        ValidatorInfo(String string, boolean bl) {
            this.validatorId = string;
            this.isDefault = bl;
        }
    }
}

