/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClasspathResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MultiKeyConcurrentHashMap;
import com.sun.faces.util.Util;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCache {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private MultiKeyConcurrentHashMap<Object, ResourceInfoCheckPeriodProxy> resourceCache;
    private long checkPeriod;

    public ResourceCache() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        assert (webConfiguration != null);
        ServletContext servletContext = webConfiguration.getServletContext();
        long l = this.getCheckPeriod(webConfiguration);
        this.checkPeriod = l != -1L ? l * 1000L * 60L : -1L;
        this.resourceCache = new MultiKeyConcurrentHashMap(30);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "ResourceCache constructed for {0}.  Check period is {1} minutes.", new Object[]{ResourceCache.getServletContextIdentifier(servletContext), this.checkPeriod});
        }
    }

    public ResourceInfo add(ResourceInfo resourceInfo, List<String> list) {
        ResourceInfoCheckPeriodProxy resourceInfoCheckPeriodProxy;
        Util.notNull("info", resourceInfo);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Caching ResourceInfo: {0}", resourceInfo.toString());
        }
        return (resourceInfoCheckPeriodProxy = this.resourceCache.putIfAbsent(resourceInfo.name, resourceInfo.libraryName, resourceInfo.localePrefix, list, new ResourceInfoCheckPeriodProxy(resourceInfo, this.checkPeriod))) != null ? resourceInfoCheckPeriodProxy.getResourceInfo() : null;
    }

    public ResourceInfo get(String string, String string2, String string3, List<String> list) {
        Util.notNull("name", string);
        ResourceInfoCheckPeriodProxy resourceInfoCheckPeriodProxy = this.resourceCache.get(string, string2, string3, list);
        if (resourceInfoCheckPeriodProxy != null && resourceInfoCheckPeriodProxy.needsRefreshed()) {
            this.resourceCache.remove(string, string2, string3, list);
            return null;
        }
        return resourceInfoCheckPeriodProxy != null ? resourceInfoCheckPeriodProxy.getResourceInfo() : null;
    }

    public void clear() {
        this.resourceCache.clear();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cache Cleared");
        }
    }

    private Long getCheckPeriod(WebConfiguration webConfiguration) {
        String string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceUpdateCheckPeriod);
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Long.parseLong(WebConfiguration.WebContextInitParameter.ResourceUpdateCheckPeriod.getDefaultValue());
        }
    }

    private static String getServletContextIdentifier(ServletContext servletContext) {
        if (servletContext.getMajorVersion() == 2 && servletContext.getMinorVersion() < 5) {
            return servletContext.getServletContextName();
        }
        return servletContext.getContextPath();
    }

    private static final class ResourceInfoCheckPeriodProxy {
        private ResourceInfo resourceInfo;
        private Long checkTime;

        public ResourceInfoCheckPeriodProxy(ResourceInfo resourceInfo, long l) {
            this.resourceInfo = resourceInfo;
            if (l != -1L && !(resourceInfo.getHelper() instanceof ClasspathResourceHelper)) {
                this.checkTime = System.currentTimeMillis() + l;
            }
        }

        private boolean needsRefreshed() {
            return this.checkTime != null && this.checkTime < System.currentTimeMillis();
        }

        private ResourceInfo getResourceInfo() {
            return this.resourceInfo;
        }
    }
}

