/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.context.StateContext;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletPartialStateManagementStrategy
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";

    public FaceletPartialStateManagementStrategy() {
        this(FacesContext.getCurrentInstance());
    }

    public FaceletPartialStateManagementStrategy(FacesContext facesContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIComponent locateComponentByClientId(FacesContext facesContext, UIComponent uIComponent, final String string) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletPartialStateManagementStrategy.locateComponentByClientId", string);
        }
        final ArrayList arrayList = new ArrayList();
        UIComponent uIComponent2 = null;
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
            EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
            uIComponent.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    VisitResult visitResult = VisitResult.ACCEPT;
                    if (uIComponent.getClientId(visitContext.getFacesContext()).equals(string)) {
                        arrayList.add(uIComponent);
                        visitResult = VisitResult.COMPLETE;
                    } else if (uIComponent instanceof UIForm) {
                        UIForm uIForm = (UIForm)uIComponent;
                        if (uIForm.isPrependId() && !string.startsWith(uIForm.getClientId(visitContext.getFacesContext()))) {
                            visitResult = VisitResult.REJECT;
                        }
                    } else if (uIComponent instanceof NamingContainer && !string.startsWith(uIComponent.getClientId(visitContext.getFacesContext()))) {
                        visitResult = VisitResult.REJECT;
                    }
                    return visitResult;
                }
            });
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        if (!arrayList.isEmpty()) {
            uIComponent2 = (UIComponent)arrayList.get(0);
        }
        return uIComponent2;
    }

    private void pruneAndReAddToDynamicActions(List<ComponentStruct> list, ComponentStruct componentStruct) {
        int n;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.pruneAndReAddToDynamicActions");
        }
        if ((n = list.indexOf(componentStruct)) == -1) {
            list.add(componentStruct);
        } else {
            int n2 = list.lastIndexOf(componentStruct);
            if (n2 == -1 || n2 == n) {
                list.add(componentStruct);
            } else {
                if ("ADD".equals(componentStruct.action)) {
                    list.remove(n2);
                    list.remove(n);
                    list.add(componentStruct);
                }
                if ("REMOVE".equals(componentStruct.action)) {
                    list.remove(n2);
                }
            }
        }
    }

    private void restoreDynamicActions(FacesContext facesContext, StateContext stateContext, Map<String, Object> map) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.restoreDynamicActions");
        }
        List list = (List)map.get("com.sun.faces.DynamicActions");
        List<ComponentStruct> list2 = stateContext.getDynamicActions();
        if (list != null && !list.isEmpty()) {
            for (Object e : list) {
                ComponentStruct componentStruct = new ComponentStruct();
                componentStruct.restoreState(facesContext, e);
                if ("ADD".equals(componentStruct.action)) {
                    this.restoreDynamicAdd(facesContext, map, componentStruct);
                }
                if ("REMOVE".equals(componentStruct.action)) {
                    this.restoreDynamicRemove(facesContext, componentStruct);
                }
                this.pruneAndReAddToDynamicActions(list2, componentStruct);
            }
        }
    }

    private void restoreDynamicAdd(FacesContext facesContext, Map<String, Object> map, ComponentStruct componentStruct) {
        UIComponent uIComponent;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.restoreDynamicAdd");
        }
        if ((uIComponent = this.locateComponentByClientId(facesContext, (UIComponent)facesContext.getViewRoot(), componentStruct.parentClientId)) != null) {
            Object object;
            UIComponent uIComponent2 = this.locateComponentByClientId(facesContext, uIComponent, componentStruct.clientId);
            if (uIComponent2 != null) {
                if (componentStruct.facetName == null) {
                    uIComponent.getChildren().remove(uIComponent2);
                } else {
                    uIComponent.getFacets().remove(componentStruct.facetName);
                }
            }
            if (uIComponent2 == null && (object = (StateHolderSaver)map.get(componentStruct.clientId)) != null) {
                uIComponent2 = (UIComponent)((StateHolderSaver)object).restore(facesContext);
            }
            object = StateContext.getStateContext(facesContext);
            if (uIComponent2 == null) {
                uIComponent2 = ((StateContext)object).getDynamicComponents().get(componentStruct.clientId);
            }
            if (uIComponent2 != null) {
                if (componentStruct.facetName != null) {
                    uIComponent.getFacets().put(componentStruct.facetName, uIComponent2);
                } else {
                    int n = -1;
                    if (uIComponent2.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                        n = (Integer)uIComponent2.getAttributes().get("com.sun.faces.DynamicComponent");
                    }
                    uIComponent2.setId(componentStruct.id);
                    if (n >= uIComponent.getChildCount() || n == -1) {
                        uIComponent.getChildren().add(uIComponent2);
                    } else {
                        uIComponent.getChildren().add(n, uIComponent2);
                    }
                    uIComponent2.getClientId();
                }
                uIComponent2.getAttributes().put("com.sun.faces.DynamicComponent", uIComponent2.getParent().getChildren().indexOf(uIComponent2));
                ((StateContext)object).getDynamicComponents().put(componentStruct.clientId, uIComponent2);
            }
        }
    }

    private void restoreDynamicRemove(FacesContext facesContext, ComponentStruct componentStruct) {
        UIComponent uIComponent;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.restoreDynamicRemove");
        }
        if ((uIComponent = this.locateComponentByClientId(facesContext, (UIComponent)facesContext.getViewRoot(), componentStruct.clientId)) != null) {
            StateContext stateContext = StateContext.getStateContext(facesContext);
            stateContext.getDynamicComponents().put(componentStruct.clientId, uIComponent);
            UIComponent uIComponent2 = uIComponent.getParent();
            uIComponent2.getChildren().remove(uIComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext facesContext, String string, String string2) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletPartialStateManagementStrategy.restoreView", new Object[]{string, string2});
        }
        ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string2);
        boolean bl = facesContext.isProcessingEvents();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        Object[] objectArray = (Object[])responseStateManager.getState(facesContext, string);
        if (objectArray == null) {
            return null;
        }
        final Map map = (Map)objectArray[1];
        final StateContext stateContext = StateContext.getStateContext(facesContext);
        if (map != null) {
            try {
                stateContext.setTrackViewModifications(false);
                facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
                EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION, VisitHint.EXECUTE_LIFECYCLE);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
                uIViewRoot.visitTree(visitContext, new VisitCallback(){

                    public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                        VisitResult visitResult = VisitResult.ACCEPT;
                        String string = uIComponent.getClientId(visitContext.getFacesContext());
                        Object v = map.get(string);
                        if (v != null && !stateContext.componentAddedDynamically(uIComponent)) {
                            boolean bl = true;
                            if (v instanceof StateHolderSaver) {
                                boolean bl2 = bl = !((StateHolderSaver)v).componentAddedDynamically();
                            }
                            if (bl) {
                                try {
                                    uIComponent.restoreState(visitContext.getFacesContext(), v);
                                }
                                catch (Exception exception) {
                                    String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.partial.statesaving.ERROR_RESTORING_STATE_FOR_COMPONENT", string, exception.toString());
                                    throw new FacesException(string2, (Throwable)exception);
                                }
                            }
                        }
                        return visitResult;
                    }
                });
                this.restoreDynamicActions(facesContext, stateContext, map);
            }
            finally {
                stateContext.setTrackViewModifications(true);
                facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
            }
        } else {
            uIViewRoot = null;
        }
        facesContext.setProcessingEvents(bl);
        return uIViewRoot;
    }

    private void saveDynamicActions(FacesContext facesContext, StateContext stateContext, Map<String, Object> map) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.saveDynamicActions");
        }
        List<ComponentStruct> list = stateContext.getDynamicActions();
        HashMap<String, UIComponent> hashMap = stateContext.getDynamicComponents();
        if (list != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (ComponentStruct componentStruct : list) {
                UIComponent uIComponent = hashMap.get(componentStruct.clientId);
                if (uIComponent == null && facesContext.isProjectStage(ProjectStage.Development)) {
                    LOGGER.log(Level.WARNING, "Unable to save dynamic action with clientId ''{0}'' because the UIComponent cannot be found", componentStruct.clientId);
                }
                if (uIComponent == null) continue;
                arrayList.add(componentStruct.saveState(facesContext));
            }
            map.put("com.sun.faces.DynamicActions", arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveView(FacesContext facesContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletPartialStateManagementStrategy.saveView");
        }
        if (facesContext == null) {
            return null;
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot.isTransient()) {
            return null;
        }
        Util.checkIdUniqueness(facesContext, (UIComponent)uIViewRoot, new HashSet<String>(uIViewRoot.getChildCount() << 1));
        final HashMap<String, Object> hashMap = new HashMap<String, Object>();
        final StateContext stateContext = StateContext.getStateContext(facesContext);
        facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
        EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
        final FacesContext facesContext2 = facesContext;
        try {
            uIViewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    VisitResult visitResult = VisitResult.ACCEPT;
                    if (!uIComponent.isTransient()) {
                        Object object;
                        if (stateContext.componentAddedDynamically(uIComponent)) {
                            uIComponent.getAttributes().put("com.sun.faces.DynamicComponent", new Integer(FaceletPartialStateManagementStrategy.this.getProperChildIndex(uIComponent)));
                            object = new StateHolderSaver(facesContext2, uIComponent);
                        } else {
                            object = uIComponent.saveState(visitContext.getFacesContext());
                        }
                        if (object != null) {
                            hashMap.put(uIComponent.getClientId(visitContext.getFacesContext()), object);
                        }
                    } else {
                        return VisitResult.REJECT;
                    }
                    return visitResult;
                }
            });
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        this.saveDynamicActions(facesContext, stateContext, hashMap);
        StateContext.release(facesContext);
        return new Object[]{null, hashMap};
    }

    private int getProperChildIndex(UIComponent uIComponent) {
        int n = -1;
        if (uIComponent.getParent().getChildren().indexOf(uIComponent) != -1) {
            UIComponent uIComponent2;
            UIComponent uIComponent3 = uIComponent.getParent();
            int n2 = 0;
            Iterator iterator = uIComponent3.getChildren().iterator();
            while (iterator.hasNext() && (uIComponent2 = (UIComponent)iterator.next()) != uIComponent) {
                if (uIComponent2.isTransient()) continue;
                ++n2;
            }
            if (n2 == 0 && !uIComponent3.getChildren().isEmpty() && ((UIComponent)uIComponent3.getChildren().get(0)).isTransient()) {
                n2 = -1;
            }
            n = n2;
        }
        return n;
    }
}

