/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewScopeContextObject;
import com.sun.faces.application.view.ViewScopedCDIEventFireHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopeContextManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private boolean isCdiOneOneOrGreater;
    private Class viewScopedCDIEventFireHelperImplClass;
    private static final String ACTIVE_VIEW_CONTEXTS = "com.sun.faces.application.view.activeViewContexts";
    private static final String ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    private final BeanManager beanManager;

    public ViewScopeContextManager() {
        block2: {
            this.isCdiOneOneOrGreater = Util.isCdiOneOneOrGreater();
            try {
                this.viewScopedCDIEventFireHelperImplClass = Class.forName("com.sun.faces.application.view.ViewScopedCDIEventFireHelperImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", classNotFoundException);
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap());
    }

    public void clear(FacesContext facesContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped CDI beans for current view map");
        }
        Map map = facesContext.getViewRoot().getViewMap(false);
        Map<String, ViewScopeContextObject> map2 = this.getContextMap(facesContext, false);
        if (map2 != null) {
            this.destroyBeans(map, map2);
        }
    }

    public void clear(FacesContext facesContext, Map<String, Object> map) {
        Map<String, ViewScopeContextObject> map2;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped CDI beans for given view map: {0}");
        }
        if ((map2 = this.getContextMap(facesContext, map)) != null) {
            this.destroyBeans(map, map2);
        }
    }

    public <T> T createBean(FacesContext facesContext, Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Creating @ViewScoped CDI bean using contextual: {0}", contextual);
        }
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("ViewScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        Object object = contextual.create(creationalContext);
        if (object != null) {
            String string = this.getName(object);
            facesContext.getViewRoot().getViewMap(true).put(string, object);
            String string2 = ((PassivationCapable)contextual).getId();
            this.getContextMap(facesContext).put(string2, new ViewScopeContextObject(string2, string));
        }
        return (T)object;
    }

    private void destroyBeans(Map<String, Object> map, Map<String, ViewScopeContextObject> map2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (map2 != null) {
            for (Map.Entry<String, ViewScopeContextObject> object : map2.entrySet()) {
                String string = object.getKey();
                Bean bean = this.beanManager.getPassivationCapableBean(string);
                ViewScopeContextObject viewScopeContextObject = object.getValue();
                CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
                bean.destroy(map.get(viewScopeContextObject.getName()), creationalContext);
                arrayList.add(viewScopeContextObject.getName());
            }
            for (String string : arrayList) {
                map.remove(string);
            }
        }
    }

    public <T> T getBean(FacesContext facesContext, Contextual<T> contextual) {
        T t = null;
        Map<String, ViewScopeContextObject> map = this.getContextMap(facesContext);
        if (map != null) {
            if (!(contextual instanceof PassivationCapable)) {
                throw new IllegalArgumentException("ViewScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
            }
            ViewScopeContextObject viewScopeContextObject = map.get(((PassivationCapable)contextual).getId());
            if (viewScopeContextObject != null) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Getting value for @ViewScoped bean with name: {0}", viewScopeContextObject.getName());
                }
                t = (T)facesContext.getViewRoot().getViewMap(true).get(viewScopeContextObject.getName());
            }
        }
        return t;
    }

    private Map<String, ViewScopeContextObject> getContextMap(FacesContext facesContext) {
        return this.getContextMap(facesContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ViewScopeContextObject> getContextMap(FacesContext facesContext, boolean bl) {
        Map map = null;
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext != null) {
            Map map2;
            Map map3 = externalContext.getSessionMap();
            ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)map3.get(ACTIVE_VIEW_CONTEXTS);
            Map map4 = facesContext.getViewRoot().getViewMap(false);
            if (concurrentHashMap == null && bl) {
                map2 = map3;
                synchronized (map2) {
                    concurrentHashMap = new ConcurrentHashMap();
                    map3.put(ACTIVE_VIEW_CONTEXTS, concurrentHashMap);
                }
            }
            if (concurrentHashMap != null && bl) {
                map2 = concurrentHashMap;
                synchronized (map2) {
                    if (!concurrentHashMap.containsKey(System.identityHashCode(map4)) && bl) {
                        concurrentHashMap.put(System.identityHashCode(map4), new ConcurrentHashMap());
                        map3.put(ACTIVE_VIEW_CONTEXTS, concurrentHashMap);
                    }
                }
            }
            if (concurrentHashMap != null) {
                map = (Map)concurrentHashMap.get(System.identityHashCode(map4));
            }
        }
        return map;
    }

    private Map<String, ViewScopeContextObject> getContextMap(FacesContext facesContext, Map<String, Object> map) {
        Map map2;
        Map map3;
        Map map4 = null;
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext != null && (map3 = (Map)(map2 = externalContext.getSessionMap()).get(ACTIVE_VIEW_CONTEXTS)) != null) {
            map4 = (Map)map3.get(System.identityHashCode(map));
        }
        return map4;
    }

    private String getName(Object object) {
        String string = object.getClass().getSimpleName().substring(0, 1).toLowerCase() + object.getClass().getSimpleName().substring(1);
        Named named = object.getClass().getAnnotation(Named.class);
        if (named != null && named.value() != null && !named.value().trim().equals("")) {
            string = named.value();
        }
        return string;
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession;
        Map map;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Cleaning up session for CDI @ViewScoped beans");
        }
        if ((map = (Map)(httpSession = httpSessionEvent.getSession()).getAttribute(ACTIVE_VIEW_CONTEXTS)) != null) {
            Map map2 = (Map)httpSession.getAttribute(ACTIVE_VIEW_MAPS);
            if (map2 != null) {
                for (Map map3 : map2.values()) {
                    Map map4 = (Map)map.get(System.identityHashCode(map3));
                    this.destroyBeans(map3, map4);
                }
            }
            map.clear();
            httpSession.removeAttribute(ACTIVE_VIEW_CONTEXTS);
        }
    }

    public void fireInitializedEvent(FacesContext facesContext, UIViewRoot uIViewRoot) {
        Set set;
        BeanManager beanManager;
        if (this.isCdiOneOneOrGreater && null != this.viewScopedCDIEventFireHelperImplClass && null != (beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap())) && null != (set = beanManager.getBeans((Type)this.viewScopedCDIEventFireHelperImplClass, new Annotation[0])) && !set.isEmpty()) {
            Bean bean = beanManager.resolve(set);
            CreationalContext creationalContext = beanManager.createCreationalContext(null);
            ViewScopedCDIEventFireHelper viewScopedCDIEventFireHelper = (ViewScopedCDIEventFireHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
            viewScopedCDIEventFireHelper.fireInitializedEvent(uIViewRoot);
        }
    }

    public void fireDestroyedEvent(FacesContext facesContext, UIViewRoot uIViewRoot) {
        Set set;
        BeanManager beanManager;
        if (this.isCdiOneOneOrGreater && null != this.viewScopedCDIEventFireHelperImplClass && null != (beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap())) && null != (set = beanManager.getBeans((Type)this.viewScopedCDIEventFireHelperImplClass, new Annotation[0])) && !set.isEmpty()) {
            Bean bean = beanManager.resolve(set);
            CreationalContext creationalContext = beanManager.createCreationalContext(null);
            ViewScopedCDIEventFireHelper viewScopedCDIEventFireHelper = (ViewScopedCDIEventFireHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
            viewScopedCDIEventFireHelper.fireDestroyedEvent(uIViewRoot);
        }
    }
}

