/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.ViewScopeContextManager;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.Util;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructViewMapEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.ViewMapListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopeManager
implements HttpSessionListener,
ViewMapListener {
    private static final Logger LOGGER = Logger.getLogger(ViewScopeManager.class.getName());
    public static final String ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    public static final String ACTIVE_VIEW_MAPS_SIZE = "com.sun.faces.application.view.activeViewMapsSize";
    public static final String VIEW_MAP = "com.sun.faces.application.view.viewMap";
    public static final String VIEW_MAP_ID = "com.sun.faces.application.view.viewMapId";
    public static final String VIEW_SCOPE_MANAGER = "com.sun.faces.application.view.viewScopeManager";
    private ViewScopeContextManager contextManager;
    private boolean distributable;

    public ViewScopeManager() {
        FacesContext facesContext;
        block2: {
            facesContext = FacesContext.getCurrentInstance();
            try {
                this.contextManager = Util.isCDIAvailable(facesContext.getExternalContext().getApplicationMap()) ? new ViewScopeContextManager() : null;
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.INFO)) break block2;
                LOGGER.log(Level.INFO, "CDI @ViewScoped manager unavailable", exception);
            }
        }
        WebConfiguration webConfiguration = WebConfiguration.getInstance(facesContext.getExternalContext());
        this.distributable = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable);
    }

    public void clear(FacesContext facesContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped beans from current view map");
        }
        if (this.contextManager != null) {
            this.contextManager.clear(facesContext);
        }
        this.destroyBeans(facesContext, (Map<String, Object>)facesContext.getViewRoot().getViewMap(false));
    }

    public void clear(FacesContext facesContext, Map<String, Object> map) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Clearing @ViewScoped beans from view map: {0}", map);
        }
        if (this.contextManager != null) {
            this.contextManager.clear(facesContext, map);
        }
        this.destroyBeans(facesContext, map);
    }

    private void destroyBeans(ApplicationAssociate applicationAssociate, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            try {
                BeanManager beanManager;
                if (applicationAssociate == null || (beanManager = applicationAssociate.getBeanManager()) == null || !beanManager.isManaged(string)) continue;
                beanManager.destroy(string, object);
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Error calling @PreDestroy on bean with name: " + string, exception);
            }
        }
    }

    public void destroyBeans(FacesContext facesContext, Map<String, Object> map) {
        ApplicationAssociate applicationAssociate;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Destroying @ViewScoped beans from view map: {0}", map);
        }
        if ((applicationAssociate = ApplicationAssociate.getInstance(facesContext.getExternalContext())) != null) {
            this.destroyBeans(applicationAssociate, map);
        }
    }

    ViewScopeContextManager getContextManager() {
        return this.contextManager;
    }

    public static ViewScopeManager getInstance(FacesContext facesContext) {
        if (!facesContext.getExternalContext().getApplicationMap().containsKey(VIEW_SCOPE_MANAGER)) {
            facesContext.getExternalContext().getApplicationMap().put(VIEW_SCOPE_MANAGER, new ViewScopeManager());
        }
        return (ViewScopeManager)facesContext.getExternalContext().getApplicationMap().get(VIEW_SCOPE_MANAGER);
    }

    public boolean isListenerForSource(Object object) {
        return object instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
        if (systemEvent instanceof PreDestroyViewMapEvent) {
            this.processPreDestroyViewMap(systemEvent);
        }
        if (systemEvent instanceof PostConstructViewMapEvent) {
            this.processPostConstructViewMap(systemEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPostConstructViewMap(SystemEvent systemEvent) {
        UIViewRoot uIViewRoot;
        Map map;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Handling PostConstructViewMapEvent");
        }
        if ((map = (uIViewRoot = (UIViewRoot)systemEvent.getSource()).getViewMap(false)) != null) {
            Object object;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (uIViewRoot.isTransient() && facesContext.isProjectStage(ProjectStage.Development)) {
                object = new FacesMessage(FacesMessage.SEVERITY_WARN, "@ViewScoped beans are not supported on stateless views", "@ViewScoped beans are not supported on stateless views");
                facesContext.addMessage(uIViewRoot.getClientId(facesContext), (FacesMessage)object);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "@ViewScoped beans are not supported on stateless views");
                }
            }
            if ((object = facesContext.getExternalContext().getSession(true)) != null) {
                Map map2;
                Map map3 = facesContext.getExternalContext().getSessionMap();
                Integer n = (Integer)map3.get(ACTIVE_VIEW_MAPS_SIZE);
                if (n == null) {
                    n = 25;
                }
                if (map3.get(ACTIVE_VIEW_MAPS) == null) {
                    map3.put(ACTIVE_VIEW_MAPS, Collections.synchronizedMap(new LRUMap(n)));
                }
                Map map4 = map2 = (Map)map3.get(ACTIVE_VIEW_MAPS);
                synchronized (map4) {
                    String string = UUID.randomUUID().toString();
                    while (map2.containsKey(string)) {
                        string = UUID.randomUUID().toString();
                    }
                    if (map2.size() == n.intValue()) {
                        String string2 = (String)map2.keySet().iterator().next();
                        Map map5 = (Map)map2.remove(string2);
                        this.removeEldestViewMap(facesContext, map5);
                    }
                    map2.put(string, map);
                    uIViewRoot.getTransientStateHelper().putTransient((Object)VIEW_MAP_ID, (Object)string);
                    uIViewRoot.getTransientStateHelper().putTransient((Object)VIEW_MAP, (Object)map);
                    if (this.distributable) {
                        map3.put(ACTIVE_VIEW_MAPS, map2);
                    }
                }
                if (null != this.contextManager) {
                    this.contextManager.fireInitializedEvent(facesContext, uIViewRoot);
                }
            }
        }
    }

    private void processPreDestroyViewMap(SystemEvent systemEvent) {
        UIViewRoot uIViewRoot;
        Map map;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Handling PreDestroyViewMapEvent");
        }
        if ((map = (uIViewRoot = (UIViewRoot)systemEvent.getSource()).getViewMap(false)) != null && !map.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (this.contextManager != null) {
                this.contextManager.clear(facesContext, map);
                this.contextManager.fireDestroyedEvent(facesContext, uIViewRoot);
            }
            this.destroyBeans(facesContext, (Map<String, Object>)map);
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Creating session for @ViewScoped beans");
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession;
        Map map;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Cleaning up session for @ViewScoped beans");
        }
        if (this.contextManager != null) {
            this.contextManager.sessionDestroyed(httpSessionEvent);
        }
        if ((map = (Map)(httpSession = httpSessionEvent.getSession()).getAttribute(ACTIVE_VIEW_MAPS)) != null) {
            Iterator iterator = map.values().iterator();
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(httpSessionEvent.getSession().getServletContext());
            while (iterator.hasNext()) {
                Map map2 = (Map)iterator.next();
                this.destroyBeans(applicationAssociate, (Map<String, Object>)map2);
            }
            map.clear();
            httpSession.removeAttribute(ACTIVE_VIEW_MAPS);
            httpSession.removeAttribute(ACTIVE_VIEW_MAPS_SIZE);
        }
    }

    private void removeEldestViewMap(FacesContext facesContext, Map<String, Object> map) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Removing eldest view map: {0}", map);
        }
        if (this.contextManager != null) {
            this.contextManager.clear(facesContext, map);
        }
        this.destroyBeans(facesContext, map);
    }
}

