/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.config.processor.FacesConfigNamespaceContext;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.flow.FlowImpl;
import com.sun.faces.flow.ParameterImpl;
import com.sun.faces.flow.builder.FlowBuilderImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowHandlerFactory;
import javax.faces.flow.FlowNode;
import javax.faces.flow.builder.FlowBuilder;
import javax.faces.flow.builder.FlowCallBuilder;
import javax.faces.flow.builder.MethodCallBuilder;
import javax.faces.flow.builder.NavigationCaseBuilder;
import javax.faces.flow.builder.SwitchBuilder;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesFlowDefinitionConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACES_FLOW_DEFINITION = "flow-definition";
    private static final String flowDefinitionListKey = "com.sun.faces.FacesFlowDefinitions";

    public static boolean uriIsFlowDefinition(URI uRI) {
        boolean bl = false;
        String string = uRI.getPath();
        String[] stringArray = string.split("/");
        if (1 < stringArray.length) {
            String string2 = stringArray[stringArray.length - 2];
            String string3 = stringArray[stringArray.length - 1];
            bl = string3.equals(string2 + "-flow.xml");
        }
        return bl;
    }

    public static Document synthesizeEmptyFlowDefinition(URI uRI) throws ParserConfigurationException {
        Document document = null;
        String string = uRI.getPath();
        String[] stringArray = string.split("/");
        if (stringArray.length < 2) {
            return document;
        }
        String string2 = stringArray[stringArray.length - 2];
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        document = dOMImplementation.createDocument("http://xmlns.jcp.org/xml/ns/javaee", "faces-config", null);
        Element element = document.getDocumentElement();
        Attr attr = document.createAttribute("version");
        attr.setValue("2.2");
        element.getAttributes().setNamedItem(attr);
        Node node = document.getFirstChild();
        Element element2 = document.createElementNS("http://xmlns.jcp.org/xml/ns/javaee", FACES_FLOW_DEFINITION);
        element2.setAttribute("id", string2);
        node.appendChild(element2);
        String string3 = string2 + "-return";
        Element element3 = document.createElementNS("http://xmlns.jcp.org/xml/ns/javaee", "flow-return");
        element3.setAttribute("id", string3);
        element2.appendChild(element3);
        Element element4 = document.createElementNS("http://xmlns.jcp.org/xml/ns/javaee", "from-outcome");
        element3.appendChild(element4);
        element4.setTextContent("/" + string3);
        return document;
    }

    @Override
    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        Object object;
        WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        for (int i = 0; i < documentInfoArray.length; ++i) {
            URI uRI = documentInfoArray[i].getSourceURI();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", uRI));
            }
            object = documentInfoArray[i].getDocument();
            String string = object.getDocumentElement().getNamespaceURI();
            NodeList nodeList = object.getDocumentElement().getElementsByTagNameNS(string, FACES_FLOW_DEFINITION);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            webConfiguration.setHasFlows(true);
            this.saveFlowDefinition(facesContext, uRI, (Document)object);
        }
        if (webConfiguration.isHasFlows()) {
            String string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode);
            boolean bl = false;
            if ("none".equals(string)) {
                bl = true;
                object = WebConfiguration.WebContextInitParameter.ClientWindowMode.getQualifiedName();
                LOGGER.log(Level.WARNING, "{0} was set to none, but Faces Flows requires {0} is enabled.  Setting to ''url''.", new Object[]{object});
            } else if (null == string) {
                bl = true;
            }
            if (bl) {
                webConfiguration.setOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode, "url");
            }
            facesContext.getApplication().subscribeToEvent(PostConstructApplicationEvent.class, Application.class, (SystemEventListener)new PerformDeferredFlowProcessing());
        }
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void saveFlowDefinition(FacesContext facesContext, URI uRI, Document document) {
        Map map = facesContext.getExternalContext().getApplicationMap();
        ArrayList<FlowDefinitionDocument> arrayList = (ArrayList<FlowDefinitionDocument>)map.get(flowDefinitionListKey);
        if (null == arrayList) {
            arrayList = new ArrayList<FlowDefinitionDocument>();
            map.put(flowDefinitionListKey, arrayList);
        }
        arrayList.add(new FlowDefinitionDocument(uRI, document));
    }

    private List<FlowDefinitionDocument> getSavedFlowDefinitions(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getApplicationMap();
        List list = (List)map.get(flowDefinitionListKey);
        return null != list ? list : Collections.EMPTY_LIST;
    }

    private void clearSavedFlowDefinitions(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getApplicationMap();
        List list = (List)map.get(flowDefinitionListKey);
        if (null != list) {
            for (FlowDefinitionDocument flowDefinitionDocument : list) {
                flowDefinitionDocument.clear();
            }
            list.clear();
            map.remove(flowDefinitionListKey);
        }
    }

    private void processFacesFlowDefinitions(URI uRI, Document document) throws XPathExpressionException {
        XPath xPath;
        String string = document.getDocumentElement().getNamespaceURI();
        NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, FACES_FLOW_DEFINITION);
        if (0 == nodeList.getLength()) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        FlowHandler flowHandler = application.getFlowHandler();
        if (null == flowHandler) {
            xPath = (FlowHandlerFactory)FactoryFinder.getFactory((String)"javax.faces.flow.FlowHandlerFactory");
            flowHandler = xPath.createFlowHandler(facesContext);
            application.setFlowHandler(flowHandler);
        }
        xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new FacesConfigNamespaceContext());
        String string2 = "";
        NodeList nodeList2 = (NodeList)xPath.evaluate("./ns1:name/text()", document.getDocumentElement(), XPathConstants.NODESET);
        if (null != nodeList2 && 1 < nodeList2.getLength()) {
            throw new XPathExpressionException("<faces-config> must have at most one <name> element.");
        }
        if (null != nodeList2 && 1 == nodeList2.getLength() && 0 < (string2 = nodeList2.item(0).getNodeValue().trim()).length()) {
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(facesContext.getExternalContext());
            try {
                applicationAssociate.relateUrlToDefiningDocumentInJar(uRI.toURL(), string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathExpressionException(malformedURLException);
            }
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            String string3 = this.getIdAttribute(node);
            String string4 = uRI.toASCIIString();
            if (string4.endsWith("-flow.xml")) {
                string2 = "";
            }
            FlowBuilderImpl flowBuilderImpl = new FlowBuilderImpl(facesContext);
            flowBuilderImpl.id(string2, string3);
            this.processViews(xPath, node, flowBuilderImpl);
            this.processNavigationRules(xPath, node, flowBuilderImpl);
            this.processReturns(xPath, node, flowBuilderImpl);
            this.processInboundParameters(xPath, node, flowBuilderImpl);
            this.processFlowCalls(xPath, node, flowBuilderImpl);
            this.processSwitches(xPath, node, flowBuilderImpl);
            this.processMethodCalls(facesContext, xPath, node, flowBuilderImpl);
            this.processInitializerFinalizer(xPath, node, flowBuilderImpl);
            String string5 = this.processStartNode(xPath, node, flowBuilderImpl);
            if (null != string5) {
                FlowImpl flowImpl = flowBuilderImpl._getFlow();
                FlowNode flowNode = flowImpl.getNode(string5);
                if (null == flowNode) {
                    throw new XPathExpressionException("Unable to find flow node with id " + string5 + " to mark as start node");
                }
                flowImpl.setStartNodeId(string5);
            } else {
                flowBuilderImpl.viewNode(string3, "/" + string3 + "/" + string3 + ".xhtml").markAsStartNode();
            }
            flowHandler.addFlow(facesContext, flowBuilderImpl.getFlow());
        }
    }

    private void processNavigationRules(XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:navigation-rule", node, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            NodeList nodeList2 = (NodeList)xPath.evaluate(".//ns1:from-view-id/text()", node2, XPathConstants.NODESET);
            if (1 != nodeList2.getLength()) {
                throw new XPathExpressionException("Within <navigation-rule> must have exactly one <from-view-id>");
            }
            String string = nodeList2.item(0).getNodeValue().trim();
            NodeList nodeList3 = (NodeList)xPath.evaluate(".//ns1:navigation-case", node2, XPathConstants.NODESET);
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                NodeList nodeList4;
                String string2;
                Node node3 = nodeList3.item(j);
                NodeList nodeList5 = (NodeList)xPath.evaluate(".//ns1:to-view-id/text()", node3, XPathConstants.NODESET);
                if (1 != nodeList5.getLength()) {
                    throw new XPathExpressionException("Within <navigation-case>, must have exactly one <to-view-id>");
                }
                String string3 = nodeList5.item(0).getNodeValue().trim();
                NavigationCaseBuilder navigationCaseBuilder = flowBuilder.navigationCase();
                navigationCaseBuilder.fromViewId(string).toViewId(string3);
                NodeList nodeList6 = (NodeList)xPath.evaluate(".//ns1:from-outcome/text()", node3, XPathConstants.NODESET);
                if (null != nodeList6 && 1 < nodeList6.getLength()) {
                    throw new XPathExpressionException("Within <navigation-case>, must have at most one <from-outcome>");
                }
                if (null != nodeList6 && 1 == nodeList6.getLength()) {
                    string2 = nodeList6.item(0).getNodeValue().trim();
                    navigationCaseBuilder.fromOutcome(string2);
                }
                if (null != (nodeList6 = (NodeList)xPath.evaluate(".//ns1:from-action/text()", node3, XPathConstants.NODESET)) && 1 < nodeList6.getLength()) {
                    throw new XPathExpressionException("Within <navigation-case>, must have at most one <from-action>");
                }
                if (null != nodeList6 && 1 == nodeList6.getLength()) {
                    string2 = nodeList6.item(0).getNodeValue().trim();
                    navigationCaseBuilder.fromAction(string2);
                }
                if (null != (nodeList6 = (NodeList)xPath.evaluate(".//ns1:if/text()", node3, XPathConstants.NODESET)) && 1 < nodeList6.getLength()) {
                    throw new XPathExpressionException("Within <navigation-case>, must have zero or one <if>");
                }
                if (null != nodeList6 && 1 == nodeList6.getLength()) {
                    string2 = nodeList6.item(0).getNodeValue().trim();
                    navigationCaseBuilder.condition(string2);
                }
                if (null != (nodeList6 = (NodeList)xPath.evaluate(".//ns1:redirect", node3, XPathConstants.NODESET)) && 1 < nodeList6.getLength()) {
                    throw new XPathExpressionException("Within <navigation-case>, must have zero or one <redirect>");
                }
                if (null == nodeList6 || 1 != nodeList6.getLength()) continue;
                string2 = navigationCaseBuilder.redirect();
                Node node4 = nodeList6.item(0);
                String string4 = this.getAttribute(node4, "include-view-params");
                if (null != string4 && "true".equalsIgnoreCase(string4)) {
                    string2.includeViewParams();
                }
                if (null == (nodeList4 = (NodeList)xPath.evaluate(".//ns1:redirect-param", node4, XPathConstants.NODESET))) continue;
                for (int k = 0; k < nodeList4.getLength(); ++k) {
                    Node node5 = nodeList4.item(k);
                    NodeList nodeList7 = (NodeList)xPath.evaluate(".//ns1:name/text()", node5, XPathConstants.NODESET);
                    if (null == nodeList7 || 1 != nodeList7.getLength()) {
                        throw new XPathExpressionException("Within <redirect-param> must have <name>.");
                    }
                    String string5 = nodeList7.item(0).getNodeValue().trim();
                    NodeList nodeList8 = (NodeList)xPath.evaluate(".//ns1:value/text()", node5, XPathConstants.NODESET);
                    if (null == nodeList8 || 1 != nodeList8.getLength()) {
                        throw new XPathExpressionException("Within <redirect-param> must have <value>.");
                    }
                    String string6 = nodeList8.item(0).getNodeValue().trim();
                    string2.parameter(string5, string6);
                }
            }
        }
    }

    private void processViews(XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:view", node, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = this.getIdAttribute(node2);
            NodeList nodeList2 = (NodeList)xPath.evaluate(".//ns1:vdl-document/text()", node2, XPathConstants.NODESET);
            if (1 != nodeList2.getLength()) {
                throw new XPathExpressionException("Within <view> exactly one child is allowed, and it must be a <vdl-document>");
            }
            String string2 = nodeList2.item(0).getNodeValue().trim();
            flowBuilder.viewNode(string, string2);
        }
    }

    private void processReturns(XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:flow-return", node, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            NodeList nodeList2 = (NodeList)xPath.evaluate(".//ns1:from-outcome/text()", node2, XPathConstants.NODESET);
            String string = this.getIdAttribute(node2);
            if (null != nodeList2 && 1 < nodeList2.getLength()) {
                throw new XPathExpressionException("Within <flow-return id=\"" + string + "\"> only one child is allowed, and it must be a <from-outcome>");
            }
            if (null == nodeList2 || 1 != nodeList2.getLength()) continue;
            String string2 = nodeList2.item(0).getNodeValue().trim();
            flowBuilder.returnNode(string).fromOutcome(string2);
        }
    }

    private void processInboundParameters(XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:inbound-parameter", node, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            NodeList nodeList2 = (NodeList)xPath.evaluate(".//ns1:name/text()", node2, XPathConstants.NODESET);
            if (1 < nodeList2.getLength()) {
                throw new XPathExpressionException("Within <inbound-parameter> only one <name> child is allowed");
            }
            String string = nodeList2.item(0).getNodeValue().trim();
            NodeList nodeList3 = (NodeList)xPath.evaluate(".//ns1:value/text()", node2, XPathConstants.NODESET);
            if (1 < nodeList3.getLength()) {
                throw new XPathExpressionException("Within <inbound-parameter> only one <value> child is allowed");
            }
            String string2 = nodeList3.item(0).getNodeValue().trim();
            flowBuilder.inboundParameter(string, string2);
        }
    }

    private void processFlowCalls(XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:flow-call", node, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = this.getIdAttribute(node2);
            NodeList nodeList2 = (NodeList)xPath.evaluate(".//ns1:flow-reference", node2, XPathConstants.NODESET);
            if (null == nodeList2 || 1 != nodeList2.getLength()) {
                throw new XPathExpressionException("Within <flow-call> must have exactly one <flow-reference>");
            }
            Node node3 = nodeList2.item(0);
            NodeList nodeList3 = (NodeList)xPath.evaluate(".//ns1:flow-id/text()", node3, XPathConstants.NODESET);
            if (null == nodeList3 || 1 != nodeList3.getLength()) {
                throw new XPathExpressionException("Within <flow-reference> must have exactly one <flow-id>");
            }
            String string2 = nodeList3.item(0).getNodeValue().trim();
            NodeList nodeList4 = (NodeList)xPath.evaluate(".//ns1:flow-document-id/text()", node3, XPathConstants.NODESET);
            if (null == nodeList4 && 1 != nodeList4.getLength()) {
                throw new XPathExpressionException("Within <flow-reference> must have at most one <flow-document-id>");
            }
            String string3 = "";
            if (null != nodeList4 && 1 == nodeList4.getLength()) {
                string3 = nodeList4.item(0).getNodeValue().trim();
            }
            FlowCallBuilder flowCallBuilder = flowBuilder.flowCallNode(string);
            flowCallBuilder.flowReference(string3, string2);
            NodeList nodeList5 = (NodeList)xPath.evaluate(".//ns1:outbound-parameter", node, XPathConstants.NODESET);
            if (null == nodeList5) continue;
            for (int j = 0; j < nodeList5.getLength(); ++j) {
                Node node4 = nodeList5.item(j);
                NodeList nodeList6 = (NodeList)xPath.evaluate(".//ns1:name/text()", node4, XPathConstants.NODESET);
                if (1 < nodeList6.getLength()) {
                    throw new XPathExpressionException("Within <outbound-parameter> only one <name> child is allowed");
                }
                String string4 = nodeList6.item(0).getNodeValue().trim();
                NodeList nodeList7 = (NodeList)xPath.evaluate(".//ns1:value/text()", node4, XPathConstants.NODESET);
                if (1 < nodeList7.getLength()) {
                    throw new XPathExpressionException("Within <inbound-parameter> only one <value> child is allowed");
                }
                String string5 = nodeList7.item(0).getNodeValue().trim();
                flowCallBuilder.outboundParameter(string4, string5);
            }
        }
    }

    private void processSwitches(XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:switch", node, XPathConstants.NODESET);
        if (null == nodeList) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2;
            Object object;
            Node node2;
            Node node3 = nodeList.item(i);
            String string = this.getIdAttribute(node3);
            SwitchBuilder switchBuilder = flowBuilder.switchNode(string);
            NodeList nodeList3 = (NodeList)xPath.evaluate(".//ns1:case", node3, XPathConstants.NODESET);
            if (null != nodeList3) {
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    node2 = nodeList3.item(j);
                    object = (NodeList)xPath.evaluate(".//ns1:if/text()", node2, XPathConstants.NODESET);
                    if (1 < object.getLength()) {
                        throw new XPathExpressionException("Within <case> only one <if> child is allowed");
                    }
                    String string2 = object.item(0).getNodeValue().trim();
                    NodeList nodeList4 = (NodeList)xPath.evaluate(".//ns1:from-outcome/text()", node2, XPathConstants.NODESET);
                    if (1 < nodeList4.getLength()) {
                        throw new XPathExpressionException("Within <case> only one <from-outcome> child is allowed");
                    }
                    String string3 = nodeList4.item(0).getNodeValue().trim();
                    switchBuilder.switchCase().condition(string2).fromOutcome(string3);
                }
            }
            if (null != (nodeList2 = (NodeList)xPath.evaluate(".//ns1:default-outcome/text()", node3, XPathConstants.NODESET)) && 1 < nodeList2.getLength()) {
                throw new XPathExpressionException("Within <switch> only one <default-outcome> child is allowed");
            }
            if (null == nodeList2 || null == (node2 = nodeList2.item(0))) continue;
            object = node2.getNodeValue().trim();
            switchBuilder.defaultOutcome((String)object);
        }
    }

    private void processMethodCalls(FacesContext facesContext, XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:method-call", node, XPathConstants.NODESET);
        if (null == nodeList) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            ArrayList<Class<Object>> arrayList;
            Node node2 = nodeList.item(i);
            String string = this.getIdAttribute(node2);
            MethodCallBuilder methodCallBuilder = flowBuilder.methodCallNode(string);
            NodeList nodeList2 = (NodeList)xPath.evaluate(".//ns1:method/text()", node2, XPathConstants.NODESET);
            if (1 != nodeList2.getLength()) {
                throw new XPathExpressionException("Within <method-call> exactly one <method> child is allowed");
            }
            String string2 = nodeList2.item(0).getNodeValue().trim();
            NodeList nodeList3 = (NodeList)xPath.evaluate(".//ns1:parameter", node2, XPathConstants.NODESET);
            if (null != nodeList3) {
                arrayList = Collections.emptyList();
                if (0 < nodeList3.getLength()) {
                    arrayList = new ArrayList<Class<Object>>();
                    object = new ArrayList();
                    ParameterImpl parameterImpl = null;
                    ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
                    ELContext eLContext = facesContext.getELContext();
                    ValueExpression valueExpression = null;
                    for (int j = 0; j < nodeList3.getLength(); ++j) {
                        Node node3 = nodeList3.item(j);
                        NodeList nodeList4 = (NodeList)xPath.evaluate(".//ns1:value/text()", node3, XPathConstants.NODESET);
                        if (null == nodeList4 || 1 != nodeList4.getLength()) {
                            throw new XPathExpressionException("Within <parameter> exactly one <value> child is allowed");
                        }
                        String string3 = nodeList4.item(0).getNodeValue().trim();
                        String string4 = null;
                        NodeList nodeList5 = (NodeList)xPath.evaluate(".//ns1:class/text()", node3, XPathConstants.NODESET);
                        if (null != nodeList5 && 1 < nodeList5.getLength()) {
                            throw new XPathExpressionException("Within <parameter> at most one <class> child is allowed");
                        }
                        if (null != nodeList5 && 1 == nodeList5.getLength()) {
                            string4 = nodeList5.item(0).getNodeValue().trim();
                        }
                        Class<Object> clazz = String.class;
                        if (null != string4) {
                            try {
                                clazz = ReflectionUtil.forName(string4);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                clazz = Object.class;
                            }
                        }
                        valueExpression = expressionFactory.createValueExpression(eLContext, string3, clazz);
                        parameterImpl = new ParameterImpl(string4, valueExpression);
                        object.add(parameterImpl);
                        arrayList.add(clazz);
                    }
                    methodCallBuilder.parameters((List)object);
                }
                object = new Class[arrayList.size()];
                arrayList.toArray((T[])object);
                methodCallBuilder.expression(string2, (Class[])object);
            }
            if (null != (arrayList = (NodeList)xPath.evaluate(".//ns1:default-outcome/text()", node2, XPathConstants.NODESET)) && 1 < arrayList.getLength()) {
                throw new XPathExpressionException("Within <method-call> only one <default-outcome> child is allowed");
            }
            if (null == arrayList) continue;
            object = arrayList.item(0).getNodeValue().trim();
            methodCallBuilder.defaultOutcome((String)object);
        }
    }

    private void processInitializerFinalizer(XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        Object object;
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:initializer/text()", node, XPathConstants.NODESET);
        if (1 < nodeList.getLength()) {
            throw new XPathExpressionException("At most one <initializer> is allowed.");
        }
        if (1 == nodeList.getLength()) {
            object = nodeList.item(0).getNodeValue().trim();
            flowBuilder.initializer((String)object);
        }
        if (1 < (object = (NodeList)xPath.evaluate(".//ns1:finalizer/text()", node, XPathConstants.NODESET)).getLength()) {
            throw new XPathExpressionException("At most one <finalizer> is allowed.");
        }
        if (1 == object.getLength()) {
            String string = object.item(0).getNodeValue().trim();
            flowBuilder.finalizer(string);
        }
    }

    private String processStartNode(XPath xPath, Node node, FlowBuilder flowBuilder) throws XPathExpressionException {
        String string = null;
        NodeList nodeList = (NodeList)xPath.evaluate(".//ns1:start-node/text()", node, XPathConstants.NODESET);
        if (1 < nodeList.getLength()) {
            throw new XPathExpressionException("Within <flow-definition> at most one <start-node> is allowed");
        }
        if (null != nodeList && 1 == nodeList.getLength()) {
            string = nodeList.item(0).getNodeValue().trim();
        }
        return string;
    }

    protected String getAttribute(Node node, String string) {
        Attr attr;
        Util.notNull("flow definition element", node);
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (null != namedNodeMap && null != (attr = (Attr)namedNodeMap.getNamedItem(string))) {
            string2 = attr.getValue();
        }
        return string2;
    }

    protected String getIdAttribute(Node node) throws XPathExpressionException {
        Util.notNull("flow definition element", node);
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string2 = "";
        boolean bl = false;
        if (null != namedNodeMap) {
            Attr attr = (Attr)namedNodeMap.getNamedItem("id");
            if (null != attr) {
                string = attr.getValue();
                if (!attr.isId() && LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Element {0} has an id attribute, but it is not declared as type xsd:id", node.getLocalName());
                }
            } else {
                string2 = node.getLocalName();
                bl = true;
            }
        } else {
            string2 = node.getLocalName();
            bl = true;
        }
        if (bl) {
            throw new XPathExpressionException("<" + string2 + "> must have an \"id\" attribute.");
        }
        return string;
    }

    private class PerformDeferredFlowProcessing
    implements SystemEventListener {
        private PerformDeferredFlowProcessing() {
        }

        public boolean isListenerForSource(Object object) {
            return object instanceof Application;
        }

        public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            List list = FacesFlowDefinitionConfigProcessor.this.getSavedFlowDefinitions(facesContext);
            for (FlowDefinitionDocument flowDefinitionDocument : list) {
                try {
                    FacesFlowDefinitionConfigProcessor.this.processFacesFlowDefinitions(flowDefinitionDocument.definingDocumentURI, flowDefinitionDocument.flowDefinitions);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    throw new FacesException((Throwable)xPathExpressionException);
                }
            }
            FacesFlowDefinitionConfigProcessor.this.clearSavedFlowDefinitions(facesContext);
        }
    }

    private static class FlowDefinitionDocument {
        URI definingDocumentURI;
        Document flowDefinitions;

        public FlowDefinitionDocument(URI uRI, Document document) {
            this.definingDocumentURI = uRI;
            this.flowDefinitions = document;
        }

        public void clear() {
            this.definingDocumentURI = null;
            this.flowDefinitions = null;
        }
    }
}

