/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipInputStream;

public final class Classpath {
    private static final String[] PREFIXES_TO_EXCLUDE = new String[]{"rar:", "sar:"};
    private static final String[] EXTENSIONS_TO_EXCLUDE = new String[]{".rar", ".sar"};

    public static URL[] search(String string, String string2) throws IOException {
        return Classpath.search(Thread.currentThread().getContextClassLoader(), string, string2, SearchAdvice.AllMatches);
    }

    public static URL[] search(ClassLoader classLoader, String string, String string2) throws IOException {
        return Classpath.search(classLoader, string, string2, SearchAdvice.AllMatches);
    }

    public static URL[] search(ClassLoader classLoader, String string, String string2, SearchAdvice searchAdvice) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{classLoader.getResources(string), classLoader.getResources(string + "MANIFEST.MF")};
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        int n = enumerationArray.length;
        for (int i = 0; i < n; ++i) {
            while (enumerationArray[i].hasMoreElements()) {
                URL uRL = (URL)enumerationArray[i].nextElement();
                String string3 = uRL.getPath();
                if (-1 != string3.indexOf("%2520")) {
                    string3 = uRL.toExternalForm();
                    string3 = string3.replace("%2520", "%20");
                    uRL = new URL(string3);
                }
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                JarFile jarFile = uRLConnection instanceof JarURLConnection ? ((JarURLConnection)uRLConnection).getJarFile() : Classpath.getAlternativeJarFile(uRL);
                if (jarFile != null) {
                    Classpath.searchJar(classLoader, linkedHashSet, jarFile, string, string2, searchAdvice);
                    continue;
                }
                boolean bl = Classpath.searchDir(linkedHashSet, new File(URLDecoder.decode(uRL.getFile(), "UTF-8")), string2);
                if (bl) continue;
                Classpath.searchFromURL(linkedHashSet, string, string2, uRL);
            }
        }
        URL[] uRLArray = linkedHashSet.toArray(new URL[linkedHashSet.size()]);
        return uRLArray;
    }

    private static boolean searchDir(Set set, File file, String string) throws IOException {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return false;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getAbsolutePath();
                if (fileArray[i].isDirectory()) {
                    Classpath.searchDir(set, fileArray[i], string);
                    continue;
                }
                if (!string2.endsWith(string)) continue;
                set.add(fileArray[i].toURL());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchFromURL(Set set, String string, String string2, URL uRL) throws IOException {
        String string3;
        Object object;
        Object object2;
        boolean bl = false;
        InputStream inputStream = Classpath.getInputStream(uRL);
        if (inputStream != null) {
            object2 = inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(inputStream);
            try {
                object = ((ZipInputStream)object2).getNextEntry();
                boolean bl2 = bl = object != null;
                while (object != null) {
                    string3 = object.getName();
                    if (string3.endsWith(string2)) {
                        String string4 = uRL.toExternalForm();
                        set.add(new URL(string4 + string3));
                    }
                    object = ((ZipInputStream)object2).getNextEntry();
                }
            }
            finally {
                ((ZipInputStream)object2).close();
            }
        }
        if (!bl && string.length() > 0) {
            object2 = uRL.toExternalForm() + "/";
            object = string.split("/");
            string = Classpath.join(object, true);
            string3 = Classpath.join(object, false);
            int n = ((String)object2).lastIndexOf(string3);
            object2 = ((String)object2).substring(0, n);
            for (String string5 : PREFIXES_TO_EXCLUDE) {
                if (!((String)object2).startsWith(string5)) continue;
                return;
            }
            uRL = new URL((String)object2);
            Classpath.searchFromURL(set, string, string2, uRL);
        }
    }

    private static String join(String[] stringArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length - (bl ? 1 : 0); ++i) {
            stringBuffer.append(stringArray[i]).append("/");
        }
        return stringBuffer.toString();
    }

    private static InputStream getInputStream(URL uRL) {
        try {
            return uRL.openStream();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static JarFile getAlternativeJarFile(URL uRL) throws IOException {
        String string = uRL.getFile();
        return Classpath.getAlternativeJarFile(string);
    }

    static JarFile getAlternativeJarFile(String string) throws IOException {
        JarFile jarFile = null;
        int n = string.indexOf("!/");
        int n2 = string.indexOf(33);
        int n3 = -1;
        if (-1 != n || -1 != n2) {
            n3 = n < n2 ? n : n2;
        }
        if (n3 != -1) {
            String string2 = string.substring(0, n3);
            if (string2.startsWith("file:")) {
                string2 = string2.substring("file:".length());
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            boolean bl = false;
            for (int i = 0; i < PREFIXES_TO_EXCLUDE.length; ++i) {
                if (!string2.startsWith(PREFIXES_TO_EXCLUDE[i]) && !string2.endsWith(EXTENSIONS_TO_EXCLUDE[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                jarFile = new JarFile(string2);
            }
            return jarFile;
        }
        return null;
    }

    private static void searchJar(ClassLoader classLoader, Set set, JarFile jarFile, String string, String string2, SearchAdvice searchAdvice) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry;
            try {
                jarEntry = enumeration.nextElement();
            }
            catch (Throwable throwable) {
                continue;
            }
            String string3 = jarEntry.getName();
            if (!string3.startsWith(string) || !string3.endsWith(string2)) continue;
            Enumeration<URL> enumeration2 = classLoader.getResources(string3);
            while (enumeration2.hasMoreElements()) {
                set.add(enumeration2.nextElement());
                if (searchAdvice != SearchAdvice.FirstMatchOnly) continue;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchAdvice {
        FirstMatchOnly,
        AllMatches;

    }
}

