/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ServerSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    public static final String STATEMANAGED_SERIAL_ID_KEY = ServerSideStateHelper.class.getName() + ".SerialId";
    public static final String LOGICAL_VIEW_MAP = ServerSideStateHelper.class.getName() + ".LogicalViewMap";
    protected final Integer numberOfLogicalViews = this.getIntegerConfigValue(WebConfiguration.WebContextInitParameter.NumberOfLogicalViews);
    protected final Integer numberOfViews = this.getIntegerConfigValue(WebConfiguration.WebContextInitParameter.NumberOfViews);
    protected boolean generateUniqueStateIds;
    protected boolean namespaceParameters;
    protected final Random random;

    public ServerSideStateHelper() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        this.generateUniqueStateIds = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.GenerateUniqueServerStateIds);
        this.random = this.generateUniqueStateIds ? new Random(System.nanoTime() + (long)webConfiguration.getServletContext().hashCode()) : null;
        this.namespaceParameters = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.NamespaceParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState(FacesContext facesContext, Object object, StringBuilder stringBuilder) throws IOException {
        String string;
        Object object2;
        Object object3;
        Object[] objectArray;
        Util.notNull("context", facesContext);
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (!uIViewRoot.isTransient()) {
            if (!facesContext.getAttributes().containsKey("com.sun.faces.ViewStateValue")) {
                Util.notNull("state", object);
                objectArray = (Object[])object;
                object3 = facesContext.getExternalContext();
                object2 = object3.getSession(true);
                Map map = object3.getSessionMap();
                Object object4 = object2;
                synchronized (object4) {
                    Map<String, Object[]> map2;
                    Map<String, Map<String, Map<String, Object[]>>> map3 = TypedCollections.dynamicallyCastMap((Map)map.get(LOGICAL_VIEW_MAP), String.class, Map.class);
                    if (map3 == null) {
                        map3 = Collections.synchronizedMap(new LRUMap(this.numberOfLogicalViews));
                        map.put(LOGICAL_VIEW_MAP, map3);
                    }
                    Object object5 = objectArray[0];
                    Object object6 = this.handleSaveState(objectArray[1]);
                    String string2 = (String)RequestStateManager.get(facesContext, "com.sun.faces.logicalViewMap");
                    if (string2 == null) {
                        string2 = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(facesContext);
                    }
                    String string3 = null;
                    if (facesContext.getPartialViewContext().isPartialRequest()) {
                        string3 = (String)RequestStateManager.get(facesContext, "com.sun.faces.actualViewMap");
                    }
                    if (null == string3) {
                        String string4 = string3 = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(facesContext);
                    }
                    if ((map2 = TypedCollections.dynamicallyCastMap(map3.get(string2), String.class, Object[].class)) == null) {
                        map2 = new LRUMap<String, Object[]>(this.numberOfViews);
                        map3.put(string2, map2);
                    }
                    string = string2 + ':' + string3;
                    Object[] objectArray2 = map2.get(string3);
                    if (objectArray2 != null) {
                        objectArray2[0] = object5;
                        objectArray2[1] = object6;
                    } else {
                        map2.put(string3, new Object[]{object5, object6});
                    }
                    map.put(LOGICAL_VIEW_MAP, map3);
                    facesContext.getAttributes().put("com.sun.faces.ViewStateValue", string);
                }
            } else {
                string = (String)facesContext.getAttributes().get("com.sun.faces.ViewStateValue");
            }
        } else {
            string = "stateless";
        }
        if (stringBuilder != null) {
            stringBuilder.append(string);
        } else {
            objectArray = facesContext.getResponseWriter();
            objectArray.startElement("input", null);
            objectArray.writeAttribute("type", (Object)"hidden", null);
            object3 = "javax.faces.ViewState";
            if (this.namespaceParameters && uIViewRoot instanceof NamingContainer && (object2 = uIViewRoot.getContainerClientId(facesContext)) != null) {
                object3 = (String)object2 + (String)object3;
            }
            objectArray.writeAttribute("name", object3, null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableViewStateIdRendering)) {
                object2 = Util.getViewStateId(facesContext);
                objectArray.writeAttribute("id", object2, null);
            }
            objectArray.writeAttribute("value", (Object)string, null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                objectArray.writeAttribute("autocomplete", (Object)"off", null);
            }
            objectArray.endElement("input");
            this.writeClientWindowField(facesContext, (ResponseWriter)objectArray);
            this.writeRenderKitIdField(facesContext, (ResponseWriter)objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getState(FacesContext facesContext, String string) {
        String string2 = ServerSideStateHelper.getStateParamValue(facesContext);
        if (string2 == null) {
            return null;
        }
        if ("stateless".equals(string2)) {
            return "stateless";
        }
        int n = string2.indexOf(58);
        assert (n != -1);
        assert (n < string2.length());
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = externalContext.getSession(false);
        if (object == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to restore server side state for view ID {0} as no session is available", string);
            }
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            Map map;
            Map map2 = (Map)externalContext.getSessionMap().get(LOGICAL_VIEW_MAP);
            if (map2 != null && (map = (Map)map2.get(string3)) != null) {
                RequestStateManager.set(facesContext, "com.sun.faces.logicalViewMap", string3);
                Object[] objectArray = (Object[])map.get(string4);
                Object[] objectArray2 = new Object[]{objectArray[0], objectArray[1]};
                if (objectArray != null) {
                    RequestStateManager.set(facesContext, "com.sun.faces.actualViewMap", string4);
                    if (objectArray.length == 2 && objectArray[1] != null) {
                        objectArray2[1] = this.handleRestoreState(objectArray[1]);
                    }
                }
                return objectArray2;
            }
        }
        return null;
    }

    protected Integer getIntegerConfigValue(WebConfiguration.WebContextInitParameter webContextInitParameter) {
        Integer n;
        block5: {
            String string = this.webConfig.getOptionValue(webContextInitParameter);
            n = null;
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = webContextInitParameter.getDefaultValue();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.state.server.cannot.parse.int.option", new Object[]{webContextInitParameter.getQualifiedName(), string2});
                }
                try {
                    n = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException2) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block5;
                    LOGGER.log(Level.FINEST, "Unable to convert number", numberFormatException2);
                }
            }
        }
        return n;
    }

    protected Object handleSaveState(Object object) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerStateDeprecated) || this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = this.serialProvider.createObjectOutputStream(this.compressViewState ? new GZIPOutputStream((OutputStream)byteArrayOutputStream, 1024) : byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
            finally {
                block12: {
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block12;
                            LOGGER.log(Level.FINEST, "Closing stream", iOException);
                        }
                    }
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        return object;
    }

    protected Object handleRestoreState(Object object) {
        if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerStateDeprecated) || this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = this.serialProvider.createObjectInputStream(this.compressViewState ? new GZIPInputStream((InputStream)byteArrayInputStream, 1024) : byteArrayInputStream);
                Object object2 = objectInputStream.readObject();
                return object2;
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
            finally {
                block11: {
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block11;
                            LOGGER.log(Level.FINEST, "Closing stream", iOException);
                        }
                    }
                }
            }
        }
        return object;
    }

    private String createIncrementalRequestId(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getSessionMap();
        AtomicInteger atomicInteger = (AtomicInteger)map.get(STATEMANAGED_SERIAL_ID_KEY);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(1);
        }
        map.put(STATEMANAGED_SERIAL_ID_KEY, atomicInteger);
        return "j_id" + atomicInteger.getAndIncrement();
    }

    private String createRandomId() {
        return Long.valueOf(this.random.nextLong()).toString();
    }

    public boolean isStateless(FacesContext facesContext, String string) throws IllegalStateException {
        if (facesContext.isPostback()) {
            Object object = this.getState(facesContext, string);
            return object instanceof String && "stateless".equals((String)object);
        }
        throw new IllegalStateException("Cannot determine whether or not the request is stateless");
    }
}

