/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.HtmlUtils;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlResponseWriter
extends ResponseWriter {
    private String contentType = "text/html";
    private String encoding = null;
    private Writer writer = null;
    private boolean closeStart;
    private WebConfiguration.DisableUnicodeEscaping disableUnicodeEscaping;
    private boolean escapeUnicode;
    private boolean escapeIso;
    private boolean dontEscape;
    private boolean writingCdata;
    private boolean isCdata;
    private boolean isScript;
    private boolean isStyle;
    private boolean withinScript;
    private boolean withinStyle;
    private boolean scriptOrStyleSrc;
    private boolean isPartial;
    private boolean isXhtml;
    private Writer origWriter;
    private FastStringWriter scriptBuffer;
    private FastStringWriter attributesBuffer;
    private Boolean isScriptHidingEnabled;
    private Boolean isScriptInAttributeValueEnabled;
    private char[] buffer = new char[1028];
    private static final int cdataBufferSize = 1024;
    private char[] cdataBuffer = new char[1024];
    private int cdataBufferLength = 0;
    private static final int cdataTextBufferSize = 128;
    private char[] cdataTextBuffer = new char[128];
    private Map<String, Object> passthroughAttributes;
    private char[] textBuffer = new char[128];
    private char[] charHolder = new char[1];
    private LinkedList<String> elementNames;
    private static final String BREAKCDATA = "]]><![CDATA[";
    private static final char[] ESCAPEDSINGLEBRACKET = "]]]><![CDATA[".toCharArray();
    private static final char[] ESCAPEDLT = "&lt;]]><![CDATA[".toCharArray();
    private static final char[] ESCAPEDSTART = "&lt;]]><![CDATA[![".toCharArray();
    private static final char[] ESCAPEDEND = "]]]><![CDATA[]>".toCharArray();
    private static final int CLOSEBRACKET = 93;
    private static final int LT = 60;
    static final Pattern CDATA_START_SLASH_SLASH = Pattern.compile("^//\\s*\\Q<![CDATA[\\E");
    static final Pattern CDATA_END_SLASH_SLASH = Pattern.compile("//\\s*\\Q]]>\\E$");
    static final Pattern CDATA_START_SLASH_STAR = Pattern.compile("^/\\*\\s*\\Q<![CDATA[\\E\\s*\\*/");
    static final Pattern CDATA_END_SLASH_STAR = Pattern.compile("/\\*\\s*\\Q]]>\\E\\s*\\*/$");

    public HtmlResponseWriter(Writer writer, String string, String string2) throws FacesException {
        this(writer, string, string2, null, null, null, false);
    }

    public HtmlResponseWriter(Writer writer, String string, String string2, Boolean bl, Boolean bl2, WebConfiguration.DisableUnicodeEscaping disableUnicodeEscaping, boolean bl3) throws FacesException {
        this.writer = writer;
        if (null != string) {
            this.contentType = string;
        }
        this.encoding = string2;
        WebConfiguration webConfiguration = null;
        if (bl == null) {
            bl = null == (webConfiguration = this.getWebConfiguration(webConfiguration)) ? WebConfiguration.BooleanWebContextInitParameter.EnableJSStyleHiding.getDefaultValue() : webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableJSStyleHiding);
        }
        if (bl2 == null) {
            bl2 = null == (webConfiguration = this.getWebConfiguration(webConfiguration)) ? WebConfiguration.BooleanWebContextInitParameter.EnableScriptInAttributeValue.getDefaultValue() : webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableScriptInAttributeValue);
        }
        if (disableUnicodeEscaping == null && (disableUnicodeEscaping = WebConfiguration.DisableUnicodeEscaping.getByValue(null == (webConfiguration = this.getWebConfiguration(webConfiguration)) ? WebConfiguration.WebContextInitParameter.DisableUnicodeEscaping.getDefaultValue() : webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.DisableUnicodeEscaping))) == null) {
            disableUnicodeEscaping = WebConfiguration.DisableUnicodeEscaping.False;
        }
        this.isPartial = bl3;
        this.isScriptHidingEnabled = bl;
        this.isScriptInAttributeValueEnabled = bl2;
        this.disableUnicodeEscaping = disableUnicodeEscaping;
        this.attributesBuffer = new FastStringWriter(128);
        if (!HtmlUtils.validateEncoding(string2)) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.ENCODING_ERROR", new Object[0]));
        }
        String string3 = string2.toUpperCase();
        switch (disableUnicodeEscaping) {
            case True: {
                this.escapeUnicode = false;
                this.escapeIso = false;
                break;
            }
            case False: {
                this.escapeUnicode = true;
                this.escapeIso = true;
                break;
            }
            case Auto: {
                this.escapeUnicode = !HtmlUtils.isUTFencoding(string3);
                this.escapeIso = !HtmlUtils.isISO8859_1encoding(string3) && !HtmlUtils.isUTFencoding(string3);
            }
        }
    }

    private WebConfiguration getWebConfiguration(WebConfiguration webConfiguration) {
        ExternalContext externalContext;
        if (webConfiguration != null) {
            return webConfiguration;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext && null != (externalContext = facesContext.getExternalContext())) {
            webConfiguration = WebConfiguration.getInstance(externalContext);
        }
        return webConfiguration;
    }

    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.closeStartIfNecessary();
    }

    public String getContentType() {
        return this.contentType;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        try {
            HtmlResponseWriter htmlResponseWriter = new HtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding(), this.isScriptHidingEnabled, this.isScriptInAttributeValueEnabled, this.disableUnicodeEscaping, this.isPartial);
            htmlResponseWriter.dontEscape = this.dontEscape;
            htmlResponseWriter.writingCdata = this.writingCdata;
            return htmlResponseWriter;
        }
        catch (FacesException facesException) {
            throw new IllegalStateException();
        }
    }

    public void endDocument() throws IOException {
        this.writer.flush();
    }

    public void endElement(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if ("script".equalsIgnoreCase(string)) {
            this.withinScript = false;
        }
        if ("style".equalsIgnoreCase(string)) {
            this.withinStyle = false;
        }
        if (!this.withinScript && !this.withinStyle) {
            this.dontEscape = false;
        }
        this.isXhtml = this.getContentType().equals("application/xhtml+xml");
        if (this.isScriptOrStyle(string) && !this.scriptOrStyleSrc && this.writer instanceof FastStringWriter) {
            String string2 = ((FastStringWriter)this.writer).getBuffer().toString();
            this.writer = this.origWriter;
            if (string2 != null) {
                String string3 = string2.trim();
                if (this.isXhtml) {
                    if (this.isScript) {
                        Matcher matcher = CDATA_START_SLASH_SLASH.matcher(string3);
                        Matcher matcher2 = CDATA_END_SLASH_SLASH.matcher(string3);
                        Matcher matcher3 = CDATA_START_SLASH_STAR.matcher(string3);
                        Matcher matcher4 = CDATA_END_SLASH_STAR.matcher(string3);
                        int n = string3.length();
                        if (matcher.find() && matcher2.find()) {
                            int n2 = matcher.end() - matcher.start();
                            int n3 = n - (matcher2.end() - matcher2.start());
                            this.writer.write(string3.substring(n2, n3));
                        } else if (null != matcher.reset() && matcher.find() && matcher4.find()) {
                            int n4 = matcher.end() - matcher.start();
                            int n5 = n - (matcher4.end() - matcher4.start());
                            this.writer.write(string3.substring(n4, n5));
                        } else if (matcher3.find() && null != matcher4.reset() && matcher4.find()) {
                            int n6 = matcher3.end() - matcher3.start();
                            int n7 = n - (matcher4.end() - matcher4.start());
                            this.writer.write(string3.substring(n6, n7));
                        } else if (null != matcher3.reset() && matcher3.find() && null != matcher4.reset() && matcher2.find()) {
                            int n8 = matcher3.end() - matcher3.start();
                            int n9 = n - (matcher2.end() - matcher2.start());
                            this.writer.write(string3.substring(n8, n9));
                        } else {
                            this.writer.write(string2);
                        }
                    } else if (string3.startsWith("<![CDATA[") && string3.endsWith("]]>")) {
                        this.writer.write(string3.substring(9, string3.length() - 3));
                    } else {
                        this.writer.write(string2);
                    }
                } else if (string3.startsWith("<!--") && string3.endsWith("//-->")) {
                    this.writer.write(string3.substring(4, string3.length() - 5));
                } else {
                    this.writer.write(string2);
                }
            }
            if (this.isXhtml) {
                if (!this.writingCdata) {
                    if (this.isScript) {
                        this.writer.write("\n//]]>\n");
                    } else {
                        this.writer.write("\n]]>\n");
                    }
                }
            } else if (this.isScriptHidingEnabled.booleanValue()) {
                this.writer.write("\n//-->\n");
            }
        }
        this.isScript = false;
        this.isStyle = false;
        this.dontEscape = false;
        if ("cdata".equalsIgnoreCase(string)) {
            this.endCDATA();
            return;
        }
        if (this.closeStart) {
            boolean bl = HtmlUtils.isEmptyElement(string);
            if (bl) {
                this.flushAttributes();
                this.writer.write(" />");
                this.closeStart = false;
                this.popElementName(string);
                return;
            }
            this.flushAttributes();
            this.writer.write(62);
            this.closeStart = false;
        }
        this.writer.write("</");
        this.writer.write(this.popElementName(string));
        this.writer.write(62);
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
    }

    public void startElement(String string, UIComponent uIComponent) throws IOException {
        Object object;
        if (string == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if ("script".equalsIgnoreCase(string)) {
            this.withinScript = true;
        }
        if ("style".equalsIgnoreCase(string)) {
            this.withinStyle = true;
        }
        this.closeStartIfNecessary();
        this.isScriptOrStyle(string);
        this.scriptOrStyleSrc = false;
        if ("cdata".equalsIgnoreCase(string)) {
            this.isCdata = true;
            this.startCDATA();
            return;
        }
        if (this.writingCdata) {
            this.isCdata = false;
            this.writingCdata = true;
        }
        if (null != uIComponent && null != (object = uIComponent.getPassThroughAttributes(false)) && !object.isEmpty()) {
            this.considerPassThroughAttributes((Map<String, Object>)object);
        }
        this.writer.write(60);
        object = this.pushElementName(string);
        this.writer.write((String)object);
        this.closeStart = true;
    }

    public void startCDATA() throws IOException {
        if (this.writingCdata) {
            throw new IllegalStateException("CDATA tags may not nest");
        }
        this.closeStartIfNecessary();
        this.writingCdata = true;
        this.writer.write("<![CDATA[");
        this.closeStart = false;
    }

    public void endCDATA() throws IOException {
        this.closeStartIfNecessary();
        this.writer.write("]]>");
        this.writingCdata = false;
    }

    public void write(char[] cArray) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cArray);
    }

    public void write(int n) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(n);
    }

    public void write(String string) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(string);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cArray, n, n2);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(string, n, n2);
    }

    public void writeAttribute(String string, Object object, String string2) throws IOException {
        Class<?> clazz;
        if (string == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if (object == null) {
            return;
        }
        if (this.isCdata) {
            return;
        }
        if (this.containsPassThroughAttribute(string)) {
            return;
        }
        if (string.equalsIgnoreCase("src") && this.isScriptOrStyle()) {
            this.scriptOrStyleSrc = true;
        }
        if ((clazz = object.getClass()) == Boolean.class) {
            if (Boolean.TRUE.equals(object)) {
                this.attributesBuffer.write(32);
                this.attributesBuffer.write(string);
                this.attributesBuffer.write("=\"");
                this.attributesBuffer.write(string);
                this.attributesBuffer.write(34);
            }
        } else {
            this.attributesBuffer.write(32);
            this.attributesBuffer.write(string);
            this.attributesBuffer.write("=\"");
            String string3 = object.toString();
            this.ensureTextBufferCapacity(string3);
            HtmlUtils.writeAttribute(this.attributesBuffer, this.escapeUnicode, this.escapeIso, this.buffer, string3, this.textBuffer, this.isScriptInAttributeValueEnabled);
            this.attributesBuffer.write(34);
        }
    }

    public void writeComment(Object object) throws IOException {
        if (object == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (this.writingCdata) {
            return;
        }
        this.closeStartIfNecessary();
        this.writer.write("<!--");
        String string = object.toString();
        this.ensureTextBufferCapacity(string);
        HtmlUtils.writeText(this.writer, true, true, this.buffer, string, this.textBuffer);
        this.writer.write("-->");
    }

    public void writeText(char c) throws IOException {
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(c);
        } else if (this.isPartial || !this.writingCdata) {
            this.charHolder[0] = c;
            HtmlUtils.writeText(this.writer, this.escapeUnicode, this.escapeIso, this.buffer, this.charHolder);
        } else {
            assert (this.writingCdata);
            this.charHolder[0] = c;
            this.writeEscaped(this.charHolder, 0, 1);
        }
    }

    public void writeText(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(cArray);
        } else if (this.isPartial || !this.writingCdata) {
            HtmlUtils.writeText(this.writer, this.escapeUnicode, this.escapeIso, this.buffer, cArray);
        } else {
            assert (this.writingCdata);
            this.writeEscaped(cArray, 0, cArray.length);
        }
    }

    public void writeText(Object object, String string) throws IOException {
        if (object == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        this.closeStartIfNecessary();
        String string2 = object.toString();
        if (this.dontEscape) {
            this.writer.write(string2);
        } else if (this.isPartial || !this.writingCdata) {
            this.ensureTextBufferCapacity(string2);
            HtmlUtils.writeText(this.writer, this.escapeUnicode, this.escapeIso, this.buffer, string2, this.textBuffer);
        } else {
            assert (this.writingCdata);
            int n = string2.length();
            if (n > 128) {
                this.writeEscaped(string2.toCharArray(), 0, n);
            } else if (n >= 16) {
                string2.getChars(0, n, this.cdataTextBuffer, 0);
                this.writeEscaped(this.cdataTextBuffer, 0, n);
            } else {
                for (int i = 0; i < n; ++i) {
                    this.cdataTextBuffer[i] = string2.charAt(i);
                }
                this.writeEscaped(this.cdataTextBuffer, 0, n);
            }
        }
    }

    public void writeText(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "text"));
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.closeStartIfNecessary();
        if (n2 == 0) {
            return;
        }
        if (this.dontEscape) {
            this.writer.write(cArray, n, n2);
        } else if (this.isPartial || !this.writingCdata) {
            HtmlUtils.writeText(this.writer, this.escapeUnicode, this.escapeIso, this.buffer, cArray, n, n2);
        } else {
            assert (this.writingCdata);
            this.writeEscaped(cArray, n, n2);
        }
    }

    public void writeURIAttribute(String string, Object object, String string2) throws IOException {
        if (null != string && this.containsPassThroughAttribute(string)) {
            return;
        }
        this.writeURIAttributeIgnoringPassThroughAttributes(string, object, string2, false);
    }

    private void writeURIAttributeIgnoringPassThroughAttributes(String string, Object object, String string2, boolean bl) throws IOException {
        if (string == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "name"));
        }
        if (object == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "value"));
        }
        if (this.isCdata) {
            return;
        }
        if (string.equals("elementName")) {
            return;
        }
        if (string.equalsIgnoreCase("src") && this.isScriptOrStyle()) {
            this.scriptOrStyleSrc = true;
        }
        this.attributesBuffer.write(32);
        this.attributesBuffer.write(string);
        this.attributesBuffer.write("=\"");
        String string3 = object.toString();
        this.ensureTextBufferCapacity(string3);
        if (string3.startsWith("javascript:") || bl) {
            HtmlUtils.writeAttribute(this.attributesBuffer, this.escapeUnicode, this.escapeIso, this.buffer, string3, this.textBuffer, this.isScriptInAttributeValueEnabled);
        } else {
            HtmlUtils.writeURL(this.attributesBuffer, string3, this.textBuffer, this.encoding);
        }
        this.attributesBuffer.write(34);
    }

    private void ensureTextBufferCapacity(String string) {
        int n = string.length();
        if (this.textBuffer.length < n) {
            this.textBuffer = new char[n * 2];
        }
        if (this.buffer.length < n) {
            this.buffer = new char[n * 2];
        }
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.flushAttributes();
            this.writer.write(62);
            this.closeStart = false;
            if (this.isScriptOrStyle() && !this.scriptOrStyleSrc) {
                this.isXhtml = this.getContentType().equals("application/xhtml+xml");
                if (this.isXhtml) {
                    if (!this.writingCdata) {
                        if (this.isScript) {
                            this.writer.write("\n//<![CDATA[\n");
                        } else {
                            this.writer.write("\n<![CDATA[\n");
                        }
                    }
                } else if (this.isScriptHidingEnabled.booleanValue()) {
                    this.writer.write("\n<!--\n");
                }
                this.origWriter = this.writer;
                if (this.scriptBuffer == null) {
                    this.scriptBuffer = new FastStringWriter(1024);
                }
                this.scriptBuffer.reset();
                this.writer = this.scriptBuffer;
                this.isScript = false;
                this.isStyle = false;
            }
        }
    }

    private void considerPassThroughAttributes(Map<String, Object> map) {
        assert (null != map && !map.isEmpty());
        if (null != this.passthroughAttributes) {
            throw new IllegalStateException("Error, this method should only be called once per instance.");
        }
        this.passthroughAttributes = new ConcurrentHashMap<String, Object>(map);
    }

    private boolean containsPassThroughAttribute(String string) {
        boolean bl = false;
        if (null != this.passthroughAttributes) {
            bl = this.passthroughAttributes.containsKey(string);
        }
        return bl;
    }

    private void flushAttributes() throws IOException {
        int n;
        Object object;
        boolean bl;
        boolean bl2 = bl = null != this.passthroughAttributes && !this.passthroughAttributes.isEmpty();
        if (bl) {
            object = FacesContext.getCurrentInstance();
            for (Map.Entry<String, Object> entry : this.passthroughAttributes.entrySet()) {
                Object object2 = entry.getValue();
                String string = this.getAttributeValue((FacesContext)object, object2);
                String string2 = entry.getKey();
                if (string == null) continue;
                this.writeURIAttributeIgnoringPassThroughAttributes(string2, string, string2, true);
            }
        }
        if ((n = ((StringBuilder)(object = this.attributesBuffer.getBuffer())).length()) != 0) {
            int n2 = 0;
            while (n2 < n) {
                int n3;
                if (n - n2 > this.buffer.length) {
                    n3 = n2 + this.buffer.length;
                    ((StringBuilder)object).getChars(n2, n3, this.buffer, 0);
                    this.writer.write(this.buffer);
                    n2 += this.buffer.length;
                    continue;
                }
                n3 = n - n2;
                ((StringBuilder)object).getChars(n2, n2 + n3, this.buffer, 0);
                this.writer.write(this.buffer, 0, n3);
                n2 += n3;
            }
            this.attributesBuffer.reset();
        }
        if (bl) {
            this.passthroughAttributes.clear();
            this.passthroughAttributes = null;
        }
    }

    private String getAttributeValue(FacesContext facesContext, Object object) {
        Object object2;
        String string = object instanceof ValueExpression ? ((object2 = ((ValueExpression)object).getValue(facesContext.getELContext())) != null ? object2.toString() : null) : object.toString();
        return string;
    }

    private String pushElementName(String string) {
        if (string.equals("option")) {
            return string;
        }
        String string2 = this.getElementName(string);
        if (this.passthroughAttributes != null) {
            this.passthroughAttributes.remove("elementName");
            if (this.passthroughAttributes.isEmpty()) {
                this.passthroughAttributes = null;
            }
        }
        if (!string.equals(string2) || this.elementNames != null) {
            if (this.elementNames == null) {
                this.elementNames = new LinkedList();
            }
            this.elementNames.push(string2);
        }
        return string2;
    }

    private String popElementName(String string) {
        if (this.elementNames == null || this.elementNames.isEmpty()) {
            return string;
        }
        return this.elementNames.pop();
    }

    private String getElementName(String string) {
        FacesContext facesContext;
        String string2;
        if (this.containsPassThroughAttribute("elementName") && (string2 = this.getAttributeValue(facesContext = FacesContext.getCurrentInstance(), this.passthroughAttributes.get("elementName"))) != null && string2.trim().length() > 0) {
            return string2;
        }
        return string;
    }

    private boolean isScriptOrStyle(String string) {
        if ("script".equalsIgnoreCase(string)) {
            this.isScript = true;
            this.dontEscape = true;
        } else if ("style".equalsIgnoreCase(string)) {
            this.isStyle = true;
            this.dontEscape = true;
        } else {
            this.isScript = false;
            this.isStyle = false;
            if (!this.withinScript && !this.withinStyle) {
                this.dontEscape = false;
            }
        }
        return this.isScript || this.isStyle;
    }

    private boolean isScriptOrStyle() {
        return this.isScript || this.isStyle;
    }

    private void writeEscaped(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null || cArray.length == 0 || n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > cbuf.length");
        }
        if (n2 == 1) {
            if (cArray[n] == '<') {
                this.appendBuffer(ESCAPEDLT);
            } else if (cArray[n] == ']') {
                this.appendBuffer(ESCAPEDSINGLEBRACKET);
            } else {
                this.appendBuffer(cArray[n]);
            }
            this.flushBuffer();
            return;
        }
        if (n2 == 2) {
            if (cArray[n] == '<' && cArray[n + 1] == '!') {
                this.appendBuffer(ESCAPEDLT);
                this.appendBuffer(cArray[n + 1]);
            } else if (cArray[n] == ']' && cArray[n + 1] == ']') {
                this.appendBuffer(ESCAPEDSINGLEBRACKET);
                this.appendBuffer(ESCAPEDSINGLEBRACKET);
            } else {
                this.appendBuffer(cArray[n]);
                this.appendBuffer(cArray[n + 1]);
            }
            this.flushBuffer();
            return;
        }
        boolean bl = false;
        for (int i = n; i < n2 - 2; ++i) {
            if (cArray[i] == '<' && cArray[i + 1] == '!' && cArray[i + 2] == '[') {
                this.appendBuffer(ESCAPEDSTART);
                i += 2;
            } else if (cArray[i] == ']' && cArray[i + 1] == ']' && cArray[i + 2] == '>') {
                this.appendBuffer(ESCAPEDEND);
                i += 2;
            } else {
                this.appendBuffer(cArray[i]);
            }
            if (i != n + n2 - 1) continue;
            bl = true;
        }
        if (!bl) {
            if (cArray[n + n2 - 2] == '<') {
                this.appendBuffer(ESCAPEDLT);
            } else if (cArray[n + n2 - 2] == ']') {
                this.appendBuffer(ESCAPEDSINGLEBRACKET);
            } else {
                this.appendBuffer(cArray[n + n2 - 2]);
            }
            if (cArray[n + n2 - 1] == '<') {
                this.appendBuffer(ESCAPEDLT);
            } else if (cArray[n + n2 - 1] == ']') {
                this.appendBuffer(ESCAPEDSINGLEBRACKET);
            } else {
                this.appendBuffer(cArray[n + n2 - 1]);
            }
        }
        this.flushBuffer();
    }

    private void appendBuffer(char[] cArray) throws IOException {
        if (cArray.length + this.cdataBufferLength >= 1024) {
            this.flushBuffer();
        }
        if (cArray.length >= 1024) {
            this.writer.write(cArray);
        }
        System.arraycopy(cArray, 0, this.cdataBuffer, this.cdataBufferLength, cArray.length);
        this.cdataBufferLength += cArray.length;
    }

    private void appendBuffer(char c) throws IOException {
        if (this.cdataBufferLength + 1 >= 1024) {
            this.flushBuffer();
        }
        this.cdataBuffer[this.cdataBufferLength] = c;
        ++this.cdataBufferLength;
    }

    private void flushBuffer() throws IOException {
        if (this.cdataBufferLength == 0) {
            return;
        }
        this.writer.write(this.cdataBuffer, 0, this.cdataBufferLength);
        this.cdataBufferLength = 0;
    }
}

