/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting.groovy;

import com.sun.faces.scripting.ScriptManager;
import com.sun.faces.util.FacesLogger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptManager
implements ScriptManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String SCRIPT_PATH = "/WEB-INF/groovy/";
    private static final String SUFFIX = ".groovy";
    private ServletContext servletContext;
    public static final Set<String> FACES_ANNOTATIONS;

    public GroovyScriptManager(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Set<String> getScripts() {
        HashSet<String> hashSet = new HashSet<String>();
        this.processWebInfGroovy(this.servletContext, this.servletContext.getResourcePaths(SCRIPT_PATH), hashSet);
        return hashSet;
    }

    private void processWebInfGroovy(ServletContext servletContext, Set<String> set, Set<String> set2) {
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                if (string.endsWith("/")) {
                    this.processWebInfGroovy(servletContext, servletContext.getResourcePaths(string), set2);
                    continue;
                }
                if (!string.endsWith(SUFFIX)) continue;
                String string2 = this.convertToClassName(SCRIPT_PATH, string);
                if (!this.containsAnnotation(servletContext, string)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[WEB-INF/groovy] Found annotated Class: {0}", string2);
                }
                set2.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAnnotation(ServletContext servletContext, String string) {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            URL uRL = servletContext.getResource(string);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));
            String string2 = bufferedReader.readLine();
            while (string2 != null && !bl) {
                if ((string2 = string2.trim()).length() != 0) {
                    for (String string3 : FACES_ANNOTATIONS) {
                        if (string2.indexOf(string3) <= -1) continue;
                        bl = true;
                        break;
                    }
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, null, exception);
            }
        }
        finally {
            block17: {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block17;
                        LOGGER.log(Level.FINEST, "Closing stream", exception);
                    }
                }
            }
        }
        return bl;
    }

    private String convertToClassName(String string, String string2) {
        String string3 = string2;
        if (string != null) {
            string3 = string3.substring(string.length());
        }
        string3 = string3.substring(0, string3.length() - 7);
        return string3.replace('/', '.');
    }

    static {
        HashSet hashSet = new HashSet(15, 1.0f);
        Collections.addAll(hashSet, "javax.faces.component.FacesComponent", "javax.faces.component.*", "javax.faces.convert.FacesConverter", "javax.faces.convert.*", "javax.faces.validator.FacesValidator", "javax.faces.validator.*", "javax.faces.render.FacesRenderer", "javax.faces.render.*", "javax.faces.bean.ManagedBean", "javax.faces.bean.*", "javax.faces.event.NamedEvent", "javax.faces.event.*", "javax.faces.component.behavior.FacesBehavior", "javax.faces.component.behavior.*", "javax.faces.render.FacesBehaviorRenderer");
        FACES_ANNOTATIONS = Collections.unmodifiableSet(hashSet);
    }
}

