/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.spi.FaceletConfigResourceProvider;
import com.sun.faces.spi.FacesConfigResourceProvider;
import com.sun.faces.spi.ServiceFactoryUtils;
import java.util.ArrayList;

public class ConfigurationResourceProviderFactory {
    public static ConfigurationResourceProvider[] createProviders(ProviderType providerType) {
        String[] serviceEntries = ServiceFactoryUtils.getServiceEntries(providerType.servicesKey);
        ArrayList<ConfigurationResourceProvider> providers = new ArrayList<ConfigurationResourceProvider>();
        if (serviceEntries.length > 0) {
            for (String serviceEntry : serviceEntries) {
                try {
                    ConfigurationResourceProvider provider = (ConfigurationResourceProvider)ServiceFactoryUtils.getProviderFromEntry(serviceEntry, null, null);
                    if (provider == null) continue;
                    if (ProviderType.FacesConfig == providerType) {
                        if (!(provider instanceof FacesConfigResourceProvider)) {
                            throw new IllegalStateException("Expected ConfigurationResourceProvider type to be an instance of FacesConfigResourceProvider");
                        }
                    } else if (!(provider instanceof FaceletConfigResourceProvider)) {
                        throw new IllegalStateException("Expected ConfigurationResourceProvider type to be an instance of FaceletConfigResourceProvider");
                    }
                    providers.add(provider);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return providers.toArray(new ConfigurationResourceProvider[providers.size()]);
        }
        return new ConfigurationResourceProvider[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProviderType {
        FacesConfig("com.sun.faces.spi.FacesConfigResourceProvider"),
        FaceletConfig("com.sun.faces.spi.FaceletConfigResourceProvider");

        String servicesKey;

        private ProviderType(String servicesKey) {
            this.servicesKey = servicesKey;
        }
    }
}

