/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ApplicationObjectInputStream;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationProviderFactory {
    private static final SerializationProvider JAVA_PROVIDER = new JavaSerializationProvider();
    private static final String SERIALIZATION_PROVIDER_PROPERTY = "com.sun.faces.SerializationProvider";
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    public static SerializationProvider createInstance(ExternalContext extContext) {
        String providerClass = SerializationProviderFactory.findProviderClass(extContext);
        SerializationProvider provider = SerializationProviderFactory.getProviderInstance(providerClass);
        if (provider.getClass() != JavaSerializationProvider.class && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.spi.serialization.provider_configured", new Object[]{provider.getClass().getName()});
        }
        return provider;
    }

    private static SerializationProvider getProviderInstance(String className) {
        SerializationProvider provider;
        block10: {
            provider = JAVA_PROVIDER;
            if (className != null) {
                try {
                    Class clazz = Util.loadClass(className, SerializationProviderFactory.class);
                    if (SerializationProviderFactory.implementsSerializationProvider(clazz)) {
                        provider = (SerializationProvider)clazz.newInstance();
                    } else if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.serialization.provider_not_implemented", new Object[]{className});
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.serialization.provider_not_found", new Object[]{className});
                    }
                }
                catch (InstantiationException ie) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.serialization.provider_cannot_instantiate", new Object[]{className});
                        LOGGER.log(Level.SEVERE, "", ie);
                    }
                }
                catch (IllegalAccessException iae) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                    LOGGER.log(Level.SEVERE, "jsf.spi.serialization.provider_cannot_instantiate", new Object[]{className});
                    LOGGER.log(Level.SEVERE, "", iae);
                }
            }
        }
        return provider;
    }

    private static boolean implementsSerializationProvider(Class<?> clazz) {
        return SerializationProvider.class.isAssignableFrom(clazz);
    }

    private static String findProviderClass(ExternalContext extContext) {
        WebConfiguration webConfig = WebConfiguration.getInstance(extContext);
        String provider = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.SerializationProviderClass);
        if (provider != null) {
            return provider;
        }
        return System.getProperty(SERIALIZATION_PROVIDER_PROPERTY);
    }

    private static final class JavaSerializationProvider
    implements SerializationProvider {
        private JavaSerializationProvider() {
        }

        public ObjectOutputStream createObjectOutputStream(OutputStream destination) throws IOException {
            return new ObjectOutputStream(destination);
        }

        public ObjectInputStream createObjectInputStream(InputStream source) throws IOException {
            return new ApplicationObjectInputStream(source);
        }
    }
}

