/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class WebappResourceHelper
extends ResourceHelper {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private String BASE_RESOURCE_PATH;
    private String BASE_CONTRACTS_PATH;
    private boolean cacheTimestamp;

    public WebappResourceHelper() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        this.cacheTimestamp = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
        this.BASE_RESOURCE_PATH = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppResourcesDirectory);
        this.BASE_CONTRACTS_PATH = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WebappResourceHelper webappResourceHelper = (WebappResourceHelper)object;
        if (this.BASE_RESOURCE_PATH == null ? webappResourceHelper.BASE_RESOURCE_PATH != null : !this.BASE_RESOURCE_PATH.equals(webappResourceHelper.BASE_RESOURCE_PATH)) {
            return false;
        }
        if (this.BASE_CONTRACTS_PATH == null ? webappResourceHelper.BASE_CONTRACTS_PATH != null : !this.BASE_CONTRACTS_PATH.equals(webappResourceHelper.BASE_CONTRACTS_PATH)) {
            return false;
        }
        return this.cacheTimestamp == webappResourceHelper.cacheTimestamp;
    }

    public int hashCode() {
        int n = 5;
        n = 37 * n + (this.BASE_RESOURCE_PATH != null ? this.BASE_RESOURCE_PATH.hashCode() : 0);
        n = 37 * n + (this.BASE_CONTRACTS_PATH != null ? this.BASE_CONTRACTS_PATH.hashCode() : 0);
        n = 37 * n + (this.cacheTimestamp ? 1 : 0);
        return n;
    }

    public String getBaseResourcePath() {
        return this.BASE_RESOURCE_PATH;
    }

    public String getBaseContractsPath() {
        return this.BASE_CONTRACTS_PATH;
    }

    protected InputStream getNonCompressedInputStream(ResourceInfo resourceInfo, FacesContext facesContext) throws IOException {
        return facesContext.getExternalContext().getResourceAsStream(resourceInfo.getPath());
    }

    public URL getURL(ResourceInfo resourceInfo, FacesContext facesContext) {
        try {
            return facesContext.getExternalContext().getResource(resourceInfo.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public LibraryInfo findLibrary(String string, String string2, String string3, FacesContext facesContext) {
        String string4 = string2 == null ? this.getBasePath(string3) + '/' + string : this.getBasePath(string3) + '/' + string2 + '/' + string;
        Set set = facesContext.getExternalContext().getResourcePaths(string4);
        if (set != null && !set.isEmpty()) {
            VersionInfo versionInfo = this.getVersion(set, false);
            return new LibraryInfo(string, versionInfo, string2, string3, this);
        }
        return null;
    }

    public ResourceInfo findResource(LibraryInfo libraryInfo, String string, String string2, boolean bl, FacesContext facesContext) {
        ClientResourceInfo clientResourceInfo;
        Set set;
        ContractInfo[] contractInfoArray;
        String string3 = this.findPathConsideringContracts(libraryInfo, string = this.trimLeadingSlash(string), string2, contractInfoArray = new ContractInfo[]{null}, facesContext);
        if (null == string3) {
            string3 = libraryInfo != null ? libraryInfo.getPath(string2) + '/' + string : (string2 == null ? this.getBaseResourcePath() + '/' + string : this.getBaseResourcePath() + '/' + string2 + '/' + string);
            try {
                if (facesContext.getExternalContext().getResource(string3) == null) {
                    return null;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new FacesException((Throwable)malformedURLException);
            }
        }
        if ((set = facesContext.getExternalContext().getResourcePaths(string3)) == null || set.size() == 0) {
            clientResourceInfo = libraryInfo != null ? new ClientResourceInfo(libraryInfo, contractInfoArray[0], string, null, bl, this.resourceSupportsEL(string, libraryInfo.getName(), facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(contractInfoArray[0], string, null, string2, this, bl, this.resourceSupportsEL(string, null, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        } else {
            VersionInfo versionInfo = this.getVersion(set, true);
            if (versionInfo == null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_determine_resource_version.", string);
            }
            clientResourceInfo = libraryInfo != null ? new ClientResourceInfo(libraryInfo, contractInfoArray[0], string, versionInfo, bl, this.resourceSupportsEL(string, libraryInfo.getName(), facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(contractInfoArray[0], string, versionInfo, string2, this, bl, this.resourceSupportsEL(string, null, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        }
        if (clientResourceInfo.isCompressable()) {
            clientResourceInfo = this.handleCompression(clientResourceInfo);
        }
        return clientResourceInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findPathConsideringContracts(LibraryInfo libraryInfo, String string, String string2, ContractInfo[] contractInfoArray, FacesContext facesContext) {
        String string3;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        List<String> list = null;
        if (libraryInfo != null) {
            list = new ArrayList(1);
            list.add(libraryInfo.getContract());
        } else if (uIViewRoot == null) {
            string3 = (String)facesContext.getExternalContext().getRequestParameterMap().get("con");
            if (null == string3 || 0 >= string3.length()) return null;
            list = new ArrayList();
            list.add(string3);
        } else {
            list = facesContext.getResourceLibraryContracts();
        }
        string3 = null;
        for (String string4 : list) {
            string3 = libraryInfo != null ? libraryInfo.getPath(string2) + '/' + string : (string2 == null ? this.getBaseContractsPath() + '/' + string4 + '/' + string : this.getBaseContractsPath() + '/' + string4 + '/' + string2 + '/' + string);
            try {
                if (facesContext.getExternalContext().getResource(string3) != null) {
                    contractInfoArray[0] = new ContractInfo(string4);
                    return string3;
                }
                string3 = null;
            }
            catch (MalformedURLException malformedURLException) {
                throw new FacesException((Throwable)malformedURLException);
            }
        }
        return string3;
    }
}

