/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.compiler.CompilationMessageHolder;
import com.sun.faces.facelets.compiler.CompilationMessageHolderImpl;
import com.sun.faces.facelets.compiler.CompilationUnit;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.compiler.ImplementationUnit;
import com.sun.faces.facelets.compiler.InterfaceUnit;
import com.sun.faces.facelets.compiler.NamespaceManager;
import com.sun.faces.facelets.compiler.NamespaceUnit;
import com.sun.faces.facelets.compiler.RemoveUnit;
import com.sun.faces.facelets.compiler.TagUnit;
import com.sun.faces.facelets.compiler.TextUnit;
import com.sun.faces.facelets.compiler.TrimmedTagUnit;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.util.FacesLogger;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagDecorator;
import javax.faces.view.facelets.TagException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompilationManager {
    private static final Logger log = FacesLogger.FACELETS_COMPILER.getLogger();
    private final Compiler compiler;
    private final TagLibrary tagLibrary;
    private final TagDecorator tagDecorator;
    private final NamespaceManager namespaceManager;
    private final Stack<CompilationUnit> units;
    private int tagId;
    private boolean finished;
    private final String alias;
    private CompilationMessageHolder messageHolder = null;
    private WebConfiguration config;
    private InterfaceUnit interfaceUnit;

    public CompilationManager(String string, Compiler compiler) {
        this.alias = string;
        this.compiler = compiler;
        this.tagDecorator = compiler.createTagDecorator();
        this.tagLibrary = compiler.createTagLibrary(this.getCompilationMessageHolder());
        this.namespaceManager = new NamespaceManager();
        this.tagId = 0;
        this.finished = false;
        this.units = new Stack();
        this.units.push(new CompilationUnit());
        this.config = WebConfiguration.getInstance();
    }

    private InterfaceUnit getInterfaceUnit() {
        return this.interfaceUnit;
    }

    public CompilationMessageHolder getCompilationMessageHolder() {
        if (null == this.messageHolder) {
            this.messageHolder = new CompilationMessageHolderImpl();
        }
        return this.messageHolder;
    }

    public String getAlias() {
        return this.alias;
    }

    public WebConfiguration getWebConfiguration() {
        return this.config;
    }

    public void setCompilationMessageHolder(CompilationMessageHolder compilationMessageHolder) {
        this.messageHolder = compilationMessageHolder;
    }

    private void setInterfaceUnit(InterfaceUnit interfaceUnit) {
        this.interfaceUnit = interfaceUnit;
    }

    public void writeInstruction(String string) {
        TextUnit textUnit;
        if (this.finished) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            textUnit = (TextUnit)this.currentUnit();
        } else {
            textUnit = new TextUnit(this.alias, this.nextTagId());
            this.startUnit(textUnit);
        }
        textUnit.writeInstruction(string);
    }

    public void writeText(String string) {
        TextUnit textUnit;
        if (this.finished) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            textUnit = (TextUnit)this.currentUnit();
        } else {
            textUnit = new TextUnit(this.alias, this.nextTagId());
            this.startUnit(textUnit);
        }
        textUnit.write(string);
    }

    public void writeComment(String string) {
        TextUnit textUnit;
        if (this.compiler.isTrimmingComments()) {
            return;
        }
        if (this.finished) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            textUnit = (TextUnit)this.currentUnit();
        } else {
            textUnit = new TextUnit(this.alias, this.nextTagId());
            this.startUnit(textUnit);
        }
        textUnit.writeComment(string);
    }

    public void writeWhitespace(String string) {
        if (!this.compiler.isTrimmingWhitespace()) {
            this.writeText(string);
        }
    }

    private String nextTagId() {
        return Integer.toHexString(Math.abs(this.alias.hashCode() ^ 13 * this.tagId++));
    }

    public void pushTag(Tag tag) {
        if (this.finished) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Tag Pushed: " + tag);
        }
        Tag tag2 = this.tagDecorator.decorate(tag);
        String[] stringArray = this.determineQName(tag2);
        tag2 = this.trimAttributes(tag2);
        boolean bl = false;
        if (CompilationManager.isTrimmed(stringArray[0], stringArray[1])) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Composition Found, Popping Parent Tags");
            }
            CompilationUnit compilationUnit = this.getViewRootUnitFromStack(this.units);
            this.units.clear();
            NamespaceUnit namespaceUnit = this.namespaceManager.toNamespaceUnit(this.tagLibrary);
            this.units.push(namespaceUnit);
            if (compilationUnit != null) {
                this.currentUnit().addChild(compilationUnit);
            }
            this.startUnit(new TrimmedTagUnit(this.tagLibrary, stringArray[0], stringArray[1], tag2, this.nextTagId()));
            if (log.isLoggable(Level.FINE)) {
                log.fine("New Namespace and [Trimmed] TagUnit pushed");
            }
        } else if (CompilationManager.isImplementation(stringArray[0], stringArray[1])) {
            InterfaceUnit interfaceUnit;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Composite Component Implementation Found, Popping Parent Tags");
            }
            if (null == (interfaceUnit = this.getInterfaceUnit())) {
                throw new TagException(tag, "Unable to find interface for implementation.");
            }
            this.units.clear();
            NamespaceUnit namespaceUnit = this.namespaceManager.toNamespaceUnit(this.tagLibrary);
            this.units.push(namespaceUnit);
            this.currentUnit().addChild(interfaceUnit);
            this.startUnit(new ImplementationUnit(this.tagLibrary, stringArray[0], stringArray[1], tag2, this.nextTagId()));
            if (log.isLoggable(Level.FINE)) {
                log.fine("New Namespace and ImplementationUnit pushed");
            }
        } else if (CompilationManager.isRemove(stringArray[0], stringArray[1])) {
            this.units.push(new RemoveUnit());
        } else if (this.tagLibrary.containsTagHandler(stringArray[0], stringArray[1])) {
            if (CompilationManager.isInterface(stringArray[0], stringArray[1])) {
                InterfaceUnit interfaceUnit = new InterfaceUnit(this.tagLibrary, stringArray[0], stringArray[1], tag2, this.nextTagId());
                this.setInterfaceUnit(interfaceUnit);
                this.startUnit(interfaceUnit);
            } else {
                this.startUnit(new TagUnit(this.tagLibrary, stringArray[0], stringArray[1], tag2, this.nextTagId()));
            }
        } else {
            TextUnit textUnit;
            if (this.tagLibrary.containsNamespace(stringArray[0], tag2)) {
                throw new TagException(tag, "Tag Library supports namespace: " + stringArray[0] + ", but no tag was defined for name: " + stringArray[1]);
            }
            if (this.currentUnit() instanceof TextUnit) {
                textUnit = (TextUnit)this.currentUnit();
            } else {
                textUnit = new TextUnit(this.alias, this.nextTagId());
                this.startUnit(textUnit);
            }
            textUnit.startTag(tag2);
        }
    }

    public void popTag() {
        CompilationUnit compilationUnit;
        if (this.finished) {
            return;
        }
        CompilationUnit compilationUnit2 = this.currentUnit();
        if (compilationUnit2 instanceof TextUnit) {
            compilationUnit = (TextUnit)compilationUnit2;
            if (compilationUnit.isClosed()) {
                this.finishUnit();
            } else {
                compilationUnit.endTag();
                return;
            }
        }
        if ((compilationUnit2 = this.currentUnit()) instanceof TagUnit && (compilationUnit = (TagUnit)compilationUnit2) instanceof TrimmedTagUnit) {
            this.finished = true;
            return;
        }
        this.finishUnit();
    }

    public void popNamespace(String string) {
        this.namespaceManager.popNamespace(string);
        if (this.currentUnit() instanceof NamespaceUnit) {
            this.finishUnit();
        }
    }

    public void pushNamespace(String string, String string2) {
        NamespaceUnit namespaceUnit;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Namespace Pushed " + string + ": " + string2);
        }
        boolean bl = this.namespaceManager.getNamespace(string) != null;
        this.namespaceManager.pushNamespace(string, string2);
        if (this.currentUnit() instanceof NamespaceUnit && !bl) {
            namespaceUnit = (NamespaceUnit)this.currentUnit();
        } else {
            namespaceUnit = new NamespaceUnit(this.tagLibrary);
            this.startUnit(namespaceUnit);
        }
        namespaceUnit.setNamespace(string, string2);
    }

    public FaceletHandler createFaceletHandler() {
        return ((CompilationUnit)this.units.get(0)).createFaceletHandler();
    }

    private CompilationUnit currentUnit() {
        if (!this.units.isEmpty()) {
            return this.units.peek();
        }
        return null;
    }

    private void finishUnit() {
        CompilationUnit compilationUnit = this.units.pop();
        compilationUnit.finishNotify(this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Finished Unit: " + compilationUnit);
        }
    }

    private void startUnit(CompilationUnit compilationUnit) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting Unit: " + compilationUnit + " and adding it to parent: " + this.currentUnit());
        }
        this.currentUnit().addChild(compilationUnit);
        this.units.push(compilationUnit);
        compilationUnit.startNotify(this);
    }

    private Tag trimAttributes(Tag tag) {
        Tag tag2 = this.trimJSFCAttribute(tag);
        tag2 = this.trimNSAttributes(tag2);
        return tag2;
    }

    protected static boolean isRemove(String string, String string2) {
        return ("http://java.sun.com/jsf/facelets".equals(string) || "http://xmlns.jcp.org/jsf/facelets".equals(string)) && "remove".equals(string2);
    }

    protected static boolean isTrimmed(String string, String string2) {
        boolean bl = !(!"http://java.sun.com/jsf/facelets".equals(string) && !"http://xmlns.jcp.org/jsf/facelets".equals(string) || !"composition".equals(string2) && !"component".equals(string2));
        return bl;
    }

    protected static boolean isImplementation(String string, String string2) {
        boolean bl = ("http://java.sun.com/jsf/composite".equals(string) || "http://xmlns.jcp.org/jsf/composite".equals(string)) && "implementation".equals(string2);
        return bl;
    }

    protected static boolean isInterface(String string, String string2) {
        boolean bl = ("http://java.sun.com/jsf/composite".equals(string) || "http://xmlns.jcp.org/jsf/composite".equals(string)) && "interface".equals(string2);
        return bl;
    }

    private String[] determineQName(Tag tag) {
        TagAttribute tagAttribute = tag.getAttributes().get("jsfc");
        if (tagAttribute != null) {
            String string;
            String string2;
            String string3;
            int n;
            if (log.isLoggable(Level.FINE)) {
                log.fine(tagAttribute + " JSF Facelet Compile Directive Found");
            }
            if ((n = (string3 = tagAttribute.getValue()).indexOf(58)) == -1) {
                string2 = this.namespaceManager.getNamespace("");
                string = string3;
            } else {
                String string4 = string3.substring(0, n);
                string2 = this.namespaceManager.getNamespace(string4);
                if (string2 == null) {
                    throw new TagAttributeException(tag, tagAttribute, "No Namespace matched for: " + string4);
                }
                string = string3.substring(n + 1);
            }
            return new String[]{string2, string};
        }
        return new String[]{tag.getNamespace(), tag.getLocalName()};
    }

    private Tag trimJSFCAttribute(Tag tag) {
        TagAttribute tagAttribute = tag.getAttributes().get("jsfc");
        if (tagAttribute != null) {
            TagAttribute[] tagAttributeArray = tag.getAttributes().getAll();
            TagAttribute[] tagAttributeArray2 = new TagAttribute[tagAttributeArray.length - 1];
            int n = 0;
            for (int i = 0; i < tagAttributeArray.length; ++i) {
                if ("jsfc".equals(tagAttributeArray[i].getLocalName())) continue;
                tagAttributeArray2[n++] = tagAttributeArray[i];
            }
            return new Tag(tag, (TagAttributes)new TagAttributesImpl(tagAttributeArray2));
        }
        return tag;
    }

    private Tag trimNSAttributes(Tag tag) {
        TagAttribute[] tagAttributeArray = tag.getAttributes().getAll();
        int n = 0;
        for (int i = 0; i < tagAttributeArray.length; ++i) {
            if (!tagAttributeArray[i].getQName().startsWith("xmlns") || !this.tagLibrary.containsNamespace(tagAttributeArray[i].getValue(), null)) continue;
            n |= 1 << i;
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(tagAttributeArray[i] + " Namespace Bound to TagLibrary");
        }
        if (n == 0) {
            return tag;
        }
        ArrayList<TagAttribute> arrayList = new ArrayList<TagAttribute>(tagAttributeArray.length);
        int n2 = 0;
        for (int i = 0; i < tagAttributeArray.length; ++i) {
            n2 = 1 << i;
            if ((n2 & n) == n2) continue;
            arrayList.add(tagAttributeArray[i]);
        }
        tagAttributeArray = arrayList.toArray(new TagAttribute[arrayList.size()]);
        return new Tag(tag.getLocation(), tag.getNamespace(), tag.getLocalName(), tag.getQName(), (TagAttributes)new TagAttributesImpl(tagAttributeArray));
    }

    private CompilationUnit getViewRootUnitFromStack(Stack<CompilationUnit> stack) {
        TagUnit tagUnit = null;
        for (CompilationUnit compilationUnit : stack) {
            TagUnit tagUnit2;
            String string;
            if (!(compilationUnit instanceof TagUnit) || !(string = (tagUnit2 = (TagUnit)compilationUnit).getTag().getNamespace()).equals("http://java.sun.com/jsf/core") && !string.equals("http://xmlns.jcp.org/jsf/core") || !tagUnit2.getTag().getLocalName().equals("view")) continue;
            tagUnit = tagUnit2;
            break;
        }
        return tagUnit;
    }
}

