/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.facelets.compiler.CompilationMessageHolder;
import com.sun.faces.facelets.tag.CompositeTagDecorator;
import com.sun.faces.facelets.tag.CompositeTagLibrary;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagDecorator;

public abstract class Compiler {
    protected static final Logger log = FacesLogger.FACELETS_COMPILER.getLogger();
    public static final String EXPRESSION_FACTORY = "compiler.ExpressionFactory";
    private static final TagLibrary EMPTY_LIBRARY = new CompositeTagLibrary(new TagLibrary[0]);
    private static final TagDecorator EMPTY_DECORATOR = new CompositeTagDecorator(new TagDecorator[0]);
    private boolean validating = false;
    private boolean trimmingWhitespace = false;
    private boolean trimmingComments = false;
    private final List libraries = new ArrayList();
    private final List decorators = new ArrayList();
    private final Map features = new HashMap();

    public final FaceletHandler compile(URL uRL, String string) throws IOException {
        return this.doCompile(uRL, string);
    }

    public final FaceletHandler metadataCompile(URL uRL, String string) throws IOException {
        return this.doMetadataCompile(uRL, string);
    }

    protected abstract FaceletHandler doMetadataCompile(URL var1, String var2) throws IOException;

    protected abstract FaceletHandler doCompile(URL var1, String var2) throws IOException;

    public final TagDecorator createTagDecorator() {
        if (this.decorators.size() > 0) {
            return new CompositeTagDecorator(this.decorators.toArray(new TagDecorator[this.decorators.size()]));
        }
        return EMPTY_DECORATOR;
    }

    public final void addTagDecorator(TagDecorator tagDecorator) {
        Util.notNull("decorator", tagDecorator);
        if (!this.decorators.contains(tagDecorator)) {
            this.decorators.add(tagDecorator);
        }
    }

    public final ExpressionFactory createExpressionFactory() {
        ExpressionFactory expressionFactory;
        block5: {
            expressionFactory = null;
            expressionFactory = (ExpressionFactory)this.featureInstance(EXPRESSION_FACTORY);
            if (expressionFactory == null) {
                try {
                    expressionFactory = FacesContext.getCurrentInstance().getApplication().getExpressionFactory();
                    if (expressionFactory == null && log.isLoggable(Level.WARNING)) {
                        log.warning("No default ExpressionFactory from Faces Implementation, attempting to load from Feature[compiler.ExpressionFactory]");
                    }
                }
                catch (Exception exception) {
                    if (!log.isLoggable(Level.FINEST)) break block5;
                    log.log(Level.FINEST, "Unable to get ExpressionFactory because of: ", exception);
                }
            }
        }
        if (expressionFactory == null) {
            this.features.put(EXPRESSION_FACTORY, "com.sun.el.ExpressionFactoryImpl");
            expressionFactory = (ExpressionFactory)this.featureInstance(EXPRESSION_FACTORY);
        }
        return expressionFactory;
    }

    private final Object featureInstance(String string) {
        String string2 = (String)this.features.get(string);
        if (string2 != null) {
            try {
                return ReflectionUtil.forName(string2).newInstance();
            }
            catch (Throwable throwable) {
                throw new FaceletException("Could not instantiate feature[" + string + "]: " + string2);
            }
        }
        return null;
    }

    public final TagLibrary createTagLibrary(CompilationMessageHolder compilationMessageHolder) {
        if (this.libraries.size() > 0) {
            return new CompositeTagLibrary(this.libraries.toArray(new TagLibrary[this.libraries.size()]), compilationMessageHolder);
        }
        return EMPTY_LIBRARY;
    }

    public final void addTagLibrary(TagLibrary tagLibrary) {
        Util.notNull("library", tagLibrary);
        if (!this.libraries.contains(tagLibrary)) {
            this.libraries.add(tagLibrary);
        }
    }

    public final void setFeature(String string, String string2) {
        this.features.put(string, string2);
    }

    public final String getFeature(String string) {
        return (String)this.features.get(string);
    }

    public final boolean isTrimmingComments() {
        return this.trimmingComments;
    }

    public final void setTrimmingComments(boolean bl) {
        this.trimmingComments = bl;
    }

    public final boolean isTrimmingWhitespace() {
        return this.trimmingWhitespace;
    }

    public final void setTrimmingWhitespace(boolean bl) {
        this.trimmingWhitespace = bl;
    }

    public final boolean isValidating() {
        return this.validating;
    }

    public final void setValidating(boolean bl) {
        this.validating = bl;
    }
}

