/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.flow.FlowCDIEventFireHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowScoped;
import javax.faces.lifecycle.ClientWindow;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowCDIContext
implements Context,
Serializable {
    private static final long serialVersionUID = -7144653402477623609L;
    private static final String FLOW_SCOPE_MAP_KEY = "com.sun.faces.FLOW_SCOPE_MAP";
    private static final Logger LOGGER = FacesLogger.FLOW.getLogger();
    private transient Map<Contextual<?>, FlowBeanInfo> flowIds;
    private static final String PER_SESSION_BEAN_MAP_LIST = FlowCDIContext.class.getPackage().getName() + ".PER_SESSION_BEAN_MAP_LIST";
    private static final String PER_SESSION_CREATIONAL_LIST = FlowCDIContext.class.getPackage().getName() + ".PER_SESSION_CREATIONAL_LIST";

    FlowCDIContext(Map<Contextual<?>, FlowBeanInfo> map) {
        this.flowIds = new ConcurrentHashMap(map);
    }

    private static void ensureBeanMapCleanupOnSessionDestroyed(Map<String, Object> map, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)map.get(PER_SESSION_BEAN_MAP_LIST);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            map.put(PER_SESSION_BEAN_MAP_LIST, arrayList);
        }
        arrayList.add(string);
    }

    private static void ensureCreationalCleanupOnSessionDestroyed(Map<String, Object> map, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)map.get(PER_SESSION_CREATIONAL_LIST);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            map.put(PER_SESSION_CREATIONAL_LIST, arrayList);
        }
        arrayList.add(string);
    }

    private final void assertNotReleased() {
        if (!this.isActive()) {
            throw new IllegalStateException();
        }
    }

    private Flow getCurrentFlow() {
        Flow flow = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        flow = FlowCDIContext.getCurrentFlow(facesContext);
        return flow;
    }

    private static Flow getCurrentFlow(FacesContext facesContext) {
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        return flow;
    }

    public static void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        Object object;
        Object object2;
        Object object3;
        HttpSession httpSession = httpSessionEvent.getSession();
        List list = (List)httpSession.getAttribute(PER_SESSION_BEAN_MAP_LIST);
        if (null != list) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (Map)httpSession.getAttribute((String)object2);
                object.clear();
                httpSession.removeAttribute((String)object2);
            }
            httpSession.removeAttribute(PER_SESSION_BEAN_MAP_LIST);
            list.clear();
        }
        if (null != (object3 = (List)httpSession.getAttribute(PER_SESSION_CREATIONAL_LIST))) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                Map map = (Map)httpSession.getAttribute((String)object);
                map.clear();
                httpSession.removeAttribute((String)object);
            }
            httpSession.removeAttribute(PER_SESSION_CREATIONAL_LIST);
            object3.clear();
        }
    }

    static Map<Object, Object> getCurrentFlowScopeAndUpdateSession() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper flowScopeMapHelper = new FlowScopeMapHelper(facesContext);
        return FlowCDIContext.getCurrentFlowScopeAndUpdateSession(flowScopeMapHelper);
    }

    private static Map<Object, Object> getCurrentFlowScopeAndUpdateSession(FlowScopeMapHelper flowScopeMapHelper) {
        Map map = flowScopeMapHelper.getFlowScopedBeanMapForCurrentFlow();
        ConcurrentHashMap concurrentHashMap = null;
        if (flowScopeMapHelper.isFlowExists() && null == (concurrentHashMap = (ConcurrentHashMap)map.get(FLOW_SCOPE_MAP_KEY))) {
            concurrentHashMap = new ConcurrentHashMap();
            map.put(FLOW_SCOPE_MAP_KEY, concurrentHashMap);
        }
        flowScopeMapHelper.updateSession();
        return concurrentHashMap;
    }

    static void flowExited() {
        Object object;
        Bean bean;
        String string;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper flowScopeMapHelper = new FlowScopeMapHelper(facesContext);
        Map map = flowScopeMapHelper.getFlowScopedBeanMapForCurrentFlow();
        Map map2 = flowScopeMapHelper.getFlowScopedCreationalMapForCurrentFlow();
        assert (!map.isEmpty());
        assert (!map2.isEmpty());
        ArrayList<String> arrayList = new ArrayList<String>();
        BeanManager beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap());
        for (Map.Entry entry : map.entrySet()) {
            string = (String)entry.getKey();
            if (FLOW_SCOPE_MAP_KEY.equals(string)) continue;
            bean = beanManager.getPassivationCapableBean(string);
            object = entry.getValue();
            CreationalContext creationalContext = (CreationalContext)map2.get(string);
            bean.destroy(object, creationalContext);
            arrayList.add(string);
        }
        for (String string2 : arrayList) {
            map.remove(string2);
            map2.remove(string2);
        }
        flowScopeMapHelper.updateSession();
        if (Util.isCdiOneOneOrGreater()) {
            Set set;
            Object object2;
            block8: {
                object2 = null;
                try {
                    object2 = Class.forName("com.sun.faces.flow.FlowCDIEventFireHelperImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                    LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", classNotFoundException);
                }
            }
            if (null != object2 && null != (set = beanManager.getBeans((Type)object2, new Annotation[0])) && !set.isEmpty()) {
                string = beanManager.resolve(set);
                bean = beanManager.createCreationalContext(null);
                object = (FlowCDIEventFireHelper)beanManager.getReference((Bean)string, (Type)string.getBeanClass(), (CreationalContext)bean);
                object.fireDestroyedEvent(FlowCDIContext.getCurrentFlow(facesContext));
            }
        }
    }

    static void flowEntered() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper flowScopeMapHelper = new FlowScopeMapHelper(facesContext);
        flowScopeMapHelper.createMaps();
        FlowCDIContext.getCurrentFlowScopeAndUpdateSession(flowScopeMapHelper);
        if (Util.isCdiOneOneOrGreater()) {
            BeanManager beanManager;
            Set set;
            Class<?> clazz;
            block4: {
                clazz = null;
                try {
                    clazz = Class.forName("com.sun.faces.flow.FlowCDIEventFireHelperImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", classNotFoundException);
                }
            }
            if (null != clazz && null != (set = (beanManager = (BeanManager)Util.getCDIBeanManager(facesContext.getExternalContext().getApplicationMap())).getBeans(clazz, new Annotation[0])) && !set.isEmpty()) {
                Bean bean = beanManager.resolve(set);
                CreationalContext creationalContext = beanManager.createCreationalContext(null);
                FlowCDIEventFireHelper flowCDIEventFireHelper = (FlowCDIEventFireHelper)beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
                flowCDIEventFireHelper.fireInitializedEvent(FlowCDIContext.getCurrentFlow(facesContext));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        this.assertNotReleased();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FlowScopeMapHelper flowScopeMapHelper = new FlowScopeMapHelper(facesContext);
        Object object = this.get(flowScopeMapHelper, contextual);
        if (null == object) {
            Map map = flowScopeMapHelper.getFlowScopedBeanMapForCurrentFlow();
            Map map2 = flowScopeMapHelper.getFlowScopedCreationalMapForCurrentFlow();
            String string = ((PassivationCapable)contextual).getId();
            Map map3 = map;
            synchronized (map3) {
                object = map.get(string);
                if (null == object) {
                    FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                    if (null == flowHandler) {
                        return null;
                    }
                    FlowBeanInfo flowBeanInfo = this.flowIds.get(contextual);
                    if (!flowHandler.isActive(facesContext, flowBeanInfo.definingDocumentId, flowBeanInfo.id)) {
                        throw new ContextNotActiveException("Request to activate bean in flow '" + flowBeanInfo + "', but that flow is not active.");
                    }
                    object = contextual.create(creationalContext);
                    if (null != object) {
                        map.put(string, object);
                        map2.put(string, creationalContext);
                        flowScopeMapHelper.updateSession();
                    }
                }
            }
        }
        flowScopeMapHelper = null;
        return object;
    }

    public <T> T get(Contextual<T> contextual) {
        this.assertNotReleased();
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("FlowScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        FlowScopeMapHelper flowScopeMapHelper = new FlowScopeMapHelper(FacesContext.getCurrentInstance());
        T t = this.get(flowScopeMapHelper, contextual);
        flowScopeMapHelper = null;
        return t;
    }

    private <T> T get(FlowScopeMapHelper flowScopeMapHelper, Contextual<T> contextual) {
        this.assertNotReleased();
        if (!(contextual instanceof PassivationCapable)) {
            throw new IllegalArgumentException("FlowScoped bean " + contextual.toString() + " must be PassivationCapable, but is not.");
        }
        String string = ((PassivationCapable)contextual).getId();
        return (T)flowScopeMapHelper.getFlowScopedBeanMapForCurrentFlow().get(string);
    }

    public Class<? extends Annotation> getScope() {
        return FlowScoped.class;
    }

    public boolean isActive() {
        return null != this.getCurrentFlow();
    }

    void beforeShutdown(@Observes BeforeShutdown beforeShutdown, BeanManager beanManager) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlowScopeMapHelper {
        private final transient String flowBeansForClientWindowKey;
        private final transient String creationalForClientWindowKey;
        private final transient Map<String, Object> sessionMap;

        private FlowScopeMapHelper(FacesContext facesContext) {
            ExternalContext externalContext = facesContext.getExternalContext();
            this.sessionMap = externalContext.getSessionMap();
            Flow flow = FlowCDIContext.getCurrentFlow(facesContext);
            if (null != flow) {
                ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
                if (null == clientWindow) {
                    throw new IllegalStateException("Unable to obtain current ClientWindow.  Is the ClientWindow feature enabled?");
                }
                String string = flow.getClientWindowFlowId(clientWindow);
                this.flowBeansForClientWindowKey = string + "_beans";
                this.creationalForClientWindowKey = string + "_creational";
            } else {
                this.creationalForClientWindowKey = null;
                this.flowBeansForClientWindowKey = null;
            }
        }

        private void createMaps() {
            this.getFlowScopedBeanMapForCurrentFlow();
            this.getFlowScopedCreationalMapForCurrentFlow();
        }

        private boolean isFlowExists() {
            return null != this.flowBeansForClientWindowKey && null != this.creationalForClientWindowKey;
        }

        public String getCreationalForClientWindowKey() {
            return this.creationalForClientWindowKey;
        }

        public String getFlowBeansForClientWindowKey() {
            return this.flowBeansForClientWindowKey;
        }

        private Map<String, Object> getFlowScopedBeanMapForCurrentFlow() {
            if (null == this.flowBeansForClientWindowKey && null == this.creationalForClientWindowKey) {
                return Collections.emptyMap();
            }
            ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.sessionMap.get(this.flowBeansForClientWindowKey);
            if (null == concurrentHashMap) {
                concurrentHashMap = new ConcurrentHashMap();
                this.sessionMap.put(this.flowBeansForClientWindowKey, concurrentHashMap);
                FlowCDIContext.ensureBeanMapCleanupOnSessionDestroyed(this.sessionMap, this.flowBeansForClientWindowKey);
            }
            return concurrentHashMap;
        }

        private Map<String, CreationalContext<?>> getFlowScopedCreationalMapForCurrentFlow() {
            if (null == this.flowBeansForClientWindowKey && null == this.creationalForClientWindowKey) {
                return Collections.emptyMap();
            }
            ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.sessionMap.get(this.creationalForClientWindowKey);
            if (null == concurrentHashMap) {
                concurrentHashMap = new ConcurrentHashMap();
                this.sessionMap.put(this.creationalForClientWindowKey, concurrentHashMap);
                FlowCDIContext.ensureCreationalCleanupOnSessionDestroyed(this.sessionMap, this.creationalForClientWindowKey);
            }
            return concurrentHashMap;
        }

        private void updateSession() {
            if (null == this.flowBeansForClientWindowKey && null == this.creationalForClientWindowKey) {
                return;
            }
            this.sessionMap.put(this.flowBeansForClientWindowKey, this.getFlowScopedBeanMapForCurrentFlow());
            this.sessionMap.put(this.creationalForClientWindowKey, this.getFlowScopedCreationalMapForCurrentFlow());
            Object object = this.sessionMap.get(PER_SESSION_BEAN_MAP_LIST);
            if (null != object) {
                this.sessionMap.put(PER_SESSION_BEAN_MAP_LIST, object);
            }
            if (null != (object = this.sessionMap.get(PER_SESSION_CREATIONAL_LIST))) {
                this.sessionMap.put(PER_SESSION_CREATIONAL_LIST, object);
            }
        }
    }

    static class FlowBeanInfo {
        String definingDocumentId;
        String id;

        FlowBeanInfo() {
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FlowBeanInfo flowBeanInfo = (FlowBeanInfo)object;
            if (this.definingDocumentId == null ? flowBeanInfo.definingDocumentId != null : !this.definingDocumentId.equals(flowBeanInfo.definingDocumentId)) {
                return false;
            }
            return !(this.id == null ? flowBeanInfo.id != null : !this.id.equals(flowBeanInfo.id));
        }

        public int hashCode() {
            int n = 7;
            n = 79 * n + (this.definingDocumentId != null ? this.definingDocumentId.hashCode() : 0);
            n = 79 * n + (this.id != null ? this.id.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "FlowBeanInfo{definingDocumentId=" + this.definingDocumentId + ", id=" + this.id + '}';
        }
    }
}

