/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.el.ELUtils;
import com.sun.faces.taglib.jsf_core.AbstractConverterTag;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.NumberConverter;
import javax.servlet.jsp.JspException;

public class ConvertNumberTag
extends AbstractConverterTag {
    private static final long serialVersionUID = -2710405278792415110L;
    private static ValueExpression CONVERTER_ID_EXPR = null;
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private ValueExpression currencyCodeExpression;
    private ValueExpression currencySymbolExpression;
    private ValueExpression groupingUsedExpression;
    private ValueExpression integerOnlyExpression;
    private ValueExpression maxFractionDigitsExpression;
    private ValueExpression maxIntegerDigitsExpression;
    private ValueExpression minFractionDigitsExpression;
    private ValueExpression minIntegerDigitsExpression;
    private ValueExpression localeExpression;
    private ValueExpression patternExpression;
    private ValueExpression typeExpression;
    private String currencyCode;
    private String currencySymbol;
    private boolean groupingUsed;
    private boolean integerOnly;
    private int maxFractionDigits;
    private int maxIntegerDigits;
    private int minFractionDigits;
    private int minIntegerDigits;
    private Locale locale;
    private String pattern;
    private String type;
    private boolean maxFractionDigitsSpecified;
    private boolean maxIntegerDigitsSpecified;
    private boolean minFractionDigitsSpecified;
    private boolean minIntegerDigitsSpecified;

    public ConvertNumberTag() {
        this.init();
    }

    public void release() {
        super.release();
        this.init();
    }

    private void init() {
        this.currencyCode = null;
        this.currencyCodeExpression = null;
        this.currencySymbol = null;
        this.currencySymbolExpression = null;
        this.groupingUsed = true;
        this.groupingUsedExpression = null;
        this.integerOnly = false;
        this.integerOnlyExpression = null;
        this.maxFractionDigits = 0;
        this.maxFractionDigitsExpression = null;
        this.maxFractionDigitsSpecified = false;
        this.maxIntegerDigits = 0;
        this.maxIntegerDigitsExpression = null;
        this.maxIntegerDigitsSpecified = false;
        this.minFractionDigits = 0;
        this.minFractionDigitsExpression = null;
        this.minFractionDigitsSpecified = false;
        this.minIntegerDigits = 0;
        this.minIntegerDigitsExpression = null;
        this.minIntegerDigitsSpecified = false;
        this.locale = null;
        this.localeExpression = null;
        this.pattern = null;
        this.patternExpression = null;
        this.type = "number";
        this.typeExpression = null;
        if (CONVERTER_ID_EXPR == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
            CONVERTER_ID_EXPR = expressionFactory.createValueExpression(facesContext.getELContext(), "javax.faces.Number", String.class);
        }
    }

    public void setCurrencyCode(ValueExpression valueExpression) {
        this.currencyCodeExpression = valueExpression;
    }

    public void setCurrencySymbol(ValueExpression valueExpression) {
        this.currencySymbolExpression = valueExpression;
    }

    public void setGroupingUsed(ValueExpression valueExpression) {
        this.groupingUsedExpression = valueExpression;
    }

    public void setIntegerOnly(ValueExpression valueExpression) {
        this.integerOnlyExpression = valueExpression;
    }

    public void setMaxFractionDigits(ValueExpression valueExpression) {
        this.maxFractionDigitsExpression = valueExpression;
        this.maxFractionDigitsSpecified = true;
    }

    public void setMaxIntegerDigits(ValueExpression valueExpression) {
        this.maxIntegerDigitsExpression = valueExpression;
        this.maxIntegerDigitsSpecified = true;
    }

    public void setMinFractionDigits(ValueExpression valueExpression) {
        this.minFractionDigitsExpression = valueExpression;
        this.minFractionDigitsSpecified = true;
    }

    public void setMinIntegerDigits(ValueExpression valueExpression) {
        this.minIntegerDigitsExpression = valueExpression;
    }

    public void setLocale(ValueExpression valueExpression) {
        this.localeExpression = valueExpression;
    }

    public void setPattern(ValueExpression valueExpression) {
        this.patternExpression = valueExpression;
    }

    public void setType(ValueExpression valueExpression) {
        this.typeExpression = valueExpression;
    }

    public int doStartTag() throws JspException {
        super.setConverterId(CONVERTER_ID_EXPR);
        return super.doStartTag();
    }

    protected Converter createConverter() throws JspException {
        NumberConverter numberConverter = (NumberConverter)super.createConverter();
        assert (null != numberConverter);
        this.evaluateExpressions();
        numberConverter.setCurrencyCode(this.currencyCode);
        numberConverter.setCurrencySymbol(this.currencySymbol);
        numberConverter.setGroupingUsed(this.groupingUsed);
        numberConverter.setIntegerOnly(this.integerOnly);
        if (this.maxFractionDigitsSpecified) {
            numberConverter.setMaxFractionDigits(this.maxFractionDigits);
        }
        if (this.maxIntegerDigitsSpecified) {
            numberConverter.setMaxIntegerDigits(this.maxIntegerDigits);
        }
        if (this.minFractionDigitsSpecified) {
            numberConverter.setMinFractionDigits(this.minFractionDigits);
        }
        if (this.minIntegerDigitsSpecified) {
            numberConverter.setMinIntegerDigits(this.minIntegerDigits);
        }
        numberConverter.setLocale(this.locale);
        numberConverter.setPattern(this.pattern);
        numberConverter.setType(this.type);
        return numberConverter;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void evaluateExpressions() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext eLContext = facesContext.getELContext();
        if (this.currencyCodeExpression != null) {
            this.currencyCode = (String)ELUtils.evaluateValueExpression(this.currencyCodeExpression, eLContext);
        }
        if (this.currencySymbolExpression != null) {
            this.currencySymbol = (String)ELUtils.evaluateValueExpression(this.currencySymbolExpression, eLContext);
        }
        if (this.patternExpression != null) {
            this.pattern = (String)ELUtils.evaluateValueExpression(this.patternExpression, eLContext);
        }
        if (this.typeExpression != null) {
            this.type = (String)ELUtils.evaluateValueExpression(this.typeExpression, eLContext);
        }
        if (this.groupingUsedExpression != null) {
            this.groupingUsed = this.groupingUsedExpression.isLiteralText() ? Boolean.valueOf(this.groupingUsedExpression.getExpressionString()).booleanValue() : ((Boolean)ELUtils.evaluateValueExpression(this.groupingUsedExpression, eLContext)).booleanValue();
        }
        if (this.integerOnlyExpression != null) {
            this.integerOnly = this.integerOnlyExpression.isLiteralText() ? Boolean.valueOf(this.integerOnlyExpression.getExpressionString()).booleanValue() : ((Boolean)ELUtils.evaluateValueExpression(this.integerOnlyExpression, eLContext)).booleanValue();
        }
        if (this.maxFractionDigitsExpression != null) {
            this.maxFractionDigits = this.maxFractionDigitsExpression.isLiteralText() ? Integer.valueOf(this.maxFractionDigitsExpression.getExpressionString()).intValue() : ((Integer)ELUtils.evaluateValueExpression(this.maxFractionDigitsExpression, eLContext)).intValue();
        }
        if (this.maxIntegerDigitsExpression != null) {
            this.maxIntegerDigits = this.maxIntegerDigitsExpression.isLiteralText() ? Integer.valueOf(this.maxIntegerDigitsExpression.getExpressionString()).intValue() : ((Integer)ELUtils.evaluateValueExpression(this.maxIntegerDigitsExpression, eLContext)).intValue();
        }
        if (this.minFractionDigitsExpression != null) {
            this.minFractionDigits = this.minFractionDigitsExpression.isLiteralText() ? Integer.valueOf(this.minFractionDigitsExpression.getExpressionString()).intValue() : ((Integer)ELUtils.evaluateValueExpression(this.minFractionDigitsExpression, eLContext)).intValue();
        }
        if (this.minIntegerDigitsExpression != null) {
            this.minIntegerDigits = this.minIntegerDigitsExpression.isLiteralText() ? Integer.valueOf(this.minIntegerDigitsExpression.getExpressionString()).intValue() : ((Integer)ELUtils.evaluateValueExpression(this.minIntegerDigitsExpression, eLContext)).intValue();
        }
        if (this.localeExpression == null) return;
        if (this.localeExpression.isLiteralText()) {
            this.locale = ConvertNumberTag.getLocale(this.localeExpression.getExpressionString());
            return;
        }
        Object object = ELUtils.evaluateValueExpression(this.localeExpression, eLContext);
        if (object == null) {
            this.locale = facesContext.getViewRoot().getLocale();
            return;
        }
        if (object instanceof String) {
            this.locale = ConvertNumberTag.getLocale((String)object);
            return;
        }
        if (object instanceof Locale) {
            this.locale = (Locale)object;
            return;
        }
        Object[] objectArray = new Object[]{"locale", "java.lang.String or java.util.Locale", object.getClass().getName()};
        if (!LOGGER.isLoggable(Level.SEVERE)) throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EVAL_ATTR_UNEXPECTED_TYPE", objectArray));
        LOGGER.log(Level.SEVERE, "jsf.core.tags.eval_result_not_expected_type", objectArray);
        throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EVAL_ATTR_UNEXPECTED_TYPE", objectArray));
    }

    protected static Locale getLocale(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        if (string.length() > 2) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.core.taglib.invalid_locale_value", string);
            }
        } else {
            Object[] objectArray = Locale.getISOLanguages();
            Arrays.sort(objectArray);
            if (Arrays.binarySearch(objectArray, string) < 0 && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.core.taglib.invalid_language", string);
            }
        }
        return new Locale(string, "");
    }
}

