/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;

public class FormRenderer
extends HtmlBasicRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.FORMFORM);
    private boolean writeStateAtEnd;

    public FormRenderer() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.writeStateAtEnd = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.WriteStateAtFormEnd);
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        Map requestParameterMap;
        this.rendererParamsNotNull(context, component);
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        if ((requestParameterMap = context.getExternalContext().getRequestParameterMap()).containsKey(clientId)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "UIForm with client ID {0}, submitted", clientId);
            }
            ((UIForm)component).setSubmitted(true);
        } else {
            ((UIForm)component).setSubmitted(false);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String acceptcharset;
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = component.getClientId(context);
        writer.write(10);
        writer.startElement("form", component);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("method", (Object)"post", null);
        writer.writeAttribute("action", (Object)FormRenderer.getActionStr(context), null);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if ((acceptcharset = (String)component.getAttributes().get("acceptcharset")) != null) {
            writer.writeAttribute("accept-charset", (Object)acceptcharset, "acceptcharset");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES);
        writer.writeText((Object)"\n", component, null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("name", (Object)clientId, "clientId");
        writer.writeAttribute("value", (Object)clientId, "value");
        writer.endElement("input");
        writer.write(10);
        UIViewRoot viewRoot = context.getViewRoot();
        String viewId = viewRoot.getViewId();
        String actionURL = context.getApplication().getViewHandler().getActionURL(context, viewId);
        ExternalContext externalContext = context.getExternalContext();
        String encodedActionURL = externalContext.encodeActionURL(actionURL);
        String encodedPartialActionURL = externalContext.encodePartialActionURL(actionURL);
        if (encodedPartialActionURL != null && !encodedPartialActionURL.equals(encodedActionURL)) {
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"hidden", "type");
            writer.writeAttribute("name", (Object)RenderKitUtils.getParameterName(context, "jakarta.faces.encodedURL"), null);
            writer.writeAttribute("value", (Object)encodedPartialActionURL, "value");
            writer.endElement("input");
            writer.write(10);
        }
        if (!this.writeStateAtEnd) {
            context.getApplication().getViewHandler().writeState(context);
            writer.write(10);
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        UIViewRoot viewRoot = context.getViewRoot();
        ListIterator iter = viewRoot.getComponentResources(context, "form").listIterator();
        while (iter.hasNext()) {
            UIComponent resource = (UIComponent)iter.next();
            resource.encodeAll(context);
        }
        if (this.writeStateAtEnd) {
            context.getApplication().getViewHandler().writeState(context);
        }
        writer.writeText((Object)"\n", component, null);
        writer.endElement("form");
    }

    private static String getActionStr(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String actionURL = context.getApplication().getViewHandler().getActionURL(context, viewId);
        return context.getExternalContext().encodeActionURL(actionURL);
    }
}

