/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.OutcomeTargetRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

public class OutcomeTargetButtonRenderer
extends OutcomeTargetRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.OUTCOMETARGETBUTTON);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String imageSrc = (String)component.getAttributes().get("image");
        if (imageSrc != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            writer.writeURIAttribute("src", (Object)RenderKitUtils.getImageSource(context, component, "image"), "image");
            String alt = (String)component.getAttributes().get("alt");
            if (alt == null) {
                writer.writeAttribute("alt", (Object)alt, "alt");
            } else if (writer.getContentType().equals("application/xhtml+xml")) {
                writer.writeAttribute("alt", (Object)"", "alt");
            }
        } else {
            writer.writeAttribute("type", (Object)"button", "type");
        }
        Object label = this.getLabel(component);
        if (!Util.componentIsDisabled(component)) {
            NavigationCase navCase = this.getNavigationCase(context, component);
            if (navCase == null) {
                label = (String)label + MessageUtils.getExceptionMessageString("com.sun.faces.OUTCOME_TARGET_BUTTON_NO_MATCH", new Object[0]);
                writer.writeAttribute("disabled", (Object)"true", "disabled");
            } else {
                Object hrefVal = this.getEncodedTargetURL(context, component, navCase);
                hrefVal = (String)hrefVal + this.getFragment(component);
                writer.writeAttribute("onclick", (Object)this.getOnclick(component, (String)hrefVal), "onclick");
            }
        }
        writer.writeAttribute("value", label, "value");
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null && styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        this.renderPassThruAttributes(context, writer, component, ATTRIBUTES, null);
        if (component.getChildCount() == 0) {
            writer.endElement("input");
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (component.getChildCount() > 0) {
            context.getResponseWriter().endElement("input");
        }
    }

    protected String getOnclick(UIComponent component, String targetURI) {
        Object onclick = (String)component.getAttributes().get("onclick");
        if (onclick != null) {
            if (((String)(onclick = ((String)onclick).trim())).length() > 0 && !((String)onclick).endsWith(";")) {
                onclick = (String)onclick + "; ";
            }
        } else {
            onclick = "";
        }
        if (targetURI != null) {
            onclick = (String)onclick + "window.location.href='" + targetURI + "'; ";
        }
        onclick = (String)onclick + "return false;";
        return onclick;
    }
}

