/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.TagHandlerFactory;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.UserTagHandler;
import com.sun.faces.facelets.tag.faces.CompositeComponentTagHandler;
import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.BehaviorConfig;
import jakarta.faces.view.facelets.BehaviorHandler;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.ConverterConfig;
import jakarta.faces.view.facelets.ConverterHandler;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import jakarta.faces.view.facelets.ValidatorConfig;
import jakarta.faces.view.facelets.ValidatorHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTagLibrary
implements TagLibrary {
    private final Map factories;
    private final String namespace;
    private final Map functions;

    public AbstractTagLibrary(String namespace) {
        this.namespace = namespace;
        this.factories = new HashMap();
        this.functions = new HashMap();
    }

    protected final void addComponent(String name, String componentType, String rendererType) {
        this.factories.put(name, new ComponentHandlerFactory(componentType, rendererType));
    }

    protected final void addComponent(String name, String componentType, String rendererType, Class handlerType) {
        this.factories.put(name, new UserComponentHandlerFactory(componentType, rendererType, handlerType));
    }

    protected final void addConverter(String name, String converterId) {
        this.factories.put(name, new ConverterHandlerFactory(converterId));
    }

    protected final void addConverter(String name, String converterId, Class type) {
        this.factories.put(name, new UserConverterHandlerFactory(converterId, type));
    }

    protected final void addValidator(String name, String validatorId) {
        this.factories.put(name, new ValidatorHandlerFactory(validatorId));
    }

    protected final void addValidator(String name, String validatorId, Class type) {
        this.factories.put(name, new UserValidatorHandlerFactory(validatorId, type));
    }

    protected final void addBehavior(String name, String behaviorId) {
        this.factories.put(name, new BehaviorHandlerFactory(behaviorId));
    }

    protected final void addBehavior(String name, String behaviorId, Class type) {
        this.factories.put(name, new UserBehaviorHandlerFactory(behaviorId, type));
    }

    protected final void addTagHandler(String name, Class handlerType) {
        this.factories.put(name, new HandlerFactory(handlerType));
    }

    protected final void addUserTag(String name, URL source) {
        this.factories.put(name, new UserTagFactory(source));
    }

    protected final void addCompositeComponentTag(String name, String resourceId) {
        this.factories.put(name, new CompositeComponentTagFactory(resourceId));
    }

    protected final void addFunction(String name, Method method) {
        this.functions.put(name, method);
    }

    @Override
    public boolean containsNamespace(String ns, Tag t) {
        return this.namespace.equals(ns);
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        return this.namespace.equals(ns) && this.factories.containsKey(localName);
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        TagHandlerFactory f;
        if (this.namespace.equals(ns) && (f = (TagHandlerFactory)this.factories.get(localName)) != null) {
            return f.createHandler(tag);
        }
        return null;
    }

    @Override
    public boolean containsFunction(String ns, String name) {
        if (this.namespace.equals(ns)) {
            return this.functions.containsKey(name);
        }
        return false;
    }

    @Override
    public Method createFunction(String ns, String name) {
        if (this.namespace.equals(ns)) {
            return (Method)this.functions.get(name);
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof TagLibrary && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public String getNamespace() {
        return this.namespace;
    }

    private static class ComponentHandlerFactory
    implements TagHandlerFactory {
        protected final String componentType;
        protected final String renderType;

        public ComponentHandlerFactory(String componentType, String renderType) {
            this.componentType = componentType;
            this.renderType = renderType;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
            return new ComponentHandler((ComponentConfig)ccfg);
        }
    }

    private static class UserComponentHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ComponentConfig.class};
        protected final String componentType;
        protected final String renderType;
        protected final Class type;
        protected final Constructor constructor;

        public UserComponentHandlerFactory(String componentType, String renderType, Class type) {
            this.componentType = componentType;
            this.renderType = renderType;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new FaceletException("Must have a Constructor that takes in a ComponentConfig", (Throwable)e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
                return (TagHandler)this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new FaceletException("Error Instantiating ComponentHandler: " + this.type.getName(), (Throwable)e);
            }
        }
    }

    private static class ConverterHandlerFactory
    implements TagHandlerFactory {
        protected final String converterId;

        public ConverterHandlerFactory(String converterId) {
            this.converterId = converterId;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new ConverterHandler((ConverterConfig)new ConverterConfigWrapper(cfg, this.converterId));
        }
    }

    private static class UserConverterHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ConverterConfig.class};
        protected final String converterId;
        protected final Class type;
        protected final Constructor constructor;

        public UserConverterHandlerFactory(String converterId, Class type) {
            this.converterId = converterId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new FaceletException("Must have a Constructor that takes in a ConverterConfig", (Throwable)e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ConverterConfigWrapper ccfg = new ConverterConfigWrapper(cfg, this.converterId);
                return (TagHandler)this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new FaceletException("Error Instantiating ConverterHandler: " + this.type.getName(), (Throwable)e);
            }
        }
    }

    private static class ValidatorHandlerFactory
    implements TagHandlerFactory {
        protected final String validatorId;

        public ValidatorHandlerFactory(String validatorId) {
            this.validatorId = validatorId;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new ValidatorHandler((ValidatorConfig)new ValidatorConfigWrapper(cfg, this.validatorId));
        }
    }

    private static class UserValidatorHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ValidatorConfig.class};
        protected final String validatorId;
        protected final Class type;
        protected final Constructor constructor;

        public UserValidatorHandlerFactory(String validatorId, Class type) {
            this.validatorId = validatorId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new FaceletException("Must have a Constructor that takes in a ValidatorConfig", (Throwable)e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ValidatorConfigWrapper ccfg = new ValidatorConfigWrapper(cfg, this.validatorId);
                return (TagHandler)this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new FaceletException("Error Instantiating ValidatorHandler: " + this.type.getName(), (Throwable)e);
            }
        }
    }

    private static final class BehaviorHandlerFactory
    implements TagHandlerFactory {
        private final String behaviorId;

        public BehaviorHandlerFactory(String behaviorId) {
            this.behaviorId = behaviorId;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new BehaviorHandler((BehaviorConfig)new BehaviorConfigWrapper(cfg, this.behaviorId));
        }
    }

    private static class UserBehaviorHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{BehaviorConfig.class};
        protected final String behaviorId;
        protected final Class type;
        protected final Constructor constructor;

        public UserBehaviorHandlerFactory(String behaviorId, Class type) {
            this.behaviorId = behaviorId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new FaceletException("Must have a Constructor that takes in a BehaviorConfig", (Throwable)e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                BehaviorConfigWrapper ccfg = new BehaviorConfigWrapper(cfg, this.behaviorId);
                return (TagHandler)this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new FaceletException("Error Instantiating BehaviorHandler: " + this.type.getName(), (Throwable)e);
            }
        }
    }

    private static class HandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONSTRUCTOR_SIG = new Class[]{TagConfig.class};
        protected final Class handlerType;

        public HandlerFactory(Class handlerType) {
            this.handlerType = handlerType;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                return (TagHandler)this.handlerType.getConstructor(CONSTRUCTOR_SIG).newInstance(cfg);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof FacesException) {
                    throw (FacesException)t;
                }
                if (t instanceof ELException) {
                    throw (ELException)t;
                }
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), t);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), (Throwable)e);
            }
        }
    }

    private static class UserTagFactory
    implements TagHandlerFactory {
        protected final URL location;

        public UserTagFactory(URL location) {
            this.location = location;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new UserTagHandler(cfg, this.location);
        }
    }

    private static class CompositeComponentTagFactory
    implements TagHandlerFactory {
        protected final String resourceId;

        public CompositeComponentTagFactory(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            ComponentConfigWrapper componentConfig = new ComponentConfigWrapper(cfg, "jakarta.faces.NamingContainer", "jakarta.faces.Composite");
            ResourceHandler resourceHandler = FacesContext.getCurrentInstance().getApplication().getResourceHandler();
            CompositeComponentTagHandler result = null;
            Resource resource = resourceHandler.createResourceFromId(this.resourceId);
            if (null == resource) {
                Location loc = new Location(this.resourceId, 0, 0);
                Tag tag = new Tag(loc, "", "", "", null);
                throw new TagException(tag, "Cannot create composite component tag handler for composite-source element in taglib.xml file");
            }
            result = new CompositeComponentTagHandler(resource, componentConfig);
            return result;
        }
    }

    protected static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig parent, String componentType, String rendererType) {
            this.parent = parent;
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static final class BehaviorConfigWrapper
    implements BehaviorConfig {
        private final TagConfig parent;
        private final String behaviorId;

        public BehaviorConfigWrapper(TagConfig parent, String behaviorId) {
            this.parent = parent;
            this.behaviorId = behaviorId;
        }

        public String getBehaviorId() {
            return this.behaviorId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ConverterConfigWrapper
    implements ConverterConfig {
        private final TagConfig parent;
        private final String converterId;

        public ConverterConfigWrapper(TagConfig parent, String converterId) {
            this.parent = parent;
            this.converterId = converterId;
        }

        public String getConverterId() {
            return this.converterId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ValidatorConfigWrapper
    implements ValidatorConfig {
        private final TagConfig parent;
        private final String validatorId;

        public ValidatorConfigWrapper(TagConfig parent, String validatorId) {
            this.parent = parent;
            this.validatorId = validatorId;
        }

        public String getValidatorId() {
            return this.validatorId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }
}

