/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import jakarta.faces.component.UICommand;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CommandLinkRenderer
extends LinkRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.COMMANDLINK);

    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (CommandLinkRenderer.wasClicked(context, component, clientId)) {
            component.queueEvent((FacesEvent)new ActionEvent(context, component));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("This commandLink resulted in form submission  ActionEvent queued.");
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        boolean componentDisabled = Boolean.TRUE.equals(component.getAttributes().get("disabled"));
        if (componentDisabled) {
            this.renderAsDisabled(context, component);
        } else {
            RenderKitUtils.renderFacesJsIfNecessary(context);
            this.renderAsActive(context, component);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (Boolean.TRUE.equals(component.getAttributes().get("disabled"))) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected Object getValue(UIComponent component) {
        return ((UICommand)component).getValue();
    }

    @Override
    protected void renderAsActive(FacesContext context, UIComponent command) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("a", command);
        this.writeIdAttributeIfNecessary(context, writer, command);
        writer.writeAttribute("href", (Object)"#", "href");
        RenderKitUtils.renderPassThruAttributes(context, writer, command, ATTRIBUTES, CommandLinkRenderer.getNonOnClickBehaviors(command));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, command);
        String target = (String)command.getAttributes().get("target");
        target = target != null ? target.trim() : "";
        Collection<ClientBehaviorContext.Parameter> params = this.getBehaviorParameters(command);
        RenderKitUtils.renderOnclick(context, command, params, target, true);
        this.writeCommonLinkAttributes(writer, command);
        this.writeValue(command, writer);
        writer.flush();
    }

    private static boolean wasClicked(FacesContext context, UIComponent component, String clientId) {
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        return requestParamMap.containsKey(clientId) || RenderKitUtils.isPartialOrBehaviorAction(context, clientId);
    }

    private static Map<String, List<ClientBehavior>> getNonOnClickBehaviors(UIComponent component) {
        return CommandLinkRenderer.getPassThruBehaviors(component, "click", "action");
    }
}

