/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tlddoc;

import com.sun.tlddoc.GeneratorException;
import com.sun.tlddoc.TagLibrary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TLDFileTagLibrary
extends TagLibrary {
    private File tldFile;

    public TLDFileTagLibrary(File tldFile) {
        this.tldFile = tldFile;
    }

    public String getPathDescription() {
        return this.tldFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getTLDDocument(DocumentBuilder documentBuilder) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, GeneratorException {
        Document result;
        FileInputStream in = new FileInputStream(this.tldFile);
        try {
            InputSource source = new InputSource(in);
            result = documentBuilder.parse(source);
        }
        finally {
            in.close();
        }
        return result;
    }

    public InputStream getResource(String path) throws IOException {
        FileInputStream result = null;
        File dir = this.tldFile.getParentFile();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        File look = null;
        while (dir != null && !(look = new File(dir, path)).exists()) {
            dir = dir.getParentFile();
        }
        if (look != null && look.exists()) {
            result = new FileInputStream(look);
        }
        return result;
    }
}

