/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LocaleBCP47;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.ViewMetadata;

public class MultiViewHandler
extends ViewHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private static final String DELIMITER = "\\ufffe";
    private String[] configuredExtensions;
    private boolean extensionsSet;
    private ViewDeclarationLanguageFactory vdlFactory;

    public MultiViewHandler() {
        WebConfiguration config = WebConfiguration.getInstance();
        this.configuredExtensions = config.getOptionValue(WebConfiguration.WebContextInitParameter.DefaultSuffix, " ");
        this.extensionsSet = config.isSet(WebConfiguration.WebContextInitParameter.DefaultSuffix);
        this.vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory("javax.faces.view.ViewDeclarationLanguageFactory");
    }

    @Override
    public void initView(FacesContext context) throws FacesException {
        super.initView(context);
    }

    @Override
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        Util.notNull("context", context);
        Util.notNull("viewToRender", viewToRender);
        this.vdlFactory.getViewDeclarationLanguage(viewToRender.getViewId()).renderView(context, viewToRender);
    }

    @Override
    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String actualViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(actualViewId).restoreView(context, actualViewId);
    }

    @Override
    public UIViewRoot createView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String actualViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(actualViewId).createView(context, actualViewId);
    }

    @Override
    public Locale calculateLocale(FacesContext context) {
        Util.notNull("context", context);
        Locale result = this.calculateLocaleWithLanguageTag(context);
        if (null == result) {
            result = this.calculateLocaleWithoutLanguageTag(context);
        }
        return result;
    }

    private Locale calculateLocaleWithLanguageTag(FacesContext context) {
        Locale result = null;
        Iterator<Locale> supportedLocales = context.getApplication().getSupportedLocales();
        String requestLocale = context.getExternalContext().getRequestHeaderMap().get("ACCEPT-LANGUAGE");
        if (null == requestLocale) {
            requestLocale = context.getExternalContext().getRequestHeaderMap().get("Accept-Language");
        }
        if (null != requestLocale) {
            result = this.findMatchWithLanguageTag(requestLocale, supportedLocales);
        }
        return result;
    }

    private Locale calculateLocaleWithoutLanguageTag(FacesContext context) {
        Locale perf;
        Locale result = null;
        Iterator<Locale> locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext() && (result = this.findMatch(context, perf = locales.next())) == null) {
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    @Override
    public String calculateRenderKitId(FacesContext context) {
        Util.notNull("context", context);
        Map<String, String> requestParamMap = context.getExternalContext().getRequestParameterMap();
        String result = requestParamMap.get("javax.faces.RenderKitId");
        if (result == null && null == (result = context.getApplication().getDefaultRenderKitId())) {
            result = "HTML_BASIC";
        }
        return result;
    }

    @Override
    public void writeState(FacesContext context) throws IOException {
        Util.notNull("context", context);
        if (!context.getPartialViewContext().isAjaxRequest()) {
            WriteBehindStateWriter writer;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Begin writing marker for viewId " + context.getViewRoot().getViewId());
            }
            if ((writer = WriteBehindStateWriter.getCurrentInstance()) != null) {
                writer.writingState();
            }
            context.getResponseWriter().write("~com.sun.faces.saveStateFieldMarker~");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End writing marker for viewId " + context.getViewRoot().getViewId());
            }
        }
    }

    @Override
    public String getActionURL(FacesContext context, String viewId) {
        Util.notNull("context", context);
        Util.notNull("viewId", viewId);
        if (0 == viewId.length() || viewId.charAt(0) != '/') {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", viewId);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "jsf.illegal_view_id_error", viewId);
            }
            throw new IllegalArgumentException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String contextPath = extContext.getRequestContextPath();
        String mapping = Util.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (Util.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(46);
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            for (String ext : this.configuredExtensions) {
                if (!viewId.endsWith(ext)) continue;
                return contextPath + viewId.substring(0, viewId.indexOf(ext)) + mapping;
            }
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    @Override
    public String getResourceURL(FacesContext context, String path) {
        ExternalContext extContext = context.getExternalContext();
        if (path.charAt(0) == '/') {
            return extContext.getRequestContextPath() + path;
        }
        return path;
    }

    @Override
    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        Map<String, List<String>> params = includeViewParams ? this.getFullParameterList(context, viewId, parameters) : parameters;
        ExternalContext ectx = context.getExternalContext();
        return ectx.encodeActionURL(ectx.encodeBookmarkableURL(Util.getViewHandler(context).getActionURL(context, viewId), params));
    }

    @Override
    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        Map<String, List<String>> params = includeViewParams ? this.getFullParameterList(context, viewId, parameters) : parameters;
        ExternalContext ectx = context.getExternalContext();
        return ectx.encodeActionURL(ectx.encodeRedirectURL(Util.getViewHandler(context).getActionURL(context, viewId), params));
    }

    @Override
    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return this.vdlFactory.getViewDeclarationLanguage(viewId);
    }

    @Override
    public String deriveViewId(FacesContext context, String rawViewId) {
        return this.derivePhysicalViewId(context, rawViewId, true);
    }

    @Override
    public String deriveLogicalViewId(FacesContext context, String rawViewId) {
        return this.derivePhysicalViewId(context, rawViewId, false);
    }

    protected String normalizeRequestURI(String uri, String mapping) {
        if (mapping == null || !Util.isPrefixMapped(mapping)) {
            return uri;
        }
        int length = mapping.length() + 1;
        StringBuilder builder = new StringBuilder(length);
        builder.append(mapping).append('/');
        String mappingMod = builder.toString();
        boolean logged = false;
        while (uri.startsWith(mappingMod)) {
            if (!logged && logger.isLoggable(Level.WARNING)) {
                logged = true;
                logger.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{uri, mapping});
            }
            uri = uri.substring(length - 1);
        }
        return uri;
    }

    protected String convertViewId(FacesContext context, String viewId) {
        int extIdx = viewId.lastIndexOf(46);
        int length = viewId.length();
        StringBuilder buffer = new StringBuilder(length);
        for (String ext : this.configuredExtensions) {
            if (viewId.endsWith(ext)) {
                return viewId;
            }
            this.appendOrReplaceExtension(viewId, ext, length, extIdx, buffer);
            String convertedViewId = buffer.toString();
            ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(context, convertedViewId);
            if (!vdl.viewExists(context, convertedViewId)) continue;
            return convertedViewId;
        }
        return this.legacyConvertViewId(viewId, length, extIdx, buffer);
    }

    protected String derivePhysicalViewId(FacesContext ctx, String rawViewId, boolean checkPhysical) {
        String mapping;
        if (rawViewId != null && (mapping = Util.getFacesMapping(ctx)) != null) {
            String viewId;
            if (!Util.isPrefixMapped(mapping)) {
                viewId = this.convertViewId(ctx, rawViewId);
            } else {
                viewId = this.normalizeRequestURI(rawViewId, mapping);
                if (viewId.equals(mapping)) {
                    this.send404Error(ctx);
                }
            }
            if (checkPhysical) {
                ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(ctx, viewId);
                return vdl.viewExists(ctx, viewId) ? viewId : null;
            }
            return viewId;
        }
        return rawViewId;
    }

    protected Map<String, List<String>> getFullParameterList(FacesContext ctx, String viewId, Map<String, List<String>> existingParameters) {
        LinkedHashMap<Object, Object> copy = existingParameters == null || existingParameters.isEmpty() ? new LinkedHashMap(4) : new LinkedHashMap<String, List<String>>(existingParameters);
        this.addViewParameters(ctx, viewId, copy);
        return copy;
    }

    protected void addViewParameters(FacesContext ctx, String viewId, Map<String, List<String>> existingParameters) {
        UIViewRoot currentRoot = ctx.getViewRoot();
        String currentViewId = currentRoot.getViewId();
        Collection<Object> toViewParams = Collections.emptyList();
        boolean currentIsSameAsNew = false;
        Collection<UIViewParameter> currentViewParams = ViewMetadata.getViewParameters(currentRoot);
        if (currentViewId.equals(viewId)) {
            currentIsSameAsNew = true;
            toViewParams = currentViewParams;
        } else {
            ViewDeclarationLanguage pdl = this.getViewDeclarationLanguage(ctx, viewId);
            ViewMetadata viewMetadata = pdl.getViewMetadata(ctx, viewId);
            if (null != viewMetadata) {
                UIViewRoot root = viewMetadata.createMetadataView(ctx);
                toViewParams = ViewMetadata.getViewParameters(root);
            }
        }
        if (toViewParams.isEmpty()) {
            return;
        }
        for (UIViewParameter uIViewParameter : toViewParams) {
            String value = null;
            if (existingParameters.containsKey(uIViewParameter.getName())) continue;
            if (MultiViewHandler.paramHasValueExpression(uIViewParameter)) {
                value = uIViewParameter.getStringValueFromModel(ctx);
            }
            if (value == null) {
                value = currentIsSameAsNew ? uIViewParameter.getStringValue(ctx) : MultiViewHandler.getStringValueToTransfer(ctx, uIViewParameter, currentViewParams);
            }
            if (value == null) continue;
            List<String> existing = existingParameters.get(uIViewParameter.getName());
            if (existing == null) {
                existing = new ArrayList<String>(4);
                existingParameters.put(uIViewParameter.getName(), existing);
            }
            existing.add(value);
        }
    }

    protected Locale findMatch(FacesContext context, Locale pref) {
        Locale defaultLocale;
        Locale result = null;
        Iterator<Locale> it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = it.next();
            if (pref.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!pref.getLanguage().equals(supportedLocale.getLanguage()) || supportedLocale.getCountry().length() != 0) continue;
            result = supportedLocale;
        }
        if (null == result && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (pref.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (pref.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().length() == 0) {
                result = defaultLocale;
            }
        }
        return result;
    }

    private Locale findMatchWithLanguageTag(String priorityList, Iterator<Locale> locales) {
        ArrayList<Locale> locs = new ArrayList<Locale>();
        while (locales.hasNext()) {
            locs.add(locales.next());
        }
        if (priorityList.isEmpty() || locs.isEmpty()) {
            return null;
        }
        return this.findMatchWithLanguageTag(this.parseAcceptedLang(priorityList), locs);
    }

    private Locale findMatchWithLanguageTag(List<String> priorityList, Collection<Locale> locales) {
        if (priorityList.isEmpty()) {
            return null;
        }
        StringBuffer localesBuf = new StringBuffer();
        for (Locale locale : locales) {
            if (locale.getLanguage().isEmpty()) continue;
            localesBuf.append(locale.getLanguage());
            if (!locale.getCountry().isEmpty()) {
                localesBuf.append("-" + locale.getCountry());
            }
            localesBuf.append(DELIMITER);
        }
        String localesStr = localesBuf.toString();
        for (String langtag : priorityList) {
            Locale locale = this.lookupTag(langtag, localesStr);
            if (locale == null) continue;
            return locale;
        }
        return null;
    }

    private Locale lookupTag(String langtag, String localesStr) {
        LocaleBCP47 tag = LocaleBCP47.parse(langtag);
        if (tag == null) {
            return null;
        }
        String language = tag.getLanguage();
        if (localesStr.indexOf(tag.toLangtag() + DELIMITER) != -1) {
            return new Locale(tag.getLanguage(), tag.getRegion());
        }
        if (localesStr.indexOf(language + DELIMITER) != -1) {
            return new Locale(language);
        }
        if (language.matches("n[nb]")) {
            if (localesStr.indexOf(tag.toLangtag("no") + DELIMITER) != -1) {
                return new Locale("no", tag.getRegion());
            }
            if (localesStr.indexOf("no\\ufffe") != -1) {
                return new Locale("no");
            }
        }
        return null;
    }

    private List<String> parseAcceptedLang(String acceptedLang) {
        String[] strArray;
        ArrayList<Float> qvalues = new ArrayList<Float>();
        ArrayList<String> pList = new ArrayList<String>();
        for (String str : strArray = acceptedLang.split(",")) {
            int index;
            if (str.isEmpty()) continue;
            String[] keyValue = str.split(";");
            Float qval = Float.valueOf(1.0f);
            if (keyValue.length > 1) {
                qval = Float.valueOf(Float.parseFloat(keyValue[1].substring(2)));
            }
            for (index = 0; index < qvalues.size() && !(qval.floatValue() > ((Float)qvalues.get(index)).floatValue()); ++index) {
            }
            pList.add(index, keyValue[0]);
            qvalues.add(index, qval);
        }
        return pList;
    }

    protected void send404Error(FacesContext context) {
        try {
            context.responseComplete();
            context.getExternalContext().responseSendError(404, "");
        }
        catch (IOException ioe) {
            throw new FacesException(ioe);
        }
    }

    private static boolean paramHasValueExpression(UIViewParameter param) {
        return param.getValueExpression("value") != null;
    }

    private static String getStringValueToTransfer(FacesContext context, UIViewParameter param, Collection<UIViewParameter> viewParams) {
        if (viewParams != null && !viewParams.isEmpty()) {
            for (UIViewParameter candidate : viewParams) {
                if (null == candidate.getName() || null == param.getName() || !candidate.getName().equals(param.getName())) continue;
                return candidate.getStringValue(context);
            }
        }
        return param.getStringValue(context);
    }

    private void appendOrReplaceExtension(String viewId, String ext, int length, int extIdx, StringBuilder buffer) {
        buffer.setLength(0);
        buffer.append(viewId);
        if (extIdx != -1) {
            buffer.replace(extIdx, length, ext);
        } else {
            buffer.append(ext);
        }
    }

    private String legacyConvertViewId(String viewId, int length, int extIdx, StringBuilder buffer) {
        String ext;
        String string = ext = this.extensionsSet && this.configuredExtensions.length != 0 ? this.configuredExtensions[0] : ".jsp";
        if (viewId.endsWith(ext)) {
            return viewId;
        }
        this.appendOrReplaceExtension(viewId, ext, length, extIdx, buffer);
        return buffer.toString();
    }
}

